/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.config;

import ch.qos.logback.classic.LoggerContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.jhipster.config.JHipsterProperties;
import io.github.jhipster.config.logging.LoggingUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B)\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/shiftphones/shifternetzwerk/config/LoggingConfiguration;", "", "appName", "", "serverPort", "jHipsterProperties", "Lio/github/jhipster/config/JHipsterProperties;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Ljava/lang/String;Ljava/lang/String;Lio/github/jhipster/config/JHipsterProperties;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "shifternetzwerk"})
public class LoggingConfiguration {
    public LoggingConfiguration(@Value(value="${spring.application.name}") @NotNull String appName, @Value(value="${server.port}") @NotNull String serverPort, @NotNull JHipsterProperties jHipsterProperties, @NotNull ObjectMapper mapper) {
        JHipsterProperties.Logging loggingProperties;
        Intrinsics.checkParameterIsNotNull((Object)appName, (String)"appName");
        Intrinsics.checkParameterIsNotNull((Object)serverPort, (String)"serverPort");
        Intrinsics.checkParameterIsNotNull((Object)jHipsterProperties, (String)"jHipsterProperties");
        Intrinsics.checkParameterIsNotNull((Object)mapper, (String)"mapper");
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        if (iLoggerFactory == null) {
            throw new TypeCastException("null cannot be cast to non-null type ch.qos.logback.classic.LoggerContext");
        }
        LoggerContext context = (LoggerContext)iLoggerFactory;
        boolean bl = false;
        Map map = new LinkedHashMap();
        map.put("app_name", appName);
        map.put("app_port", serverPort);
        String customFields = mapper.writeValueAsString((Object)map);
        JHipsterProperties.Logging logging = loggingProperties = jHipsterProperties.getLogging();
        Intrinsics.checkExpressionValueIsNotNull((Object)logging, (String)"loggingProperties");
        JHipsterProperties.Logging.Logstash logstashProperties = logging.getLogstash();
        if (loggingProperties.isUseJsonFormat()) {
            LoggingUtils.addJsonConsoleAppender((LoggerContext)context, (String)customFields);
        }
        JHipsterProperties.Logging.Logstash logstash = logstashProperties;
        Intrinsics.checkExpressionValueIsNotNull((Object)logstash, (String)"logstashProperties");
        if (logstash.isEnabled()) {
            LoggingUtils.addLogstashTcpSocketAppender((LoggerContext)context, (String)customFields, (JHipsterProperties.Logging.Logstash)logstashProperties);
        }
        if (loggingProperties.isUseJsonFormat() || logstashProperties.isEnabled()) {
            LoggingUtils.addContextListener((LoggerContext)context, (String)customFields, (JHipsterProperties.Logging)loggingProperties);
        }
        JHipsterProperties.Metrics metrics = jHipsterProperties.getMetrics();
        Intrinsics.checkExpressionValueIsNotNull((Object)metrics, (String)"jHipsterProperties.metrics");
        JHipsterProperties.Metrics.Logs logs = metrics.getLogs();
        Intrinsics.checkExpressionValueIsNotNull((Object)logs, (String)"jHipsterProperties.metrics.logs");
        if (logs.isEnabled()) {
            LoggingUtils.setMetricsMarkerLogbackFilter((LoggerContext)context, (boolean)loggingProperties.isUseJsonFormat());
        }
    }
}

