/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.repository;

import com.shiftphones.shifternetzwerk.config.audit.AuditEventConverter;
import com.shiftphones.shifternetzwerk.domain.PersistentAuditEvent;
import com.shiftphones.shifternetzwerk.repository.PersistenceAuditEventRepository;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J.\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u0018H\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/shiftphones/shifternetzwerk/repository/CustomAuditEventRepository;", "Lorg/springframework/boot/actuate/audit/AuditEventRepository;", "persistenceAuditEventRepository", "Lcom/shiftphones/shifternetzwerk/repository/PersistenceAuditEventRepository;", "auditEventConverter", "Lcom/shiftphones/shifternetzwerk/config/audit/AuditEventConverter;", "(Lcom/shiftphones/shifternetzwerk/repository/PersistenceAuditEventRepository;Lcom/shiftphones/shifternetzwerk/config/audit/AuditEventConverter;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "add", "", "event", "Lorg/springframework/boot/actuate/audit/AuditEvent;", "find", "", "principal", "", "after", "Ljava/time/Instant;", "type", "truncate", "", "data", "", "shifternetzwerk"})
public class CustomAuditEventRepository
implements AuditEventRepository {
    private final Logger log;
    private final PersistenceAuditEventRepository persistenceAuditEventRepository;
    private final AuditEventConverter auditEventConverter;

    @NotNull
    public List<AuditEvent> find(@NotNull String principal, @NotNull Instant after, @NotNull String type) {
        Intrinsics.checkParameterIsNotNull((Object)principal, (String)"principal");
        Intrinsics.checkParameterIsNotNull((Object)after, (String)"after");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        List persistentAuditEvents = this.persistenceAuditEventRepository.findByPrincipalAndAuditEventDateAfterAndAuditEventType(principal, after, type);
        return this.auditEventConverter.convertToAuditEvent((Iterable)persistentAuditEvents);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void add(@NotNull AuditEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)"AUTHORIZATION_FAILURE", (Object)event.getType()) ^ true && Intrinsics.areEqual((Object)"anonymoususer", (Object)event.getPrincipal()) ^ true) {
            Map map = null;
            Instant instant = event.getTimestamp();
            String string = event.getType();
            PersistentAuditEvent persistentAuditEvent = new PersistentAuditEvent(null, event.getPrincipal(), instant, string, map, 17, null);
            Map eventData = this.auditEventConverter.convertDataToStrings(event.getData());
            persistentAuditEvent.setData(this.truncate(eventData));
            this.persistenceAuditEventRepository.save((Object)persistentAuditEvent);
        }
    }

    private Map<String, String> truncate(Map<String, String> data) {
        boolean bl = false;
        Map results = new LinkedHashMap();
        if (data != null) {
            for (Map.Entry<String, String> entry : data.entrySet()) {
                int length;
                String value = entry.getValue();
                if (value != null && (length = value.length()) > 255) {
                    String string = value;
                    int n = 0;
                    int n2 = 255;
                    boolean bl2 = false;
                    String string2 = string.substring(n, n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    value = string2;
                    this.log.warn("Event data for " + entry.getKey() + " too long (" + length + ") has been truncated to 255. Consider increasing column width.");
                }
                results.put(entry.getKey(), value);
            }
        }
        return results;
    }

    public CustomAuditEventRepository(@NotNull PersistenceAuditEventRepository persistenceAuditEventRepository, @NotNull AuditEventConverter auditEventConverter) {
        Intrinsics.checkParameterIsNotNull((Object)persistenceAuditEventRepository, (String)"persistenceAuditEventRepository");
        Intrinsics.checkParameterIsNotNull((Object)auditEventConverter, (String)"auditEventConverter");
        this.persistenceAuditEventRepository = persistenceAuditEventRepository;
        this.auditEventConverter = auditEventConverter;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

