/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.service;

import com.shiftphones.shifternetzwerk.domain.Offeredservice;
import com.shiftphones.shifternetzwerk.domain.OfferedserviceCreationRequest;
import com.shiftphones.shifternetzwerk.domain.OfferedserviceRequest;
import com.shiftphones.shifternetzwerk.domain.Product;
import com.shiftphones.shifternetzwerk.domain.Productgroup;
import com.shiftphones.shifternetzwerk.domain.Shifter;
import com.shiftphones.shifternetzwerk.domain.enumeration.ServiceState;
import com.shiftphones.shifternetzwerk.domain.enumeration.ShifterRolesEnum;
import com.shiftphones.shifternetzwerk.repository.OfferedserviceRepository;
import com.shiftphones.shifternetzwerk.repository.OfferedserviceRequestRepository;
import com.shiftphones.shifternetzwerk.repository.ProductRepository;
import com.shiftphones.shifternetzwerk.repository.ProductgroupRepository;
import com.shiftphones.shifternetzwerk.service.OfferedServiceService$WhenMappings;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J'\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0012J'\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0017\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u001cH\u0012J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001eH\u0012R\u001c\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/shiftphones/shifternetzwerk/service/OfferedServiceService;", "", "offeredserviceRequestRepository", "Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRequestRepository;", "offeredserviceRepository", "Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRepository;", "productRepository", "Lcom/shiftphones/shifternetzwerk/repository/ProductRepository;", "productGroupRepository", "Lcom/shiftphones/shifternetzwerk/repository/ProductgroupRepository;", "(Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRequestRepository;Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRepository;Lcom/shiftphones/shifternetzwerk/repository/ProductRepository;Lcom/shiftphones/shifternetzwerk/repository/ProductgroupRepository;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "acceptOfferedServiceRequest", "", "serviceRequestId", "", "checkShifterAccess", "shifterUserId", "isPowerUser", "", "offeredserviceRequestShifterId", "(Ljava/lang/Long;ZJ)V", "createOfferedServiceByRequest", "offeredserviceRequest", "Lcom/shiftphones/shifternetzwerk/domain/OfferedserviceRequest;", "createRequest", "Lcom/shiftphones/shifternetzwerk/domain/OfferedserviceCreationRequest;", "shifterId", "(Lcom/shiftphones/shifternetzwerk/domain/OfferedserviceCreationRequest;Ljava/lang/Long;Z)Lcom/shiftphones/shifternetzwerk/domain/OfferedserviceRequest;", "isDirectAcceptAllowed", "result", "rejectOfferedServiceRequest", "validateDependantObjects", "shifternetzwerk"})
public class OfferedServiceService {
    private final Logger log;
    private final OfferedserviceRequestRepository offeredserviceRequestRepository;
    private final OfferedserviceRepository offeredserviceRepository;
    private final ProductRepository productRepository;
    private final ProductgroupRepository productGroupRepository;

    public Logger getLog() {
        return this.log;
    }

    @Transactional
    @NotNull
    public OfferedserviceRequest createRequest(@NotNull OfferedserviceCreationRequest offeredserviceRequest, @Nullable Long shifterId, boolean isPowerUser) {
        Intrinsics.checkParameterIsNotNull((Object)offeredserviceRequest, (String)"offeredserviceRequest");
        ShifterRolesEnum.valueOf((String)offeredserviceRequest.getServiceType());
        this.checkShifterAccess(shifterId, isPowerUser, offeredserviceRequest.getShifterId());
        this.validateDependantObjects(offeredserviceRequest);
        OfferedserviceRequest result = (OfferedserviceRequest)this.offeredserviceRequestRepository.save((Object)offeredserviceRequest.toBusinessObject());
        Long l = result.getId();
        if (l != null) {
            Long l2 = l;
            boolean bl = false;
            boolean bl2 = false;
            long id = ((Number)l2).longValue();
            boolean bl3 = false;
            this.getLog().info("Created offeredServicerequest " + id);
            OfferedserviceRequest offeredserviceRequest2 = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)offeredserviceRequest2, (String)"result");
            if (this.isDirectAcceptAllowed(offeredserviceRequest2)) {
                this.createOfferedServiceByRequest(result);
            }
            return result;
        }
        throw (Throwable)new RuntimeException("OfferedService could not be stored for unknown reasons");
    }

    @Transactional
    public void acceptOfferedServiceRequest(long serviceRequestId) {
        OfferedserviceRequest offeredserviceRequest = (OfferedserviceRequest)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.offeredserviceRequestRepository), (Object)serviceRequestId);
        if (offeredserviceRequest != null) {
            OfferedserviceRequest offeredserviceRequest2 = offeredserviceRequest;
            boolean bl = false;
            boolean bl2 = false;
            OfferedserviceRequest it = offeredserviceRequest2;
            boolean bl3 = false;
            if (it.getState() != ServiceState.REQUESTED) {
                throw (Throwable)new RuntimeException("service request always responded");
            }
            this.createOfferedServiceByRequest(it);
            return;
        }
        throw (Throwable)new RuntimeException("Invalid id");
    }

    @Transactional
    public void rejectOfferedServiceRequest(long serviceRequestId) {
        OfferedserviceRequest offeredserviceRequest = (OfferedserviceRequest)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.offeredserviceRequestRepository), (Object)serviceRequestId);
        if (offeredserviceRequest != null) {
            OfferedserviceRequest offeredserviceRequest2 = offeredserviceRequest;
            boolean bl = false;
            boolean bl2 = false;
            OfferedserviceRequest it = offeredserviceRequest2;
            boolean bl3 = false;
            if (it.getState() != ServiceState.REQUESTED) {
                throw (Throwable)new RuntimeException("service request always responded");
            }
            it.setState(ServiceState.DEACTIVE);
            this.offeredserviceRequestRepository.save((Object)it);
            this.getLog().info("Service request rejected " + it.getId());
            return;
        }
        throw (Throwable)new RuntimeException("Invalid id");
    }

    private boolean isDirectAcceptAllowed(OfferedserviceRequest result) {
        boolean bl;
        switch (OfferedServiceService$WhenMappings.$EnumSwitchMapping$0[result.getServiceType().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private void createOfferedServiceByRequest(OfferedserviceRequest offeredserviceRequest) {
        Collection<Product> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Productgroup it;
        Productgroup productGroup = null;
        Productgroup productgroup = offeredserviceRequest.getProductgroup();
        if (productgroup != null) {
            Productgroup productgroup2;
            Productgroup productgroup3 = productgroup;
            boolean bl = false;
            boolean bl2 = false;
            it = productgroup3;
            boolean bl3 = false;
            Productgroup productgroup4 = new Productgroup(null, null, null, 7, null);
            boolean bl4 = false;
            boolean bl5 = false;
            Productgroup $this$apply = productgroup4;
            boolean bl6 = false;
            $this$apply.setId(it.getId());
            productGroup = productgroup2 = productgroup4;
        }
        Iterable iterable = offeredserviceRequest.getProducts();
        Shifter shifter = offeredserviceRequest.getShifter();
        Productgroup productgroup5 = productGroup;
        ZonedDateTime zonedDateTime = null;
        ZonedDateTime zonedDateTime2 = ZonedDateTime.now();
        String string = null;
        ShifterRolesEnum shifterRolesEnum = offeredserviceRequest.getServiceType();
        Long l = null;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Product product = (Product)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Product product2 = new Product(null, null, null, null, null, null, null, null, 255, null);
            boolean bl7 = false;
            boolean bl8 = false;
            Product $this$apply = product2;
            boolean bl9 = false;
            $this$apply.setId(it2.getId());
            Product product3 = product2;
            collection.add(product3);
        }
        collection = (List)destination$iv$iv;
        Set set = CollectionsKt.toMutableSet((Iterable)collection);
        Shifter shifter2 = shifter;
        Productgroup productgroup6 = productgroup5;
        ZonedDateTime zonedDateTime3 = zonedDateTime;
        ZonedDateTime zonedDateTime4 = zonedDateTime2;
        String string2 = string;
        ShifterRolesEnum shifterRolesEnum2 = shifterRolesEnum;
        Long l2 = l;
        Offeredservice offeredService = new Offeredservice(l2, shifterRolesEnum2, string2, zonedDateTime4, zonedDateTime3, productgroup6, shifter2, set);
        Offeredservice savedResult = (Offeredservice)this.offeredserviceRepository.save((Object)offeredService);
        offeredserviceRequest.setState(ServiceState.ACTIV);
        this.offeredserviceRequestRepository.save((Object)offeredserviceRequest);
        this.getLog().info("Created offeredServicer " + savedResult.getId());
    }

    private void validateDependantObjects(OfferedserviceCreationRequest offeredserviceRequest) {
        Iterable $this$forEach$iv = offeredserviceRequest.getProductIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            if (CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.productRepository), (Object)it) != null) continue;
            throw (Throwable)new RuntimeException("Product is unknown");
        }
        Long l = offeredserviceRequest.getProductGroupId();
        if (l != null) {
            Long l2 = l;
            boolean bl = false;
            boolean bl2 = false;
            long it = ((Number)l2).longValue();
            boolean bl3 = false;
            if (CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.productGroupRepository), (Object)it) == null) {
                throw (Throwable)new RuntimeException("Productgroup is unknown");
            }
        }
    }

    public void checkShifterAccess(@Nullable Long shifterUserId, boolean isPowerUser, long offeredserviceRequestShifterId) {
        if (!isPowerUser) {
            Long l = shifterUserId;
            if (l != null) {
                Long l2 = l;
                boolean bl = false;
                boolean bl2 = false;
                long it = ((Number)l2).longValue();
                boolean bl3 = false;
                if (it != offeredserviceRequestShifterId) {
                    throw (Throwable)new RuntimeException("Shifter has only allowance to create requests for own account ");
                }
                return;
            }
            throw (Throwable)new RuntimeException("non poweruser has no shifter assigned");
        }
    }

    public OfferedServiceService(@NotNull OfferedserviceRequestRepository offeredserviceRequestRepository, @NotNull OfferedserviceRepository offeredserviceRepository, @NotNull ProductRepository productRepository, @NotNull ProductgroupRepository productGroupRepository) {
        Intrinsics.checkParameterIsNotNull((Object)offeredserviceRequestRepository, (String)"offeredserviceRequestRepository");
        Intrinsics.checkParameterIsNotNull((Object)offeredserviceRepository, (String)"offeredserviceRepository");
        Intrinsics.checkParameterIsNotNull((Object)productRepository, (String)"productRepository");
        Intrinsics.checkParameterIsNotNull((Object)productGroupRepository, (String)"productGroupRepository");
        this.offeredserviceRequestRepository = offeredserviceRequestRepository;
        this.offeredserviceRepository = offeredserviceRepository;
        this.productRepository = productRepository;
        this.productGroupRepository = productGroupRepository;
        this.log = LoggerFactory.getLogger(OfferedServiceService.class);
    }
}

