/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.service;

import com.shiftphones.shifternetzwerk.domain.Histownedproduct;
import com.shiftphones.shifternetzwerk.domain.Product;
import com.shiftphones.shifternetzwerk.domain.Productinstance;
import com.shiftphones.shifternetzwerk.domain.Serialnumber;
import com.shiftphones.shifternetzwerk.domain.Shifter;
import com.shiftphones.shifternetzwerk.domain.UserProductInstance;
import com.shiftphones.shifternetzwerk.repository.HistownedproductRepository;
import com.shiftphones.shifternetzwerk.repository.ProductRepository;
import com.shiftphones.shifternetzwerk.repository.ProductinstanceRepository;
import com.shiftphones.shifternetzwerk.repository.SerialnumberRepository;
import com.shiftphones.shifternetzwerk.repository.ShifterRepository;
import com.shiftphones.shifternetzwerk.web.rest.ResourceHelperService;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u001bH\u0012R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/shiftphones/shifternetzwerk/service/ProductInstanceService;", "", "shifterRepository", "Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;", "productinstanceRepository", "Lcom/shiftphones/shifternetzwerk/repository/ProductinstanceRepository;", "serialnumberRepository", "Lcom/shiftphones/shifternetzwerk/repository/SerialnumberRepository;", "histownedproductRepository", "Lcom/shiftphones/shifternetzwerk/repository/HistownedproductRepository;", "resourceHelperService", "Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;", "productRepository", "Lcom/shiftphones/shifternetzwerk/repository/ProductRepository;", "(Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;Lcom/shiftphones/shifternetzwerk/repository/ProductinstanceRepository;Lcom/shiftphones/shifternetzwerk/repository/SerialnumberRepository;Lcom/shiftphones/shifternetzwerk/repository/HistownedproductRepository;Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;Lcom/shiftphones/shifternetzwerk/repository/ProductRepository;)V", "getHistownedproductRepository", "()Lcom/shiftphones/shifternetzwerk/repository/HistownedproductRepository;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getProductinstanceRepository", "()Lcom/shiftphones/shifternetzwerk/repository/ProductinstanceRepository;", "getSerialnumberRepository", "()Lcom/shiftphones/shifternetzwerk/repository/SerialnumberRepository;", "create", "Lcom/shiftphones/shifternetzwerk/domain/Productinstance;", "pi", "Lcom/shiftphones/shifternetzwerk/domain/UserProductInstance;", "endOwnership", "", "piId", "", "findActiveOwnerShip", "Lcom/shiftphones/shifternetzwerk/domain/Histownedproduct;", "stdSaveLogic", "upi", "shifternetzwerk"})
public class ProductInstanceService {
    private final Logger log;
    private final ShifterRepository shifterRepository;
    @NotNull
    private final ProductinstanceRepository productinstanceRepository;
    @NotNull
    private final SerialnumberRepository serialnumberRepository;
    @NotNull
    private final HistownedproductRepository histownedproductRepository;
    private final ResourceHelperService resourceHelperService;
    private final ProductRepository productRepository;

    @NotNull
    public Productinstance create(@NotNull UserProductInstance pi) {
        Intrinsics.checkParameterIsNotNull((Object)pi, (String)"pi");
        Productinstance result = this.stdSaveLogic(pi);
        this.log.info("Created new serviceProvider " + result.getId());
        return result;
    }

    private Productinstance stdSaveLogic(UserProductInstance upi) {
        Shifter shifter = (Shifter)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.shifterRepository), (Object)upi.getShifterId());
        if (shifter != null) {
            Serialnumber it;
            Set $this$mapTo$iv$iv2;
            Shifter shifter2 = shifter;
            boolean bl = false;
            boolean bl2 = false;
            Shifter shifter3 = shifter2;
            boolean bl3 = false;
            Iterable $this$map$iv = upi.getSerialNumbers();
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                Serialnumber serialnumber = new Serialnumber(null, (String)it, null, 5, null);
                collection.add(serialnumber);
            }
            List serialnumbers = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
            Long productId = upi.getProductId();
            if (productId == null) {
                Product product = this.productRepository.findByName("SHIFT6mq");
                if (product != null) {
                    Product $i$f$map2 = product;
                    boolean $this$mapTo$iv$iv2 = false;
                    boolean destination$iv$iv2 = false;
                    Product prod = $i$f$map2;
                    boolean bl5 = false;
                    productId = prod.getId();
                }
                if (productId == null) {
                    List list = this.productRepository.findAll();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.productRepository.findAll()");
                    Product product2 = (Product)CollectionsKt.firstOrNull((List)list);
                    if (product2 != null) {
                        Product $i$f$map2 = product2;
                        boolean $this$mapTo$iv$iv2 = false;
                        boolean destination$iv$iv2 = false;
                        Product prod = $i$f$map2;
                        boolean bl6 = false;
                        productId = prod.getId();
                    }
                }
            }
            $this$mapTo$iv$iv2 = CollectionsKt.toMutableSet((Iterable)serialnumbers);
            destination$iv$iv2 = null;
            Product prod = new Product(productId, null, null, null, null, null, null, null, 254, null);
            Productinstance pi = new Productinstance(null, Boolean.valueOf(false), $this$mapTo$iv$iv2, (Set)destination$iv$iv2, prod, 9, null);
            Productinstance result = (Productinstance)this.getProductinstanceRepository().save((Object)pi);
            Iterable $this$forEach$iv = serialnumbers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Serialnumber)element$iv;
                boolean bl7 = false;
                it.setProductinstance(result);
            }
            this.getSerialnumberRepository().saveAll((Iterable)serialnumbers);
            Histownedproduct hist = new Histownedproduct(null, ZonedDateTime.now(), null, pi, shifter3, 5, null);
            this.getHistownedproductRepository().save((Object)hist);
            pi.getOwneds().add(hist);
            this.getProductinstanceRepository().save((Object)pi);
            shifter3.getHistownedproducts().add(hist);
            this.shifterRepository.save((Object)shifter3);
            Productinstance productinstance = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)productinstance, (String)"result");
            return productinstance;
        }
        throw (Throwable)new RuntimeException("Shifter not found " + upi.getShifterId());
    }

    @Nullable
    public Histownedproduct findActiveOwnerShip(long piId) {
        Productinstance productinstance = (Productinstance)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.getProductinstanceRepository()), (Object)piId);
        if (productinstance != null) {
            Productinstance productinstance2 = productinstance;
            boolean bl = false;
            boolean bl2 = false;
            Productinstance pi = productinstance2;
            boolean bl3 = false;
            Iterable iterable = pi.getOwneds();
            boolean bl4 = false;
            Iterable iterable2 = iterable;
            boolean bl5 = false;
            Object var12_13 = null;
            for (Object t : iterable2) {
                Histownedproduct it = (Histownedproduct)t;
                boolean bl6 = false;
                if (!(it.getValidTo() == null)) continue;
                var12_13 = t;
            }
            Histownedproduct histownedproduct = var12_13;
            if (histownedproduct != null) {
                iterable = histownedproduct;
                bl4 = false;
                boolean bl7 = false;
                Iterable it = iterable;
                boolean bl8 = false;
                return it;
            }
            return null;
        }
        throw (Throwable)new RuntimeException("unknown productid " + piId);
    }

    public void endOwnership(long piId) {
        Histownedproduct histownedproduct = this.findActiveOwnerShip(piId);
        if (histownedproduct != null) {
            Histownedproduct histownedproduct2 = histownedproduct;
            boolean bl = false;
            boolean bl2 = false;
            Histownedproduct it = histownedproduct2;
            boolean bl3 = false;
            Shifter shifter = it.getShifter();
            if (shifter == null) {
                Intrinsics.throwNpe();
            }
            Long l = shifter.getId();
            if (l == null) {
                Intrinsics.throwNpe();
            }
            this.resourceHelperService.isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed(l.longValue());
            it.setValidTo(ZonedDateTime.now());
            this.getHistownedproductRepository().save((Object)it);
            return;
        }
        throw (Throwable)new RuntimeException("no open ownership found piId " + piId);
    }

    @NotNull
    public ProductinstanceRepository getProductinstanceRepository() {
        return this.productinstanceRepository;
    }

    @NotNull
    public SerialnumberRepository getSerialnumberRepository() {
        return this.serialnumberRepository;
    }

    @NotNull
    public HistownedproductRepository getHistownedproductRepository() {
        return this.histownedproductRepository;
    }

    public ProductInstanceService(@NotNull ShifterRepository shifterRepository, @NotNull ProductinstanceRepository productinstanceRepository, @NotNull SerialnumberRepository serialnumberRepository, @NotNull HistownedproductRepository histownedproductRepository, @NotNull ResourceHelperService resourceHelperService, @NotNull ProductRepository productRepository) {
        Intrinsics.checkParameterIsNotNull((Object)shifterRepository, (String)"shifterRepository");
        Intrinsics.checkParameterIsNotNull((Object)productinstanceRepository, (String)"productinstanceRepository");
        Intrinsics.checkParameterIsNotNull((Object)serialnumberRepository, (String)"serialnumberRepository");
        Intrinsics.checkParameterIsNotNull((Object)histownedproductRepository, (String)"histownedproductRepository");
        Intrinsics.checkParameterIsNotNull((Object)resourceHelperService, (String)"resourceHelperService");
        Intrinsics.checkParameterIsNotNull((Object)productRepository, (String)"productRepository");
        this.shifterRepository = shifterRepository;
        this.productinstanceRepository = productinstanceRepository;
        this.serialnumberRepository = serialnumberRepository;
        this.histownedproductRepository = histownedproductRepository;
        this.resourceHelperService = resourceHelperService;
        this.productRepository = productRepository;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

