/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.service;

import com.shiftphones.shifternetzwerk.service.RestTemplateLoggingInterceptor;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/shiftphones/shifternetzwerk/service/RestTemplateLoggingInterceptor;", "Lorg/springframework/http/client/ClientHttpRequestInterceptor;", "()V", "intercept", "Lorg/springframework/http/client/ClientHttpResponse;", "request", "Lorg/springframework/http/HttpRequest;", "body", "", "execution", "Lorg/springframework/http/client/ClientHttpRequestExecution;", "traceRequest", "", "traceResponse", "response", "Companion", "shifternetzwerk"})
public final class RestTemplateLoggingInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public ClientHttpResponse intercept(@NotNull HttpRequest request, @NotNull byte[] body, @NotNull ClientHttpRequestExecution execution) {
        ClientHttpResponse response;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Intrinsics.checkParameterIsNotNull((Object)execution, (String)"execution");
        this.traceRequest(request, body);
        ClientHttpResponse clientHttpResponse = response = execution.execute(request, body);
        Intrinsics.checkExpressionValueIsNotNull((Object)clientHttpResponse, (String)"response");
        if (clientHttpResponse.getRawStatusCode() > 299) {
            this.traceResponse(response);
        }
        return response;
    }

    private final void traceRequest(HttpRequest request, byte[] body) {
        log.info("===========================request begin================================================");
        log.info("URI         : {}", (Object)request.getURI());
        log.info("Method      : {}", (Object)request.getMethod());
        log.info("Headers     : {}", (Object)request.getHeaders());
        if (body.length < 10000) {
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.defaultCharset()");
            Charset charset2 = charset;
            String string = "Request body: {}";
            Logger logger = log;
            boolean bl = false;
            String string2 = new String(body, charset2);
            logger.info(string, (Object)string2);
        } else {
            log.info("Request body size {}", (Object)body.length);
        }
        log.info("==========================request end================================================");
    }

    private final void traceResponse(ClientHttpResponse response) {
        StringBuilder inputStringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getBody(), "UTF-8"));
        String line = bufferedReader.readLine();
        while (line != null) {
            inputStringBuilder.append(line);
            inputStringBuilder.append('\n');
            line = bufferedReader.readLine();
        }
        log.info("============================response begin==========================================");
        log.info("Status code  : {}", (Object)response.getStatusCode());
        log.info("Status text  : {}", (Object)response.getStatusText());
        log.info("Headers      : {}", (Object)response.getHeaders());
        log.info("=======================response end=================================================");
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(RestTemplateLoggingInterceptor.class);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }
}

