/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.Shifter;
import com.shiftphones.shifternetzwerk.domain.User;
import com.shiftphones.shifternetzwerk.domain.Userprofile;
import com.shiftphones.shifternetzwerk.repository.ShifterRepository;
import com.shiftphones.shifternetzwerk.repository.UserRepository;
import com.shiftphones.shifternetzwerk.repository.UserprofileRepository;
import com.shiftphones.shifternetzwerk.security.SecurityUtils;
import com.shiftphones.shifternetzwerk.web.rest.ResourceHelperService;
import com.shiftphones.shifternetzwerk.web.rest.SecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0012J\u000f\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0012J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;", "", "userRepository", "Lcom/shiftphones/shifternetzwerk/repository/UserRepository;", "shifterRepository", "Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;", "upRepo", "Lcom/shiftphones/shifternetzwerk/repository/UserprofileRepository;", "(Lcom/shiftphones/shifternetzwerk/repository/UserRepository;Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;Lcom/shiftphones/shifternetzwerk/repository/UserprofileRepository;)V", "getShifterRepository", "()Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;", "getUpRepo", "()Lcom/shiftphones/shifternetzwerk/repository/UserprofileRepository;", "getUserRepository", "()Lcom/shiftphones/shifternetzwerk/repository/UserRepository;", "getShifter", "Lcom/shiftphones/shifternetzwerk/domain/Shifter;", "getShifterId", "", "()Ljava/lang/Long;", "getUser", "Ljava/util/Optional;", "Lcom/shiftphones/shifternetzwerk/domain/User;", "getUserId", "", "getUserIdOrNull", "isCurrentUserPowerUserOrGivenUserAndThrow", "", "concerningUserProfileId", "isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed", "shifterId", "shifternetzwerk"})
public class ResourceHelperService {
    @NotNull
    private final UserRepository userRepository;
    @NotNull
    private final ShifterRepository shifterRepository;
    @NotNull
    private final UserprofileRepository upRepo;

    private Optional<User> getUser() {
        Object t = SecurityUtils.getCurrentUserLogin().orElseThrow((Supplier)getUser.userLogin.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"getCurrentUserLogin()\n  \u2026user login not found\") })");
        String userLogin2 = (String)t;
        return this.getUserRepository().findOneByLogin(userLogin2);
    }

    @Nullable
    public String getUserIdOrNull() {
        if (this.getUser().isPresent()) {
            String string = ((User)this.getUser().get()).getId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return string;
        }
        return SecurityUtils.extractUserIdIfUnknownUser();
    }

    @NotNull
    public String getUserId() {
        if (this.getUser().isPresent()) {
            String string = ((User)this.getUser().get()).getId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return string;
        }
        String string = SecurityUtils.extractUserIdIfUnknownUser();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Nullable
    public Long getShifterId() {
        Shifter shifter = this.getShifter();
        if (shifter != null) {
            Shifter shifter2 = shifter;
            boolean bl = false;
            boolean bl2 = false;
            Shifter it = shifter2;
            boolean bl3 = false;
            return it.getId();
        }
        return null;
    }

    public void isCurrentUserPowerUserOrGivenUserAndThrow(@NotNull String concerningUserProfileId) {
        Intrinsics.checkParameterIsNotNull((Object)concerningUserProfileId, (String)"concerningUserProfileId");
        if (SecurityUtils.isCurrentUserPowerUser()) {
            return;
        }
        if (Intrinsics.areEqual((Object)concerningUserProfileId, (Object)this.getUserId())) {
            return;
        }
        throw (Throwable)new SecurityException("concerningUserProfileId not power user or given user " + concerningUserProfileId);
    }

    private Shifter getShifter() {
        String string = this.getUserIdOrNull();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            Userprofile userprofile = (Userprofile)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.getUpRepo()), (Object)it);
            if (userprofile != null) {
                Userprofile userprofile2 = userprofile;
                boolean bl4 = false;
                boolean bl5 = false;
                Userprofile up = userprofile2;
                boolean bl6 = false;
                return up.getShifter();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed(long shifterId) {
        if (SecurityUtils.isCurrentUserPowerUser()) {
            return;
        }
        String usrId = this.getUserId();
        Shifter shifter = (Shifter)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.getShifterRepository()), (Object)shifterId);
        if (shifter != null) {
            Object v1;
            boolean bl;
            Object object;
            block5: {
                void $this$mapNotNullTo$iv$iv;
                Shifter shifter2 = shifter;
                boolean bl2 = false;
                boolean bl3 = false;
                Shifter it = shifter2;
                boolean bl4 = false;
                Iterable $this$mapNotNull$iv = it.getUsers();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv22 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String string;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl5 = false;
                    Userprofile u = (Userprofile)element$iv$iv;
                    boolean bl6 = false;
                    if (u.getId() == null) continue;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    String it$iv$iv = string;
                    boolean bl9 = false;
                    destination$iv$iv22.add(it$iv$iv);
                }
                object = (List)destination$iv$iv22;
                bl = false;
                iterable = object;
                boolean destination$iv$iv22 = false;
                for (Object t : iterable) {
                    String uId = (String)t;
                    boolean bl10 = false;
                    if (!Intrinsics.areEqual((Object)usrId, (Object)uId)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            String string = v1;
            if (string != null) {
                object = string;
                bl = false;
                boolean bl11 = false;
                Object it = object;
                boolean bl12 = false;
                return;
            }
            throw (Throwable)new SecurityException("no poweruser and no user of shifter " + shifterId);
        }
        throw (Throwable)new RuntimeException("unknown shifter " + shifterId);
    }

    @NotNull
    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    @NotNull
    public ShifterRepository getShifterRepository() {
        return this.shifterRepository;
    }

    @NotNull
    public UserprofileRepository getUpRepo() {
        return this.upRepo;
    }

    public ResourceHelperService(@NotNull UserRepository userRepository, @NotNull ShifterRepository shifterRepository, @NotNull UserprofileRepository upRepo) {
        Intrinsics.checkParameterIsNotNull((Object)userRepository, (String)"userRepository");
        Intrinsics.checkParameterIsNotNull((Object)shifterRepository, (String)"shifterRepository");
        Intrinsics.checkParameterIsNotNull((Object)upRepo, (String)"upRepo");
        this.userRepository = userRepository;
        this.shifterRepository = shifterRepository;
        this.upRepo = upRepo;
    }
}

