/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.Serialnumber;
import com.shiftphones.shifternetzwerk.repository.SerialnumberRepository;
import com.shiftphones.shifternetzwerk.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\r\u001a\u00020\fH\u0017J\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0017J\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\r\u001a\u00020\fH\u0017R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/SerialnumberResource;", "", "serialnumberRepository", "Lcom/shiftphones/shifternetzwerk/repository/SerialnumberRepository;", "(Lcom/shiftphones/shifternetzwerk/repository/SerialnumberRepository;)V", "applicationName", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createSerialnumber", "Lorg/springframework/http/ResponseEntity;", "Lcom/shiftphones/shifternetzwerk/domain/Serialnumber;", "serialnumber", "deleteSerialnumber", "Ljava/lang/Void;", "id", "", "getAllSerialnumbers", "", "getSerialnumber", "updateSerialnumber", "shifternetzwerk"})
public class SerialnumberResource {
    private final Logger log;
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final SerialnumberRepository serialnumberRepository;

    @PostMapping(value={"/serialnumbers"})
    @NotNull
    public ResponseEntity<Serialnumber> createSerialnumber(@RequestBody @NotNull Serialnumber serialnumber) {
        Intrinsics.checkParameterIsNotNull((Object)serialnumber, (String)"serialnumber");
        this.log.debug("REST request to save Serialnumber : {}", (Object)serialnumber);
        if (serialnumber.getId() != null) {
            throw (Throwable)new BadRequestAlertException("A new serialnumber cannot already have an ID", "serialnumber", "idexists");
        }
        Serialnumber result = (Serialnumber)this.serialnumberRepository.save((Object)serialnumber);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/serialnumbers/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)"serialnumber", (String)String.valueOf(result.getId())))).body((Object)result);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.created(U\u2026            .body(result)");
        return responseEntity;
    }

    @PutMapping(value={"/serialnumbers"})
    @NotNull
    public ResponseEntity<Serialnumber> updateSerialnumber(@RequestBody @NotNull Serialnumber serialnumber) {
        Intrinsics.checkParameterIsNotNull((Object)serialnumber, (String)"serialnumber");
        this.log.debug("REST request to update Serialnumber : {}", (Object)serialnumber);
        if (serialnumber.getId() == null) {
            throw (Throwable)new BadRequestAlertException("Invalid id", "serialnumber", "idnull");
        }
        Serialnumber result = (Serialnumber)this.serialnumberRepository.save((Object)serialnumber);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)"serialnumber", (String)String.valueOf(serialnumber.getId())))).body((Object)result);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.ok()\n    \u2026            .body(result)");
        return responseEntity;
    }

    @GetMapping(value={"/serialnumbers"})
    @NotNull
    public List<Serialnumber> getAllSerialnumbers() {
        this.log.debug("REST request to get all Serialnumbers");
        List list = this.serialnumberRepository.findAll();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"serialnumberRepository.findAll()");
        return list;
    }

    @GetMapping(value={"/serialnumbers/{id}"})
    @NotNull
    public ResponseEntity<Serialnumber> getSerialnumber(@PathVariable long id) {
        this.log.debug("REST request to get Serialnumber : {}", (Object)id);
        Optional serialnumber = this.serialnumberRepository.findById((Object)id);
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound((Optional)serialnumber);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseUtil.wrapOrNotFound(serialnumber)");
        return responseEntity;
    }

    @DeleteMapping(value={"/serialnumbers/{id}"})
    @NotNull
    public ResponseEntity<Void> deleteSerialnumber(@PathVariable long id) {
        this.log.debug("REST request to delete Serialnumber : {}", (Object)id);
        this.serialnumberRepository.deleteById((Object)id);
        ResponseEntity responseEntity = ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)"serialnumber", (String)String.valueOf(id))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.noContent\u2026, id.toString())).build()");
        return responseEntity;
    }

    public SerialnumberResource(@NotNull SerialnumberRepository serialnumberRepository) {
        Intrinsics.checkParameterIsNotNull((Object)serialnumberRepository, (String)"serialnumberRepository");
        this.serialnumberRepository = serialnumberRepository;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

