/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.config;

import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.config.java.AbstractCloudConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"cloud"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0017R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/shiftphones/shifternetzwerk/config/CloudDatabaseConfiguration;", "Lorg/springframework/cloud/config/java/AbstractCloudConfig;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "dataSource", "Ljavax/sql/DataSource;", "shifternetzwerk"})
public class CloudDatabaseConfiguration
extends AbstractCloudConfig {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Bean
    @ConfigurationProperties(value="spring.datasource.hikari")
    @NotNull
    public DataSource dataSource() {
        this.log.info("Configuring JDBC datasource from a cloud provider");
        DataSource dataSource = this.connectionFactory().dataSource();
        Intrinsics.checkNotNullExpressionValue((Object)dataSource, (String)"connectionFactory().dataSource()");
        return dataSource;
    }
}

