/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.config;

import io.github.jhipster.config.JHipsterProperties;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.WebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0017J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/shiftphones/shifternetzwerk/config/WebConfigurer;", "Lorg/springframework/boot/web/servlet/ServletContextInitializer;", "Lorg/springframework/boot/web/server/WebServerFactoryCustomizer;", "Lorg/springframework/boot/web/server/WebServerFactory;", "env", "Lorg/springframework/core/env/Environment;", "jHipsterProperties", "Lio/github/jhipster/config/JHipsterProperties;", "(Lorg/springframework/core/env/Environment;Lio/github/jhipster/config/JHipsterProperties;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "corsFilter", "Lorg/springframework/web/filter/CorsFilter;", "customize", "", "server", "onStartup", "servletContext", "Ljavax/servlet/ServletContext;", "resolvePathPrefix", "", "setLocationForStaticAssets", "setMimeMappings", "shifternetzwerk"})
public class WebConfigurer
implements ServletContextInitializer,
WebServerFactoryCustomizer<WebServerFactory> {
    @NotNull
    private final Environment env;
    @NotNull
    private final JHipsterProperties jHipsterProperties;
    private final Logger log;

    public WebConfigurer(@NotNull Environment env, @NotNull JHipsterProperties jHipsterProperties) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)jHipsterProperties, (String)"jHipsterProperties");
        this.env = env;
        this.jHipsterProperties = jHipsterProperties;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public void onStartup(@NotNull ServletContext servletContext) throws ServletException {
        Intrinsics.checkNotNullParameter((Object)servletContext, (String)"servletContext");
        Object[] objectArray = this.env.getActiveProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"env.activeProfiles");
        objectArray = objectArray;
        boolean bl = false;
        Object[] objectArray2 = objectArray;
        boolean bl2 = false;
        if (!(objectArray2.length == 0)) {
            String[] stringArray = this.env.getActiveProfiles();
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<*>");
            }
            objectArray = stringArray;
            this.log.info("Web application configuration, using profiles: {}", Arrays.copyOf(objectArray, objectArray.length));
        }
        this.log.info("Web application fully configured");
    }

    public void customize(@NotNull WebServerFactory server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.setMimeMappings(server);
        this.setLocationForStaticAssets(server);
    }

    private final void setMimeMappings(WebServerFactory server) {
        if (server instanceof ConfigurableServletWebServerFactory) {
            MimeMappings mappings = new MimeMappings(MimeMappings.DEFAULT);
            String string = StandardCharsets.UTF_8.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UTF_8.name()");
            boolean bl = false;
            String string2 = string.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            mappings.add("html", Intrinsics.stringPlus((String)"text/html;charset=", (Object)string2));
            string = StandardCharsets.UTF_8.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UTF_8.name()");
            bl = false;
            String string3 = string.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            mappings.add("json", Intrinsics.stringPlus((String)"text/html;charset=", (Object)string3));
            ((ConfigurableServletWebServerFactory)server).setMimeMappings(mappings);
        }
    }

    private final void setLocationForStaticAssets(WebServerFactory server) {
        String prefixPath;
        File root;
        if (server instanceof ConfigurableServletWebServerFactory && (root = new File(Intrinsics.stringPlus((String)(prefixPath = this.resolvePathPrefix()), (Object)"target/classes/static/"))).exists() && root.isDirectory()) {
            ((ConfigurableServletWebServerFactory)server).setDocumentRoot(root);
        }
    }

    private final String resolvePathPrefix() {
        String string;
        try {
            string = URLDecoder.decode(this.getClass().getResource("").getPath(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            string = this.getClass().getResource("").getPath();
        }
        String fullExecutablePath = string;
        String rootPath = Paths.get(".", new String[0]).toUri().normalize().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)fullExecutablePath, (String)"fullExecutablePath");
        Intrinsics.checkNotNullExpressionValue((Object)rootPath, (String)"rootPath");
        String extractedPath = StringsKt.replace$default((String)fullExecutablePath, (String)rootPath, (String)"", (boolean)false, (int)4, null);
        int extractionEndIndex = StringsKt.indexOf$default((CharSequence)extractedPath, (String)"target/", (int)0, (boolean)false, (int)6, null);
        if (extractionEndIndex <= 0) {
            return "";
        }
        String string2 = extractedPath;
        int n = 0;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, extractionEndIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string4;
    }

    @Bean
    @NotNull
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = this.jHipsterProperties.getCors();
        if (config.getAllowedOrigins() != null) {
            List list = config.getAllowedOrigins();
            Intrinsics.checkNotNull((Object)list);
            Collection collection = list;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.log.debug("Registering CORS filter");
                collection = source;
                bl = false;
                boolean bl2 = false;
                Collection $this$corsFilter_u24lambda_u2d0 = collection;
                boolean bl3 = false;
                $this$corsFilter_u24lambda_u2d0.registerCorsConfiguration("/api/**", config);
                $this$corsFilter_u24lambda_u2d0.registerCorsConfiguration("/management/**", config);
                $this$corsFilter_u24lambda_u2d0.registerCorsConfiguration("/v2/api-docs", config);
            }
        }
        return new CorsFilter((CorsConfigurationSource)source);
    }
}

