/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.repository;

import com.shiftphones.shifternetzwerk.config.audit.AuditEventConverter;
import com.shiftphones.shifternetzwerk.domain.PersistentAuditEvent;
import com.shiftphones.shifternetzwerk.repository.PersistenceAuditEventRepository;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J.\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/shiftphones/shifternetzwerk/repository/CustomAuditEventRepository;", "Lorg/springframework/boot/actuate/audit/AuditEventRepository;", "persistenceAuditEventRepository", "Lcom/shiftphones/shifternetzwerk/repository/PersistenceAuditEventRepository;", "auditEventConverter", "Lcom/shiftphones/shifternetzwerk/config/audit/AuditEventConverter;", "(Lcom/shiftphones/shifternetzwerk/repository/PersistenceAuditEventRepository;Lcom/shiftphones/shifternetzwerk/config/audit/AuditEventConverter;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "add", "", "event", "Lorg/springframework/boot/actuate/audit/AuditEvent;", "find", "", "principal", "", "after", "Ljava/time/Instant;", "type", "truncate", "", "data", "", "shifternetzwerk"})
public class CustomAuditEventRepository
implements AuditEventRepository {
    @NotNull
    private final PersistenceAuditEventRepository persistenceAuditEventRepository;
    @NotNull
    private final AuditEventConverter auditEventConverter;
    private final Logger log;

    public CustomAuditEventRepository(@NotNull PersistenceAuditEventRepository persistenceAuditEventRepository, @NotNull AuditEventConverter auditEventConverter) {
        Intrinsics.checkNotNullParameter((Object)persistenceAuditEventRepository, (String)"persistenceAuditEventRepository");
        Intrinsics.checkNotNullParameter((Object)auditEventConverter, (String)"auditEventConverter");
        this.persistenceAuditEventRepository = persistenceAuditEventRepository;
        this.auditEventConverter = auditEventConverter;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    public List<AuditEvent> find(@NotNull String principal, @NotNull Instant after, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        List persistentAuditEvents = this.persistenceAuditEventRepository.findByPrincipalAndAuditEventDateAfterAndAuditEventType(principal, after, type);
        return this.auditEventConverter.convertToAuditEvent((Iterable)persistentAuditEvents);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void add(@NotNull AuditEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)"AUTHORIZATION_FAILURE", (Object)event.getType()) && !Intrinsics.areEqual((Object)"anonymoususer", (Object)event.getPrincipal())) {
            String string = event.getPrincipal();
            String string2 = event.getType();
            Instant instant = event.getTimestamp();
            PersistentAuditEvent persistentAuditEvent = new PersistentAuditEvent(null, string, instant, string2, null, 17, null);
            Map eventData = this.auditEventConverter.convertDataToStrings(event.getData());
            persistentAuditEvent.setData(this.truncate(eventData));
            this.persistenceAuditEventRepository.save((Object)persistentAuditEvent);
        }
    }

    private final Map<String, String> truncate(Map<String, String> data) {
        boolean bl = false;
        Map results = new LinkedHashMap();
        if (data != null) {
            for (Map.Entry<String, String> entry : data.entrySet()) {
                int n;
                String string;
                int length;
                String value = entry.getValue();
                if (value != null && (length = value.length()) > 255) {
                    string = value;
                    n = 0;
                    int n2 = 255;
                    boolean bl2 = false;
                    String string2 = string.substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    value = string2;
                    this.log.warn("Event data for " + entry.getKey() + " too long (" + length + ") has been truncated to 255. Consider increasing column width.");
                }
                Map map = results;
                string = entry.getKey();
                n = 0;
                map.put(string, value);
            }
        }
        return results;
    }
}

