/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.repository;

import com.shiftphones.shifternetzwerk.service.Coords;
import com.shiftphones.shifternetzwerk.service.ShortShifterOverview;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"shifterId2IMeis"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0001H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0017\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00160\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u0014\u001a\u00020\u0001H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\r2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\r2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u001a\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\r0\"H\u0017J\u001c\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u0010\u0014\u001a\u00020\u0001H\u0002R\u001e\u0010\u0002\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006$"}, d2={"Lcom/shiftphones/shifternetzwerk/repository/ServiceProviderRepositoryDbDirectSearch;", "", "entityManager", "Ljavax/persistence/EntityManager;", "(Ljavax/persistence/EntityManager;)V", "getEntityManager", "()Ljavax/persistence/EntityManager;", "setEntityManager", "deleteServiceForOldShifter", "", "upId", "", "findAllShifter", "", "Lcom/shiftphones/shifternetzwerk/service/ShortShifterOverview;", "userProfileId", "findAllShifterForOneShifter", "shifterId", "", "findAllShifterMapRow", "any", "findHistoryProdOwnedIdsByShifterId", "", "findServiceIdSummaryByShifter", "Lkotlin/Pair;", "findServiceSummaryForShifterMapRow", "", "getCoordsFromRow", "Lcom/shiftphones/shifternetzwerk/service/Coords;", "str", "getElemsFromStrAggr", "getServicesFromRow", "Lcom/shiftphones/shifternetzwerk/service/Service;", "shifterId2IMeis", "", "shifterId2IMeisMapRow", "shifternetzwerk"})
public class ServiceProviderRepositoryDbDirectSearch {
    @PersistenceContext
    @NotNull
    private EntityManager entityManager;

    public ServiceProviderRepositoryDbDirectSearch(@NotNull EntityManager entityManager) {
        Intrinsics.checkNotNullParameter((Object)entityManager, (String)"entityManager");
        this.entityManager = entityManager;
    }

    @NotNull
    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(@NotNull EntityManager entityManager) {
        Intrinsics.checkNotNullParameter((Object)entityManager, (String)"<set-?>");
        this.entityManager = entityManager;
    }

    public int deleteServiceForOldShifter(@NotNull String upId) {
        Intrinsics.checkNotNullParameter((Object)upId, (String)"upId");
        String sql = "Delete from offeredservice where id IN(\n\t  \tSelect distinct(o.id) from userprofile u join offeredservice o on u.shifter_id = o.shifter_id where u.id='" + upId + "'\n\t    )";
        Query query = this.getEntityManager().createNativeQuery(sql);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"entityManager.createNativeQuery(sql)");
        Query query2 = query;
        return query2.executeUpdate();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<Long> findHistoryProdOwnedIdsByShifterId(long shifterId) {
        void $this$mapTo$iv$iv;
        Query query = this.getEntityManager().createNativeQuery(Intrinsics.stringPlus((String)"Select id from histownedproduct where shifter_ID=", (Object)shifterId));
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"entityManager.createNati\u2026e shifter_ID=$shifterId\")");
        Query query2 = query;
        List resultList = query2.getResultList();
        Intrinsics.checkNotNullExpressionValue((Object)resultList, (String)"resultList");
        Iterable $this$map$iv = CollectionsKt.filterNotNull((Iterable)resultList);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Long l = ((BigInteger)it).longValue();
            collection.add(l);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public Pair<Set<Long>, Set<Long>> findServiceIdSummaryByShifter(long shifterId) {
        String sql = "Select id,'os' from offeredservice where shifter_id = " + shifterId + "\n                    union\n                    Select id,'osr' from offeredservice_request where shifter_id=" + shifterId;
        Query query = this.getEntityManager().createNativeQuery(sql);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"entityManager.createNativeQuery(sql)");
        Query query2 = query;
        List resultList = query2.getResultList();
        boolean bl = false;
        Set osr = new LinkedHashSet();
        boolean bl2 = false;
        Set os = new LinkedHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)resultList, (String)"resultList");
        Iterable $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)resultList);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl3 = false;
            Pair mapped = this.findServiceSummaryForShifterMapRow(it);
            if (((Boolean)mapped.getSecond()).booleanValue()) {
                os.add(mapped.getFirst());
                continue;
            }
            osr.add(mapped.getFirst());
        }
        return new Pair((Object)osr, (Object)os);
    }

    private final Pair<Long, Boolean> findServiceSummaryForShifterMapRow(Object any) {
        Object[] row = (Object[])any;
        Object object = row[0];
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.math.BigInteger");
        }
        BigInteger id = (BigInteger)object;
        Object object2 = row[1];
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String displayName = (String)object2;
        return new Pair((Object)id.longValue(), (Object)Intrinsics.areEqual((Object)displayName, (Object)"os"));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ShortShifterOverview> findAllShifter(@NotNull String userProfileId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)userProfileId, (String)"userProfileId");
        String sql = "Select s.id as id,\n     min(s.display_name) as dispName,\n     min(s.description) as description,\n     STRING_AGG(distinct (a.lat || '\u00a7' || a.lng || '*'|| a.id), '_') as places,\n     min((\n         Select STRING_AGG(distinct(innProd.id), '_')\n         from (\n                  Select STRING_AGG(distinct(o3.service_type||'\u00a7'||prod.id),'_') as id\n                  from offeredservice o3\n                           join product prod on o3.productgroup_id = prod.productgroup_id\n                  where o3.shifter_id =s.id\n                  UNION\n                  Select STRING_AGG(distinct(o2.service_type||'\u00a7'||op.products_id),'_')  as id\n                  from offeredservice o2\n                           join offeredservice_products op on o2.id = op.offeredservice_id\n                  where o2.shifter_id =s.id\n              )innProd\n    )) as st,\n      count(distinct r.id)  as counts,\n      min(s.messanger_ior) as messanger_ior,\n      s.shifterdisplay_id as shifterdisplay_id\n      from shifter s\n               join offeredservice o on s.id = o.shifter_id\n               join address a on (s.id = a.shifter_id and a.visibleasmeetingpoint = true)\n               left outer join review r on s.id = r.shifter_about_id and r.helpful = true\n      where s.delete_timepoint is null\n      group by s.id";
        Query query = this.getEntityManager().createNativeQuery(sql);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"entityManager.createNativeQuery(sql)");
        Query query2 = query;
        List resultList = query2.getResultList();
        Intrinsics.checkNotNullExpressionValue((Object)resultList, (String)"resultList");
        Iterable $this$map$iv = CollectionsKt.filterNotNull((Iterable)resultList);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ShortShifterOverview shortShifterOverview = this.findAllShifterMapRow((Object)it);
            collection.add(shortShifterOverview);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ShortShifterOverview> findAllShifterForOneShifter(long shifterId) {
        void $this$mapTo$iv$iv;
        String sql = StringsKt.trimIndent((String)("Select s.id as id,\n     min(s.display_name) as dispName,\n     min(s.description) as description,\n     STRING_AGG(distinct (a.lat || '\u00a7' || a.lng || '*'|| a.id), '_') as places,\n     min((\n         Select STRING_AGG(distinct(innProd.id), '_')\n         from (\n                  Select STRING_AGG(distinct(o3.service_type||'\u00a7'||prod.id),'_') as id\n                  from offeredservice o3\n                           join product prod on o3.productgroup_id = prod.productgroup_id\n                  where o3.shifter_id =s.id\n                  UNION\n                  Select STRING_AGG(distinct(o2.service_type||'\u00a7'||op.products_id),'_')  as id\n                  from offeredservice o2\n                           join offeredservice_products op on o2.id = op.offeredservice_id\n                  where o2.shifter_id =s.id\n              )innProd\n    )) as st,\n      count(distinct r.id)  as counts,\n      min(s.messanger_ior) as messanger_ior,\n      min(s.shifterdisplay_id) as shifterdisplay_id\n      from shifter s\n               left outer join offeredservice o on s.id = o.shifter_id\n               left outer join address a on (s.id = a.shifter_id and a.visibleasmeetingpoint = true)\n               left outer join review r on s.id = r.shifter_about_id and r.helpful = true\n               where s.id=" + shifterId + " and s.delete_timepoint is null\n      group by s.id\n        "));
        Query query = this.getEntityManager().createNativeQuery(sql);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"entityManager.createNativeQuery(sql)");
        Query query2 = query;
        List resultList = query2.getResultList();
        Intrinsics.checkNotNullExpressionValue((Object)resultList, (String)"resultList");
        Iterable $this$map$iv = CollectionsKt.filterNotNull((Iterable)resultList);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ShortShifterOverview shortShifterOverview = this.findAllShifterMapRow((Object)it);
            collection.add(shortShifterOverview);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final ShortShifterOverview findAllShifterMapRow(Object any) {
        boolean bl;
        boolean bl2;
        String string;
        Object[] row = (Object[])any;
        Object object = row[0];
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.math.BigInteger");
        }
        BigInteger id = (BigInteger)object;
        String displayName = (String)row[1];
        String desc = (String)row[2];
        String latLngString = (String)row[3];
        String servString = (String)row[4];
        Object object2 = row[5];
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.math.BigInteger");
        }
        BigInteger rates = (BigInteger)object2;
        String messangerIOR = (String)row[6];
        String shifterdisplayId = null;
        if (row.length > 7) {
            shifterdisplayId = (String)row[7];
        }
        List services = null;
        services = CollectionsKt.emptyList();
        String string2 = servString;
        if (string2 != null) {
            string = string2;
            bl2 = false;
            bl = false;
            String it = string;
            boolean bl3 = false;
            services = this.getServicesFromRow(it);
        }
        string2 = latLngString;
        if (string2 != null) {
            string = string2;
            bl2 = false;
            bl = false;
            String latLng = string;
            boolean bl4 = false;
            return new ShortShifterOverview(id.longValue(), this.getCoordsFromRow(latLng), desc, displayName, rates.intValue(), services, false, messangerIOR, shifterdisplayId);
        }
        return new ShortShifterOverview(id.longValue(), CollectionsKt.emptyList(), desc, displayName, rates.intValue(), services, false, messangerIOR, shifterdisplayId);
    }

    private final List<String> getElemsFromStrAggr(String str) {
        if (!StringsKt.contains$default((CharSequence)str, (CharSequence)"_", (boolean)false, (int)2, null)) {
            if (str.length() > 0) {
                return CollectionsKt.listOf((Object)str);
            }
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        Object[] arr = StringUtils.split((String)str, (char)'_');
        Intrinsics.checkNotNullExpressionValue((Object)arr, (String)"arr");
        return ArraysKt.toList((Object[])arr);
    }

    /*
     * WARNING - void declaration
     */
    private final List<com.shiftphones.shifternetzwerk.service.Service> getServicesFromRow(String str) {
        com.shiftphones.shifternetzwerk.service.Service service;
        Object object;
        Collection collection;
        Object $this$mapTo$iv$iv;
        HashMap services = new HashMap();
        Object $this$map$iv = this.getElemsFromStrAggr(str);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Object object2 = $this$mapTo$iv$iv.iterator();
        while (object2.hasNext()) {
            void it;
            Object item$iv$iv = object2.next();
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = StringUtils.substringBefore((String)it, (String)"\u00a7");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"substringBefore(it, \"\u00a7\")");
            boolean bl2 = false;
            String string2 = ((String)object).toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            object = StringUtils.substringAfter((String)it, (String)"\u00a7");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"substringAfter(it, \"\u00a7\")");
            bl2 = false;
            service = new com.shiftphones.shifternetzwerk.service.Service(string2, CollectionsKt.listOf((Object)Long.parseLong((String)object)));
            collection.add(service);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v;
            com.shiftphones.shifternetzwerk.service.Service it = (com.shiftphones.shifternetzwerk.service.Service)element$iv;
            boolean bl = false;
            services.putIfAbsent(it.getName(), new ArrayList());
            Intrinsics.checkNotNull(services.get(it.getName()));
            Intrinsics.checkNotNullExpressionValue(v, (String)"services.get(it.name)!!");
            List list = (List)v;
            if (list.contains(it.getProds().get(0))) continue;
            list.add(it.getProds().get(0));
        }
        $this$map$iv = services;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        $i$f$mapTo = false;
        object2 = $this$mapTo$iv$iv;
        boolean bl = false;
        for (Map.Entry entry : object2.entrySet()) {
            void it;
            object = entry;
            collection = destination$iv$iv;
            boolean bl3 = false;
            String string = (String)it.getKey();
            boolean bl4 = false;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            service = new com.shiftphones.shifternetzwerk.service.Service(string4, (List)it.getValue());
            collection.add(service);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Coords> getCoordsFromRow(String str) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getElemsFromStrAggr(str);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = StringUtils.substringBefore((String)it, (String)"\u00a7");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substringBefore(it, \"\u00a7\")");
            boolean bl2 = false;
            float f = Float.parseFloat(string2);
            string2 = StringUtils.substringBetween((String)it, (String)"\u00a7", (String)"*");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substringBetween(it, \"\u00a7\", \"*\")");
            bl2 = false;
            float f2 = Float.parseFloat(string2);
            string2 = StringUtils.substringAfter((String)it, (String)"*");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substringAfter(it, \"*\")");
            bl2 = false;
            Coords coords = new Coords(f, f2, Long.parseLong(string2));
            collection.add(coords);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Cacheable(value={"shifterId2IMeis"})
    @NotNull
    public Map<Long, List<String>> shifterId2IMeis() {
        String sql = "Select hp.shifter_id,sn.name from histownedproduct hp\n\t\t    join productinstance pi on hp.productinstance_id = pi.id and pi.validated = true\n\t\t    join serialnumber sn on pi.id = sn.productinstance_id\nwhere hp.valid_from < current_timestamp and (hp.valid_to is null or hp.valid_to > current_timestamp)";
        Query query = this.getEntityManager().createNativeQuery(sql);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"entityManager.createNativeQuery(sql)");
        Query query2 = query;
        List dbResultList = query2.getResultList();
        boolean bl = false;
        Map result = new LinkedHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)dbResultList, (String)"dbResultList");
        Iterable $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)dbResultList);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl2 = false;
            Pair mapping = this.shifterId2IMeisMapRow(it);
            boolean bl3 = false;
            result.putIfAbsent(mapping.getFirst(), (List)new ArrayList());
            List list = (List)result.get(mapping.getFirst());
            if (list == null) continue;
            list.add(mapping.getSecond());
        }
        return result;
    }

    private final Pair<Long, String> shifterId2IMeisMapRow(Object any) {
        Object[] row = (Object[])any;
        Object object = row[0];
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.math.BigInteger");
        }
        BigInteger id = (BigInteger)object;
        Object object2 = row[1];
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String displayName = (String)object2;
        return new Pair((Object)id.longValue(), (Object)displayName);
    }
}

