/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.security.oauth2;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/shiftphones/shifternetzwerk/security/oauth2/AudienceValidator;", "Lorg/springframework/security/oauth2/core/OAuth2TokenValidator;", "Lorg/springframework/security/oauth2/jwt/Jwt;", "allowedAudience", "", "", "(Ljava/util/List;)V", "getAllowedAudience", "()Ljava/util/List;", "error", "Lorg/springframework/security/oauth2/core/OAuth2Error;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "validate", "Lorg/springframework/security/oauth2/core/OAuth2TokenValidatorResult;", "jwt", "shifternetzwerk"})
public final class AudienceValidator
implements OAuth2TokenValidator<Jwt> {
    @NotNull
    private final List<String> allowedAudience;
    private final Logger log;
    @NotNull
    private final OAuth2Error error;

    public AudienceValidator(@NotNull List<String> allowedAudience) {
        Intrinsics.checkNotNullParameter(allowedAudience, (String)"allowedAudience");
        this.allowedAudience = allowedAudience;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.error = new OAuth2Error("invalid_token", "The required audience is missing", null);
        Assert.notEmpty((Collection)this.allowedAudience, (String)"Allowed audience should not be null or empty.");
    }

    @NotNull
    public final List<String> getAllowedAudience() {
        return this.allowedAudience;
    }

    @NotNull
    public OAuth2TokenValidatorResult validate(@NotNull Jwt jwt) {
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        OAuth2TokenValidatorResult oAuth2TokenValidatorResult = OAuth2TokenValidatorResult.success();
        Intrinsics.checkNotNullExpressionValue((Object)oAuth2TokenValidatorResult, (String)"success()");
        return oAuth2TokenValidatorResult;
    }
}

