/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.security.oauth2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.shiftphones.shifternetzwerk.config.KeyCloakConfiguration;
import com.shiftphones.shifternetzwerk.security.oauth2.KeyCloakUserData;
import com.shiftphones.shifternetzwerk.security.oauth2.KeycloakDirectAccess$getUserSData$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/shiftphones/shifternetzwerk/security/oauth2/KeycloakDirectAccess;", "", "keyCloakConfiguration", "Lcom/shiftphones/shifternetzwerk/config/KeyCloakConfiguration;", "(Lcom/shiftphones/shifternetzwerk/config/KeyCloakConfiguration;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "getUserData", "Lcom/shiftphones/shifternetzwerk/security/oauth2/KeyCloakUserData;", "accessToken", "", "userId", "getUserSData", "", "shifternetzwerk"})
public final class KeycloakDirectAccess {
    @NotNull
    private final KeyCloakConfiguration keyCloakConfiguration;
    private final Logger log;

    public KeycloakDirectAccess(@NotNull KeyCloakConfiguration keyCloakConfiguration) {
        Intrinsics.checkNotNullParameter((Object)keyCloakConfiguration, (String)"keyCloakConfiguration");
        this.keyCloakConfiguration = keyCloakConfiguration;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public final Logger getLog() {
        return this.log;
    }

    @Nullable
    public final KeyCloakUserData getUserData(@NotNull String accessToken, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        try {
            RestTemplate rt = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(CollectionsKt.listOf((Object)MediaType.APPLICATION_JSON));
            headers.set("Authorization", Intrinsics.stringPlus((String)"Bearer ", (Object)accessToken));
            HttpEntity entity = new HttpEntity((Object)"", (MultiValueMap)headers);
            String url = this.keyCloakConfiguration.getUrl() + "/admin/realms/" + this.keyCloakConfiguration.getRealm() + "/users/" + userId;
            this.log.info(Intrinsics.stringPlus((String)"Url:", (Object)url));
            ResponseEntity result = rt.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            this.log.info(Intrinsics.stringPlus((String)"result:", (Object)result.getStatusCodeValue()));
            if (!result.getStatusCode().is2xxSuccessful()) {
                this.log.error(url + " : " + result.getStatusCodeValue() + ' ' + result.getBody());
                return null;
            }
            ObjectMapper om = ExtensionsKt.jacksonObjectMapper();
            om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (KeyCloakUserData)om.readValue((String)result.getBody(), KeyCloakUserData.class);
        }
        catch (Exception e) {
            this.log.error("error get Userdata:" + userId + ' ' + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, KeyCloakUserData> getUserSData(@NotNull String accessToken) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        try {
            void $this$mapTo$iv$iv;
            void $this$readValue$iv;
            RestTemplate rt = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(CollectionsKt.listOf((Object)MediaType.APPLICATION_JSON));
            headers.set("Authorization", Intrinsics.stringPlus((String)"Bearer ", (Object)accessToken));
            HttpEntity entity = new HttpEntity((Object)"", (MultiValueMap)headers);
            String url = this.keyCloakConfiguration.getUrl() + "/admin/realms/" + this.keyCloakConfiguration.getRealm() + "/users?max=10000";
            this.log.info(Intrinsics.stringPlus((String)"Url:", (Object)url));
            ResponseEntity result = rt.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            this.log.info(Intrinsics.stringPlus((String)"result:", (Object)result.getStatusCodeValue()));
            if (!result.getStatusCode().is2xxSuccessful()) {
                this.log.error(url + " : " + result.getStatusCodeValue() + ' ' + result.getBody());
                return MapsKt.emptyMap();
            }
            ObjectMapper om = ExtensionsKt.jacksonObjectMapper();
            om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ObjectMapper objectMapper = om;
            Object object = result.getBody();
            Intrinsics.checkNotNull((Object)object);
            String content$iv = (String)object;
            boolean $i$f$readValue22 = false;
            String string = content$iv;
            void var13_15 = $this$readValue$iv;
            boolean $i$f$jacksonTypeRef = false;
            TypeReference typeReference = (TypeReference)new getUserSData$$inlined$readValue$1();
            List list = (List)var13_15.readValue(string, typeReference);
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable $i$f$readValue22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KeyCloakUserData keyCloakUserData = (KeyCloakUserData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getId(), (Object)it);
                collection.add(pair);
            }
            return MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }
        catch (Exception e) {
            this.log.error(Intrinsics.stringPlus((String)"error get Userdatas: ", (Object)e.getMessage()));
            return MapsKt.emptyMap();
        }
    }
}

