/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.service;

import com.shiftphones.shifternetzwerk.domain.Address;
import com.shiftphones.shifternetzwerk.domain.Addresstag;
import com.shiftphones.shifternetzwerk.domain.Shifter;
import com.shiftphones.shifternetzwerk.domain.ShifterAddressTag;
import com.shiftphones.shifternetzwerk.domain.ShifterAdress;
import com.shiftphones.shifternetzwerk.repository.AddressRepository;
import com.shiftphones.shifternetzwerk.repository.AddresstagRepository;
import com.shiftphones.shifternetzwerk.repository.ShifterRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/shiftphones/shifternetzwerk/service/AdressService;", "", "adressRepository", "Lcom/shiftphones/shifternetzwerk/repository/AddressRepository;", "shifterRepository", "Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;", "addresstagRepository", "Lcom/shiftphones/shifternetzwerk/repository/AddresstagRepository;", "(Lcom/shiftphones/shifternetzwerk/repository/AddressRepository;Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;Lcom/shiftphones/shifternetzwerk/repository/AddresstagRepository;)V", "addTag2Address", "Lcom/shiftphones/shifternetzwerk/domain/Address;", "tagAssignment", "Lcom/shiftphones/shifternetzwerk/domain/ShifterAddressTag;", "removeTagFromAddress", "stdSave", "adress", "Lcom/shiftphones/shifternetzwerk/domain/ShifterAdress;", "shifternetzwerk"})
public class AdressService {
    @NotNull
    private final AddressRepository adressRepository;
    @NotNull
    private final ShifterRepository shifterRepository;
    @NotNull
    private final AddresstagRepository addresstagRepository;

    public AdressService(@NotNull AddressRepository adressRepository, @NotNull ShifterRepository shifterRepository, @NotNull AddresstagRepository addresstagRepository) {
        Intrinsics.checkNotNullParameter((Object)adressRepository, (String)"adressRepository");
        Intrinsics.checkNotNullParameter((Object)shifterRepository, (String)"shifterRepository");
        Intrinsics.checkNotNullParameter((Object)addresstagRepository, (String)"addresstagRepository");
        this.adressRepository = adressRepository;
        this.shifterRepository = shifterRepository;
        this.addresstagRepository = addresstagRepository;
    }

    @Transactional
    @NotNull
    public Address stdSave(@NotNull ShifterAdress adress) {
        Intrinsics.checkNotNullParameter((Object)adress, (String)"adress");
        Shifter shifter = (Shifter)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.shifterRepository), (Object)adress.getShifterId());
        if (shifter != null) {
            Shifter shifter2 = shifter;
            boolean bl = false;
            boolean bl2 = false;
            Shifter it = shifter2;
            boolean bl3 = false;
            Address adr = adress.toDomainObject(it);
            Address result = (Address)this.adressRepository.save((Object)adr);
            it.getAdresses().add(adr);
            this.shifterRepository.save((Object)it);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
            return result;
        }
        throw new RuntimeException(Intrinsics.stringPlus((String)"unknown shifterId ", (Object)adress.getShifterId()));
    }

    @Transactional
    @NotNull
    public Address addTag2Address(@NotNull ShifterAddressTag tagAssignment) {
        Intrinsics.checkNotNullParameter((Object)tagAssignment, (String)"tagAssignment");
        Addresstag addresstag = (Addresstag)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.addresstagRepository), (Object)tagAssignment.getAdressTagId());
        if (addresstag != null) {
            Addresstag addresstag2 = addresstag;
            boolean bl = false;
            boolean bl2 = false;
            Addresstag tag = addresstag2;
            boolean bl3 = false;
            Address address = (Address)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.adressRepository), (Object)tagAssignment.getAddressId());
            if (address != null) {
                Address address2 = address;
                boolean bl4 = false;
                boolean bl5 = false;
                Address address3 = address2;
                boolean bl6 = false;
                address3.getTags().add(tag);
                Object object = this.adressRepository.save((Object)address3);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"adressRepository.save(address)");
                return (Address)object;
            }
        }
        throw new RuntimeException(Intrinsics.stringPlus((String)"tagAssignment not valid: ", (Object)tagAssignment));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Address removeTagFromAddress(@NotNull ShifterAddressTag tagAssignment) {
        Intrinsics.checkNotNullParameter((Object)tagAssignment, (String)"tagAssignment");
        Address address = (Address)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.adressRepository), (Object)tagAssignment.getAddressId());
        if (address != null) {
            void $this$filterTo$iv$iv;
            Address address2 = address;
            boolean bl = false;
            boolean bl2 = false;
            Address address3 = address2;
            boolean bl3 = false;
            Iterable $this$filter$iv = address3.getTags();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Addresstag tag = (Addresstag)element$iv$iv;
                boolean bl4 = false;
                Long l = tag.getId();
                Intrinsics.checkNotNull((Object)l);
                if (!(l.longValue() == tagAssignment.getAdressTagId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Addresstag addresstag = (Addresstag)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (addresstag != null) {
                Addresstag addresstag2 = addresstag;
                boolean bl5 = false;
                boolean bl6 = false;
                Addresstag foundTag = addresstag2;
                boolean bl7 = false;
                address3.getTags().remove(foundTag);
            }
            Address result = (Address)this.adressRepository.save((Object)address3);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
            return result;
        }
        throw new RuntimeException(Intrinsics.stringPlus((String)"tagAssignment not valid: ", (Object)tagAssignment));
    }
}

