/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.service;

import com.shiftphones.shifternetzwerk.config.audit.AuditEventConverter;
import com.shiftphones.shifternetzwerk.domain.PersistentAuditEvent;
import com.shiftphones.shifternetzwerk.repository.PersistenceAuditEventRepository;
import io.github.jhipster.config.JHipsterProperties;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Transactional
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\b\u0010\u0019\u001a\u00020\u001aH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/shiftphones/shifternetzwerk/service/AuditEventService;", "", "persistenceAuditEventRepository", "Lcom/shiftphones/shifternetzwerk/repository/PersistenceAuditEventRepository;", "auditEventConverter", "Lcom/shiftphones/shifternetzwerk/config/audit/AuditEventConverter;", "jHipsterProperties", "Lio/github/jhipster/config/JHipsterProperties;", "(Lcom/shiftphones/shifternetzwerk/repository/PersistenceAuditEventRepository;Lcom/shiftphones/shifternetzwerk/config/audit/AuditEventConverter;Lio/github/jhipster/config/JHipsterProperties;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "find", "Ljava/util/Optional;", "Lorg/springframework/boot/actuate/audit/AuditEvent;", "id", "", "findAll", "Lorg/springframework/data/domain/Page;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findByDates", "fromDate", "Ljava/time/Instant;", "toDate", "removeOldAuditEvents", "", "shifternetzwerk"})
public class AuditEventService {
    @NotNull
    private final PersistenceAuditEventRepository persistenceAuditEventRepository;
    @NotNull
    private final AuditEventConverter auditEventConverter;
    @NotNull
    private final JHipsterProperties jHipsterProperties;
    private final Logger log;

    public AuditEventService(@NotNull PersistenceAuditEventRepository persistenceAuditEventRepository, @NotNull AuditEventConverter auditEventConverter, @NotNull JHipsterProperties jHipsterProperties) {
        Intrinsics.checkNotNullParameter((Object)persistenceAuditEventRepository, (String)"persistenceAuditEventRepository");
        Intrinsics.checkNotNullParameter((Object)auditEventConverter, (String)"auditEventConverter");
        Intrinsics.checkNotNullParameter((Object)jHipsterProperties, (String)"jHipsterProperties");
        this.persistenceAuditEventRepository = persistenceAuditEventRepository;
        this.auditEventConverter = auditEventConverter;
        this.jHipsterProperties = jHipsterProperties;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @Scheduled(cron="0 0 12 * * ?")
    public void removeOldAuditEvents() {
        Instant instant = Instant.now().minus(this.jHipsterProperties.getAuditEvents().getRetentionPeriod(), ChronoUnit.DAYS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now().minus(jHipsterProp\u2026oLong(), ChronoUnit.DAYS)");
        Iterable $this$forEach$iv = this.persistenceAuditEventRepository.findByAuditEventDateBefore(instant);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PersistentAuditEvent it = (PersistentAuditEvent)element$iv;
            boolean bl = false;
            this.log.debug(Intrinsics.stringPlus((String)"Deleting audit data ", (Object)it));
            this.persistenceAuditEventRepository.delete((Object)it);
        }
    }

    @Transactional(readOnly=true)
    @NotNull
    public Page<AuditEvent> findAll(@NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.persistenceAuditEventRepository.findAll(pageable).map(arg_0 -> AuditEventService.findAll$lambda-1(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"persistenceAuditEventRep\u2026convertToAuditEvent(it) }");
        return page;
    }

    @Transactional(readOnly=true)
    @NotNull
    public Page<AuditEvent> findByDates(@NotNull Instant fromDate, @NotNull Instant toDate, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)fromDate, (String)"fromDate");
        Intrinsics.checkNotNullParameter((Object)toDate, (String)"toDate");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.persistenceAuditEventRepository.findAllByAuditEventDateBetween(fromDate, toDate, pageable).map(arg_0 -> AuditEventService.findByDates$lambda-2(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"persistenceAuditEventRep\u2026convertToAuditEvent(it) }");
        return page;
    }

    @Transactional(readOnly=true)
    @NotNull
    public Optional<AuditEvent> find(long id) {
        Optional<AuditEvent> optional = this.persistenceAuditEventRepository.findById((Object)id).map(arg_0 -> AuditEventService.find$lambda-3(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"persistenceAuditEventRep\u2026convertToAuditEvent(it) }");
        return optional;
    }

    private static final AuditEvent findAll$lambda-1(AuditEventService this$0, PersistentAuditEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.auditEventConverter.convertToAuditEvent(it);
    }

    private static final AuditEvent findByDates$lambda-2(AuditEventService this$0, PersistentAuditEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.auditEventConverter.convertToAuditEvent(it);
    }

    private static final AuditEvent find$lambda-3(AuditEventService this$0, PersistentAuditEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.auditEventConverter.convertToAuditEvent(it);
    }
}

