/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.service;

import com.shiftphones.shifternetzwerk.config.KeyCloakConfiguration;
import com.shiftphones.shifternetzwerk.security.oauth2.KeyCloakUserData;
import com.shiftphones.shifternetzwerk.security.oauth2.KeycloakDirectAccess;
import com.shiftphones.shifternetzwerk.service.ShifterService;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.thymeleaf.util.StringUtils;

@Service
@CacheConfig(cacheNames={"isPowerUserCache", "keycloakgetUsers"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0017J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130\u0012H\u0017J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u000eH\u0017J\u0012\u0010!\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lcom/shiftphones/shifternetzwerk/service/KeyCloakService;", "", "keyCloakConfiguration", "Lcom/shiftphones/shifternetzwerk/config/KeyCloakConfiguration;", "shifterService", "Lcom/shiftphones/shifternetzwerk/service/ShifterService;", "(Lcom/shiftphones/shifternetzwerk/config/KeyCloakConfiguration;Lcom/shiftphones/shifternetzwerk/service/ShifterService;)V", "getKeyCloakConfiguration", "()Lcom/shiftphones/shifternetzwerk/config/KeyCloakConfiguration;", "getShifterService", "()Lcom/shiftphones/shifternetzwerk/service/ShifterService;", "deleteUsersSchedule", "", "doLogin", "", "login", "pwd", "getAllUserAttributes", "", "Lcom/shiftphones/shifternetzwerk/security/oauth2/KeyCloakUserData;", "getDeletedUserIdsToday", "", "getDeletedUserIdsTodayByAdmin", "getDeletedUserIdsTodayByUserEvents", "getUserById", "Lorg/keycloak/admin/client/resource/UserResource;", "userId", "isCurrentUserPoweruser", "", "isEventToday", "actionTime", "", "isPoweruser", "userAttributes", "shifternetzwerk"})
public class KeyCloakService {
    @NotNull
    private final KeyCloakConfiguration keyCloakConfiguration;
    @NotNull
    private final ShifterService shifterService;

    public KeyCloakService(@NotNull KeyCloakConfiguration keyCloakConfiguration, @NotNull ShifterService shifterService) {
        Intrinsics.checkNotNullParameter((Object)keyCloakConfiguration, (String)"keyCloakConfiguration");
        Intrinsics.checkNotNullParameter((Object)shifterService, (String)"shifterService");
        this.keyCloakConfiguration = keyCloakConfiguration;
        this.shifterService = shifterService;
    }

    @NotNull
    public KeyCloakConfiguration getKeyCloakConfiguration() {
        return this.keyCloakConfiguration;
    }

    @NotNull
    public ShifterService getShifterService() {
        return this.shifterService;
    }

    @Scheduled(fixedDelay=600000L, initialDelay=60000L)
    public void deleteUsersSchedule() {
        Logger log = LoggerFactory.getLogger(this.getClass());
        log.info("start schedule");
        Iterable $this$forEach$iv = this.getDeletedUserIdsToday();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            log.info(Intrinsics.stringPlus((String)"found user 2 delete: ", (Object)it));
            this.getShifterService().deleteUserServices(it);
            log.info(Intrinsics.stringPlus((String)"Deleted user: ", (Object)it));
        }
        log.info("Schedule finished");
    }

    public boolean isCurrentUserPoweruser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String string = authentication.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"authentication.name");
        return this.isPoweruser(string);
    }

    @Nullable
    public KeyCloakUserData userAttributes(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        KeycloakDirectAccess dirAccess = new KeycloakDirectAccess(this.getKeyCloakConfiguration());
        String loginToken = this.doLogin(this.getKeyCloakConfiguration().getAdminName(), this.getKeyCloakConfiguration().getAdminPwd());
        return dirAccess.getUserData(loginToken, userId);
    }

    @Cacheable(value={"keycloakgetUsers"})
    @NotNull
    public Map<String, KeyCloakUserData> getAllUserAttributes() {
        KeycloakDirectAccess dirAccess = new KeycloakDirectAccess(this.getKeyCloakConfiguration());
        String loginToken = this.doLogin(this.getKeyCloakConfiguration().getAdminName(), this.getKeyCloakConfiguration().getAdminPwd());
        return dirAccess.getUserSData(loginToken);
    }

    private final String doLogin(String login, String pwd) {
        Object object = KeycloakBuilder.builder().serverUrl(this.getKeyCloakConfiguration().getUrl()).realm(this.getKeyCloakConfiguration().getRealm()).username(login).password(pwd).clientId("admin-cli").resteasyClient(new ResteasyClientBuilder().connectionPoolSize(10).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder() //\n           \u2026) //\n            .build()");
        Keycloak kc = object;
        object = kc.tokenManager().getAccessTokenString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kc.tokenManager().accessTokenString");
        return object;
    }

    @Cacheable(value={"isPowerUserCache"}, key="#createdId")
    public boolean isPoweruser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserResource userResource = this.getUserById(userId);
        if (userResource != null) {
            boolean bl;
            block4: {
                UserResource userResource2 = userResource;
                boolean bl2 = false;
                boolean bl3 = false;
                UserResource it = userResource2;
                boolean bl4 = false;
                List list = it.groups();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"it.groups()");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GroupRepresentation g = (GroupRepresentation)element$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)g.getName(), (Object)"powerusergroup")) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    @Nullable
    public UserResource getUserById(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Keycloak keycloak = KeycloakBuilder.builder().serverUrl(this.getKeyCloakConfiguration().getUrl()).realm(this.getKeyCloakConfiguration().getRealm()).username(this.getKeyCloakConfiguration().getAdminName()).password(this.getKeyCloakConfiguration().getAdminPwd()).clientId("admin-cli").resteasyClient(new ResteasyClientBuilder().connectionPoolSize(1000).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)keycloak, (String)"builder()\n            .s\u2026) //\n            .build()");
        Keycloak kc = keycloak;
        keycloak = kc.realm(this.getKeyCloakConfiguration().getRealm()).users();
        return keycloak == null ? null : keycloak.get(userId);
    }

    @NotNull
    public List<String> getDeletedUserIdsToday() {
        boolean bl = false;
        List result = new ArrayList();
        result.addAll(this.getDeletedUserIdsTodayByAdmin());
        result.addAll(this.getDeletedUserIdsTodayByUserEvents());
        return result;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public List<String> getDeletedUserIdsTodayByAdmin() {
        var2_1 /* !! */  = KeycloakBuilder.builder().serverUrl(this.getKeyCloakConfiguration().getUrl()).realm(this.getKeyCloakConfiguration().getRealm()).username(this.getKeyCloakConfiguration().getAdminName()).password(this.getKeyCloakConfiguration().getAdminPwd()).clientId("admin-cli").resteasyClient(new ResteasyClientBuilder().connectionPoolSize(10).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)var2_1 /* !! */ , (String)"builder() //\n           \u2026) //\n            .build()");
        kc = var2_1 /* !! */ ;
        var2_1 /* !! */  = kc.realm(this.getKeyCloakConfiguration().getRealm()).getAdminEvents();
        Intrinsics.checkNotNullExpressionValue((Object)var2_1 /* !! */ , (String)"kc.realm(keyCloakConfiguration.realm).adminEvents");
        $this$filter$iv = (Iterable)var2_1 /* !! */ ;
        $i$f$filter = false;
        var4_4 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (AdminEventRepresentation)element$iv$iv;
            $i$a$-filter-KeyCloakService$getDeletedUserIdsTodayByAdmin$1 = false;
            if (!this.isEventToday(it.getTime()) || !Intrinsics.areEqual((Object)it.getOperationType(), (Object)"DELETE")) ** GOTO lbl-1000
            var11_11 = StringUtils.startsWith((Object)it.getResourcePath(), (String)"users/");
            Intrinsics.checkNotNullExpressionValue((Object)var11_11, (String)"startsWith(it.resourcePath, \"users/\")");
            if (var11_11.booleanValue()) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!v0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (AdminEventRepresentation)item$iv$iv;
            var12_12 = destination$iv$iv;
            $i$a$-map-KeyCloakService$getDeletedUserIdsTodayByAdmin$2 = false;
            var13_13 = StringUtils.substringAfter((Object)it.getResourcePath(), (String)"users/");
            var12_12.add(var13_13);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getDeletedUserIdsTodayByUserEvents() {
        void $this$mapTo$iv$iv;
        EventRepresentation it;
        Iterable $this$filterTo$iv$iv;
        Object object = KeycloakBuilder.builder().serverUrl(this.getKeyCloakConfiguration().getUrl()).realm(this.getKeyCloakConfiguration().getRealm()).username(this.getKeyCloakConfiguration().getAdminName()).password(this.getKeyCloakConfiguration().getAdminPwd()).clientId("shifternetzwerk").resteasyClient(new ResteasyClientBuilder().connectionPoolSize(10).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder() //\n           \u2026) //\n            .build()");
        Keycloak kc = object;
        object = kc.realm(this.getKeyCloakConfiguration().getRealm()).getEvents();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kc.realm(keyCloakConfiguration.realm).events");
        Iterable $this$filter$iv = (Iterable)object;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (EventRepresentation)element$iv$iv;
            boolean bl = false;
            if (!(this.isEventToday(it.getTime()) && Intrinsics.areEqual((Object)it.getType(), (Object)"DELETE_ACCOUNT"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (EventRepresentation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getUserId();
            collection.add(string);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    public boolean isEventToday(long actionTime) {
        LocalDate date = Instant.ofEpochMilli(actionTime).atZone(ZoneId.systemDefault()).toLocalDate();
        return Intrinsics.areEqual((Object)date, (Object)LocalDate.now());
    }
}

