/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.service;

import com.shiftphones.shifternetzwerk.domain.User;
import io.github.jhipster.config.JHipsterProperties;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J0\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0017J \u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015H\u0017J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/shiftphones/shifternetzwerk/service/MailService;", "", "jHipsterProperties", "Lio/github/jhipster/config/JHipsterProperties;", "javaMailSender", "Lorg/springframework/mail/javamail/JavaMailSender;", "messageSource", "Lorg/springframework/context/MessageSource;", "templateEngine", "Lorg/thymeleaf/spring5/SpringTemplateEngine;", "(Lio/github/jhipster/config/JHipsterProperties;Lorg/springframework/mail/javamail/JavaMailSender;Lorg/springframework/context/MessageSource;Lorg/thymeleaf/spring5/SpringTemplateEngine;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sendActivationEmail", "", "user", "Lcom/shiftphones/shifternetzwerk/domain/User;", "sendCreationEmail", "sendEmail", "to", "", "subject", "content", "isMultipart", "", "isHtml", "sendEmailFromTemplate", "templateName", "titleKey", "sendPasswordResetMail", "shifternetzwerk"})
public class MailService {
    @NotNull
    private final JHipsterProperties jHipsterProperties;
    @NotNull
    private final JavaMailSender javaMailSender;
    @NotNull
    private final MessageSource messageSource;
    @NotNull
    private final SpringTemplateEngine templateEngine;
    private final Logger log;

    public MailService(@NotNull JHipsterProperties jHipsterProperties, @NotNull JavaMailSender javaMailSender, @NotNull MessageSource messageSource, @NotNull SpringTemplateEngine templateEngine) {
        Intrinsics.checkNotNullParameter((Object)jHipsterProperties, (String)"jHipsterProperties");
        Intrinsics.checkNotNullParameter((Object)javaMailSender, (String)"javaMailSender");
        Intrinsics.checkNotNullParameter((Object)messageSource, (String)"messageSource");
        Intrinsics.checkNotNullParameter((Object)templateEngine, (String)"templateEngine");
        this.jHipsterProperties = jHipsterProperties;
        this.javaMailSender = javaMailSender;
        this.messageSource = messageSource;
        this.templateEngine = templateEngine;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @Async
    public void sendEmail(@NotNull String to, @NotNull String subject, @NotNull String content, boolean isMultipart, boolean isHtml) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Object[] objectArray = new Object[]{isMultipart, isHtml, to, subject, content};
        this.log.debug("Send email[multipart '{}' and html '{}'] to '{}' with subject '{}' and content={}", objectArray);
        objectArray = new Object[]{isMultipart, isHtml, to, subject, content};
        this.log.debug("Send email[multipart '{}' and html '{}'] to '{}' with subject '{}' and content={}", objectArray);
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        try {
            MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, isMultipart, StandardCharsets.UTF_8.name());
            boolean bl = false;
            boolean bl2 = false;
            MimeMessageHelper $this$sendEmail_u24lambda_u2d0 = mimeMessageHelper;
            boolean bl3 = false;
            $this$sendEmail_u24lambda_u2d0.setTo(to);
            $this$sendEmail_u24lambda_u2d0.setFrom(this.jHipsterProperties.getMail().getFrom());
            $this$sendEmail_u24lambda_u2d0.setSubject(subject);
            $this$sendEmail_u24lambda_u2d0.setText(content, isHtml);
            this.javaMailSender.send(mimeMessage);
            this.log.debug("Sent email to User '{}'", (Object)to);
        }
        catch (MailException e) {
            this.log.warn("Email could not be sent to user '{}'", (Object)to, (Object)e);
        }
        catch (MessagingException e) {
            this.log.warn("Email could not be sent to user '{}'", (Object)to, (Object)e);
        }
    }

    @Async
    public void sendEmailFromTemplate(@NotNull User user, @NotNull String templateName, @NotNull String titleKey) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        Intrinsics.checkNotNullParameter((Object)titleKey, (String)"titleKey");
        Locale locale = Locale.forLanguageTag(user.getLangKey());
        Context context = new Context(locale);
        boolean bl = false;
        boolean bl2 = false;
        Context $this$sendEmailFromTemplate_u24lambda_u2d1 = context;
        boolean bl3 = false;
        $this$sendEmailFromTemplate_u24lambda_u2d1.setVariable("user", (Object)user);
        $this$sendEmailFromTemplate_u24lambda_u2d1.setVariable("baseUrl", (Object)this.jHipsterProperties.getMail().getBaseUrl());
        Context context2 = context;
        String content = this.templateEngine.process(templateName, (IContext)context2);
        String subject = this.messageSource.getMessage(titleKey, null, locale);
        String string = user.getEmail();
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNullExpressionValue((Object)subject, (String)"subject");
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"content");
        this.sendEmail(string, subject, content, false, true);
    }

    @Async
    public void sendActivationEmail(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.log.debug("Sending activation email to '{}'", (Object)user.getEmail());
        this.sendEmailFromTemplate(user, "mail/activationEmail", "email.activation.title");
    }

    @Async
    public void sendCreationEmail(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.log.debug("Sending creation email to '{}'", (Object)user.getEmail());
        this.sendEmailFromTemplate(user, "mail/creationEmail", "email.activation.title");
    }

    @Async
    public void sendPasswordResetMail(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.log.debug("Sending password reset email to '{}'", (Object)user.getEmail());
        this.sendEmailFromTemplate(user, "mail/passwordResetEmail", "email.reset.title");
    }
}

