/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.service;

import com.shiftphones.shifternetzwerk.domain.Offeredservice;
import com.shiftphones.shifternetzwerk.domain.OfferedserviceCreationRequest;
import com.shiftphones.shifternetzwerk.domain.OfferedserviceRequest;
import com.shiftphones.shifternetzwerk.domain.Product;
import com.shiftphones.shifternetzwerk.domain.Productgroup;
import com.shiftphones.shifternetzwerk.domain.Shifter;
import com.shiftphones.shifternetzwerk.domain.enumeration.ServiceState;
import com.shiftphones.shifternetzwerk.domain.enumeration.ShifterRolesEnum;
import com.shiftphones.shifternetzwerk.repository.OfferedserviceRepository;
import com.shiftphones.shifternetzwerk.repository.OfferedserviceRequestRepository;
import com.shiftphones.shifternetzwerk.repository.ProductRepository;
import com.shiftphones.shifternetzwerk.repository.ProductgroupRepository;
import com.shiftphones.shifternetzwerk.service.OfferedServiceService;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J'\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J'\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0017\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u001cH\u0002J\u001a\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010%H\u0017J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001eH\u0002R\u001c\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/shiftphones/shifternetzwerk/service/OfferedServiceService;", "", "offeredserviceRequestRepository", "Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRequestRepository;", "offeredserviceRepository", "Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRepository;", "productRepository", "Lcom/shiftphones/shifternetzwerk/repository/ProductRepository;", "productGroupRepository", "Lcom/shiftphones/shifternetzwerk/repository/ProductgroupRepository;", "(Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRequestRepository;Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRepository;Lcom/shiftphones/shifternetzwerk/repository/ProductRepository;Lcom/shiftphones/shifternetzwerk/repository/ProductgroupRepository;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "acceptOfferedServiceRequest", "", "serviceRequestId", "", "checkShifterAccess", "shifterUserId", "isPowerUser", "", "offeredserviceRequestShifterId", "(Ljava/lang/Long;ZJ)V", "createOfferedServiceByRequest", "offeredserviceRequest", "Lcom/shiftphones/shifternetzwerk/domain/OfferedserviceRequest;", "createRequest", "Lcom/shiftphones/shifternetzwerk/domain/OfferedserviceCreationRequest;", "shifterId", "(Lcom/shiftphones/shifternetzwerk/domain/OfferedserviceCreationRequest;Ljava/lang/Long;Z)Lcom/shiftphones/shifternetzwerk/domain/OfferedserviceRequest;", "isDirectAcceptAllowed", "result", "rejectOfferedServiceRequest", "rejectionReason", "", "validateDependantObjects", "shifternetzwerk"})
public class OfferedServiceService {
    @NotNull
    private final OfferedserviceRequestRepository offeredserviceRequestRepository;
    @NotNull
    private final OfferedserviceRepository offeredserviceRepository;
    @NotNull
    private final ProductRepository productRepository;
    @NotNull
    private final ProductgroupRepository productGroupRepository;
    private final Logger log;

    public OfferedServiceService(@NotNull OfferedserviceRequestRepository offeredserviceRequestRepository, @NotNull OfferedserviceRepository offeredserviceRepository, @NotNull ProductRepository productRepository, @NotNull ProductgroupRepository productGroupRepository) {
        Intrinsics.checkNotNullParameter((Object)offeredserviceRequestRepository, (String)"offeredserviceRequestRepository");
        Intrinsics.checkNotNullParameter((Object)offeredserviceRepository, (String)"offeredserviceRepository");
        Intrinsics.checkNotNullParameter((Object)productRepository, (String)"productRepository");
        Intrinsics.checkNotNullParameter((Object)productGroupRepository, (String)"productGroupRepository");
        this.offeredserviceRequestRepository = offeredserviceRequestRepository;
        this.offeredserviceRepository = offeredserviceRepository;
        this.productRepository = productRepository;
        this.productGroupRepository = productGroupRepository;
        this.log = LoggerFactory.getLogger(OfferedServiceService.class);
    }

    public Logger getLog() {
        return this.log;
    }

    @Transactional
    @NotNull
    public OfferedserviceRequest createRequest(@NotNull OfferedserviceCreationRequest offeredserviceRequest, @Nullable Long shifterId, boolean isPowerUser) {
        Intrinsics.checkNotNullParameter((Object)offeredserviceRequest, (String)"offeredserviceRequest");
        ShifterRolesEnum.valueOf((String)offeredserviceRequest.getServiceType());
        this.checkShifterAccess(shifterId, isPowerUser, offeredserviceRequest.getShifterId());
        this.validateDependantObjects(offeredserviceRequest);
        OfferedserviceRequest result = (OfferedserviceRequest)this.offeredserviceRequestRepository.save((Object)offeredserviceRequest.toBusinessObject());
        Long l = result.getId();
        if (l != null) {
            Long l2 = l;
            boolean bl = false;
            boolean bl2 = false;
            long id = ((Number)l2).longValue();
            boolean bl3 = false;
            this.getLog().info(Intrinsics.stringPlus((String)"Created offeredServicerequest ", (Object)id));
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
            if (this.isDirectAcceptAllowed(result)) {
                this.createOfferedServiceByRequest(result);
            }
            return result;
        }
        throw new RuntimeException("OfferedService could not be stored for unknown reasons");
    }

    @Transactional
    public void acceptOfferedServiceRequest(long serviceRequestId) {
        OfferedserviceRequest offeredserviceRequest = (OfferedserviceRequest)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.offeredserviceRequestRepository), (Object)serviceRequestId);
        if (offeredserviceRequest != null) {
            OfferedserviceRequest offeredserviceRequest2 = offeredserviceRequest;
            boolean bl = false;
            boolean bl2 = false;
            OfferedserviceRequest it = offeredserviceRequest2;
            boolean bl3 = false;
            if (it.getState() != ServiceState.REQUESTED) {
                throw new RuntimeException("service request always responded");
            }
            this.createOfferedServiceByRequest(it);
            return;
        }
        throw new RuntimeException("Invalid id");
    }

    @Transactional
    public void rejectOfferedServiceRequest(long serviceRequestId, @Nullable String rejectionReason) {
        OfferedserviceRequest offeredserviceRequest = (OfferedserviceRequest)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.offeredserviceRequestRepository), (Object)serviceRequestId);
        if (offeredserviceRequest != null) {
            OfferedserviceRequest offeredserviceRequest2 = offeredserviceRequest;
            boolean bl = false;
            boolean bl2 = false;
            OfferedserviceRequest it = offeredserviceRequest2;
            boolean bl3 = false;
            if (it.getState() != ServiceState.REQUESTED) {
                throw new RuntimeException("service request always responded");
            }
            it.setReasonRejection(rejectionReason);
            it.setState(ServiceState.DEACTIVE);
            this.offeredserviceRequestRepository.save((Object)it);
            this.getLog().info(Intrinsics.stringPlus((String)"Service request rejected ", (Object)it.getId()));
            return;
        }
        throw new RuntimeException("Invalid id");
    }

    private final boolean isDirectAcceptAllowed(OfferedserviceRequest result) {
        boolean bl;
        ShifterRolesEnum shifterRolesEnum = result.getServiceType();
        int n = WhenMappings.$EnumSwitchMapping$0[shifterRolesEnum.ordinal()];
        switch (n) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void createOfferedServiceByRequest(OfferedserviceRequest offeredserviceRequest) {
        Collection<Product> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Productgroup productGroup = null;
        Productgroup productgroup = offeredserviceRequest.getProductgroup();
        if (productgroup != null) {
            object = productgroup;
            boolean bl = false;
            boolean bl2 = false;
            Productgroup it = object;
            boolean bl3 = false;
            Productgroup productgroup2 = new Productgroup(null, null, null, 7, null);
            boolean bl4 = false;
            boolean bl5 = false;
            Productgroup $this$createOfferedServiceByRequest_u24lambda_u2d4_u24lambda_u2d3 = productgroup2;
            boolean bl6 = false;
            $this$createOfferedServiceByRequest_u24lambda_u2d4_u24lambda_u2d3.setId(it.getId());
            Unit unit = Unit.INSTANCE;
            productGroup = productgroup2;
        }
        object = offeredserviceRequest.getProducts();
        Shifter shifter = offeredserviceRequest.getShifter();
        Productgroup productgroup3 = productGroup;
        ZonedDateTime zonedDateTime = null;
        ZonedDateTime zonedDateTime2 = ZonedDateTime.now();
        String string = null;
        ShifterRolesEnum shifterRolesEnum = offeredserviceRequest.getServiceType();
        Long l = null;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Product product = (Product)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Product product2 = new Product(null, null, null, null, null, null, null, null, 255, null);
            boolean bl7 = false;
            boolean bl8 = false;
            Product $this$createOfferedServiceByRequest_u24lambda_u2d6_u24lambda_u2d5 = product2;
            boolean bl9 = false;
            $this$createOfferedServiceByRequest_u24lambda_u2d6_u24lambda_u2d5.setId(it.getId());
            Product product3 = product2;
            collection.add(product3);
        }
        collection = (List)destination$iv$iv;
        Set set = CollectionsKt.toMutableSet((Iterable)collection);
        Shifter shifter2 = shifter;
        Productgroup productgroup4 = productgroup3;
        ZonedDateTime zonedDateTime3 = zonedDateTime;
        ZonedDateTime zonedDateTime4 = zonedDateTime2;
        String string2 = string;
        ShifterRolesEnum shifterRolesEnum2 = shifterRolesEnum;
        Long l2 = l;
        Offeredservice offeredService = new Offeredservice(l2, shifterRolesEnum2, string2, zonedDateTime4, zonedDateTime3, productgroup4, shifter2, set);
        Offeredservice savedResult = (Offeredservice)this.offeredserviceRepository.save((Object)offeredService);
        offeredserviceRequest.setState(ServiceState.ACTIV);
        this.offeredserviceRequestRepository.save((Object)offeredserviceRequest);
        this.getLog().info(Intrinsics.stringPlus((String)"Created offeredServicer ", (Object)savedResult.getId()));
    }

    private final void validateDependantObjects(OfferedserviceCreationRequest offeredserviceRequest) {
        long it;
        Iterable $this$forEach$iv = offeredserviceRequest.getProductIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = ((Number)element$iv).longValue();
            boolean bl = false;
            if (CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.productRepository), (Object)it) != null) continue;
            throw new RuntimeException("Product is unknown");
        }
        Long l = offeredserviceRequest.getProductGroupId();
        if (l != null) {
            Long l2 = l;
            boolean bl = false;
            boolean bl2 = false;
            it = ((Number)l2).longValue();
            boolean bl3 = false;
            if (CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.productGroupRepository), (Object)it) == null) {
                throw new RuntimeException("Productgroup is unknown");
            }
        }
    }

    public void checkShifterAccess(@Nullable Long shifterUserId, boolean isPowerUser, long offeredserviceRequestShifterId) {
        if (!isPowerUser) {
            Long l = shifterUserId;
            if (l != null) {
                Long l2 = l;
                boolean bl = false;
                boolean bl2 = false;
                long it = ((Number)l2).longValue();
                boolean bl3 = false;
                if (it != offeredserviceRequestShifterId) {
                    throw new RuntimeException("Shifter has only allowance to create requests for own account ");
                }
                return;
            }
            throw new RuntimeException("non poweruser has no shifter assigned");
        }
    }
}

