/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.service;

import com.shiftphones.shifternetzwerk.domain.Histownedproduct;
import com.shiftphones.shifternetzwerk.domain.Product;
import com.shiftphones.shifternetzwerk.domain.Productinstance;
import com.shiftphones.shifternetzwerk.domain.Serialnumber;
import com.shiftphones.shifternetzwerk.domain.Shifter;
import com.shiftphones.shifternetzwerk.domain.UserProductInstance;
import com.shiftphones.shifternetzwerk.repository.HistownedproductRepository;
import com.shiftphones.shifternetzwerk.repository.ProductinstanceRepository;
import com.shiftphones.shifternetzwerk.repository.SerialnumberRepository;
import com.shiftphones.shifternetzwerk.web.rest.ResourceHelperService;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u0012\u0010 \u001a\u0004\u0018\u00010\u00172\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0019H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lcom/shiftphones/shifternetzwerk/service/ProductInstanceService;", "", "productinstanceRepository", "Lcom/shiftphones/shifternetzwerk/repository/ProductinstanceRepository;", "serialnumberRepository", "Lcom/shiftphones/shifternetzwerk/repository/SerialnumberRepository;", "histownedproductRepository", "Lcom/shiftphones/shifternetzwerk/repository/HistownedproductRepository;", "resourceHelperService", "Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;", "entityManager", "Ljavax/persistence/EntityManager;", "(Lcom/shiftphones/shifternetzwerk/repository/ProductinstanceRepository;Lcom/shiftphones/shifternetzwerk/repository/SerialnumberRepository;Lcom/shiftphones/shifternetzwerk/repository/HistownedproductRepository;Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;Ljavax/persistence/EntityManager;)V", "getHistownedproductRepository", "()Lcom/shiftphones/shifternetzwerk/repository/HistownedproductRepository;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getProductinstanceRepository", "()Lcom/shiftphones/shifternetzwerk/repository/ProductinstanceRepository;", "getSerialnumberRepository", "()Lcom/shiftphones/shifternetzwerk/repository/SerialnumberRepository;", "create", "Lcom/shiftphones/shifternetzwerk/domain/Productinstance;", "pi", "Lcom/shiftphones/shifternetzwerk/domain/UserProductInstance;", "endOwnership", "", "piId", "", "findActiveOwnerShip", "Lcom/shiftphones/shifternetzwerk/domain/Histownedproduct;", "findProductInstanceByImei", "imei", "", "stdSaveLogic", "upi", "shifternetzwerk"})
public class ProductInstanceService {
    @NotNull
    private final ProductinstanceRepository productinstanceRepository;
    @NotNull
    private final SerialnumberRepository serialnumberRepository;
    @NotNull
    private final HistownedproductRepository histownedproductRepository;
    @NotNull
    private final ResourceHelperService resourceHelperService;
    @NotNull
    private final EntityManager entityManager;
    private final Logger log;

    public ProductInstanceService(@NotNull ProductinstanceRepository productinstanceRepository, @NotNull SerialnumberRepository serialnumberRepository, @NotNull HistownedproductRepository histownedproductRepository, @NotNull ResourceHelperService resourceHelperService, @NotNull EntityManager entityManager) {
        Intrinsics.checkNotNullParameter((Object)productinstanceRepository, (String)"productinstanceRepository");
        Intrinsics.checkNotNullParameter((Object)serialnumberRepository, (String)"serialnumberRepository");
        Intrinsics.checkNotNullParameter((Object)histownedproductRepository, (String)"histownedproductRepository");
        Intrinsics.checkNotNullParameter((Object)resourceHelperService, (String)"resourceHelperService");
        Intrinsics.checkNotNullParameter((Object)entityManager, (String)"entityManager");
        this.productinstanceRepository = productinstanceRepository;
        this.serialnumberRepository = serialnumberRepository;
        this.histownedproductRepository = histownedproductRepository;
        this.resourceHelperService = resourceHelperService;
        this.entityManager = entityManager;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    public ProductinstanceRepository getProductinstanceRepository() {
        return this.productinstanceRepository;
    }

    @NotNull
    public SerialnumberRepository getSerialnumberRepository() {
        return this.serialnumberRepository;
    }

    @NotNull
    public HistownedproductRepository getHistownedproductRepository() {
        return this.histownedproductRepository;
    }

    @NotNull
    public Productinstance create(@NotNull UserProductInstance pi) {
        Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
        Productinstance result = this.stdSaveLogic(pi);
        this.log.info(Intrinsics.stringPlus((String)"Created new serviceProvider ", (Object)result.getId()));
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Productinstance stdSaveLogic(UserProductInstance upi) {
        Set $this$mapTo$iv$iv;
        Iterable $this$map$iv = upi.getSerialNumbers();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Serialnumber serialnumber = new Serialnumber(null, (String)it, null, 5, null);
            collection.add(serialnumber);
        }
        List serialnumbers = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        Product $i$f$map22 = new Product(Long.valueOf(upi.getProductId()), null, null, null, null, null, null, null, 254, null);
        $this$mapTo$iv$iv = CollectionsKt.toMutableSet((Iterable)serialnumbers);
        Productinstance pi = new Productinstance(null, Boolean.valueOf(false), $this$mapTo$iv$iv, null, $i$f$map22, 9, null);
        Productinstance result = (Productinstance)this.getProductinstanceRepository().save((Object)pi);
        Iterable $this$forEach$iv = serialnumbers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Serialnumber it = (Serialnumber)element$iv;
            boolean bl = false;
            it.setProductinstance(result);
        }
        this.getSerialnumberRepository().saveAll((Iterable)serialnumbers);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        return result;
    }

    @Transactional
    @Nullable
    public Histownedproduct findActiveOwnerShip(long piId) {
        Query query = this.entityManager.createNativeQuery("select id from histownedproduct where productinstance_id = " + piId + " and valid_to is null");
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"entityManager.createNati\u2026Id and valid_to is null\")");
        Query query2 = query;
        List resultList = query2.getResultList();
        if (resultList != null) {
            Collection collection = resultList;
            boolean bl = false;
            if (!collection.isEmpty()) {
                Object e = resultList.get(0);
                if (e == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.math.BigInteger");
                }
                BigInteger id = (BigInteger)e;
                return (Histownedproduct)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.getHistownedproductRepository()), (Object)id.longValue());
            }
        }
        return null;
    }

    public void endOwnership(long piId) {
        Productinstance productinstance = (Productinstance)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.getProductinstanceRepository()), (Object)piId);
        if (productinstance != null) {
            Productinstance productinstance2 = productinstance;
            boolean bl = false;
            boolean bl2 = false;
            Productinstance it = productinstance2;
            boolean bl3 = false;
            Histownedproduct histownedproduct = this.findActiveOwnerShip(piId);
            if (histownedproduct != null) {
                Histownedproduct histownedproduct2 = histownedproduct;
                boolean bl4 = false;
                boolean bl5 = false;
                Histownedproduct it2 = histownedproduct2;
                boolean bl6 = false;
                Shifter shifter = it2.getShifter();
                Intrinsics.checkNotNull((Object)shifter);
                Long l = shifter.getId();
                Intrinsics.checkNotNull((Object)l);
                this.resourceHelperService.isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed(l.longValue());
                it2.setValidTo(ZonedDateTime.now());
                this.getHistownedproductRepository().save((Object)it2);
                return;
            }
        }
        throw new RuntimeException(Intrinsics.stringPlus((String)"no open ownership found piId ", (Object)piId));
    }

    @Nullable
    public Productinstance findProductInstanceByImei(@NotNull String imei) {
        Intrinsics.checkNotNullParameter((Object)imei, (String)"imei");
        Serialnumber serialnumber = this.getSerialnumberRepository().findByName(imei);
        return serialnumber == null ? null : serialnumber.getProductinstance();
    }
}

