/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.service;

import com.shiftphones.shifternetzwerk.domain.Address;
import com.shiftphones.shifternetzwerk.domain.Offeredservice;
import com.shiftphones.shifternetzwerk.domain.Shifter;
import com.shiftphones.shifternetzwerk.domain.ShortEntityObject;
import com.shiftphones.shifternetzwerk.domain.Userprofile;
import com.shiftphones.shifternetzwerk.hateoas.ShifterDataManipulationObject;
import com.shiftphones.shifternetzwerk.repository.AddressRepository;
import com.shiftphones.shifternetzwerk.repository.OfferedserviceRepository;
import com.shiftphones.shifternetzwerk.repository.ServiceProviderRepositoryDbDirectSearch;
import com.shiftphones.shifternetzwerk.repository.ShifterRepository;
import com.shiftphones.shifternetzwerk.repository.UserprofileRepository;
import com.shiftphones.shifternetzwerk.service.ShifterIdCreationService;
import com.shiftphones.shifternetzwerk.service.ShortIdAnswer;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0017J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020#H\u0017J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020%H\u0017J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-H\u0017J\u0010\u0010.\u001a\u00020*2\u0006\u0010(\u001a\u00020#H\u0002J\u0010\u0010/\u001a\u00020#2\u0006\u0010(\u001a\u00020#H\u0002J\u0010\u0010/\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u00100\u001a\u00020*2\u0006\u0010(\u001a\u00020#H\u0017J\u0010\u00100\u001a\u00020*2\u0006\u0010(\u001a\u00020%H\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00061"}, d2={"Lcom/shiftphones/shifternetzwerk/service/ShifterService;", "", "shifterRepository", "Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;", "addressRepository", "Lcom/shiftphones/shifternetzwerk/repository/AddressRepository;", "usersProfileRepository", "Lcom/shiftphones/shifternetzwerk/repository/UserprofileRepository;", "offeredserviceRepository", "Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRepository;", "serviceProviderRepositoryDbDirectSearch", "Lcom/shiftphones/shifternetzwerk/repository/ServiceProviderRepositoryDbDirectSearch;", "shifterIdCreationService", "Lcom/shiftphones/shifternetzwerk/service/ShifterIdCreationService;", "(Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;Lcom/shiftphones/shifternetzwerk/repository/AddressRepository;Lcom/shiftphones/shifternetzwerk/repository/UserprofileRepository;Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRepository;Lcom/shiftphones/shifternetzwerk/repository/ServiceProviderRepositoryDbDirectSearch;Lcom/shiftphones/shifternetzwerk/service/ShifterIdCreationService;)V", "getAddressRepository", "()Lcom/shiftphones/shifternetzwerk/repository/AddressRepository;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getOfferedserviceRepository", "()Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRepository;", "getServiceProviderRepositoryDbDirectSearch", "()Lcom/shiftphones/shifternetzwerk/repository/ServiceProviderRepositoryDbDirectSearch;", "getShifterIdCreationService", "()Lcom/shiftphones/shifternetzwerk/service/ShifterIdCreationService;", "getUsersProfileRepository", "()Lcom/shiftphones/shifternetzwerk/repository/UserprofileRepository;", "addService2Shifter", "Lcom/shiftphones/shifternetzwerk/service/ShortIdAnswer;", "id", "", "offeredservice", "Lcom/shiftphones/shifternetzwerk/domain/Offeredservice;", "convertDmObj2PersObj", "Lcom/shiftphones/shifternetzwerk/domain/Shifter;", "shifterDmObj", "Lcom/shiftphones/shifternetzwerk/hateoas/ShifterDataManipulationObject;", "create", "Lcom/shiftphones/shifternetzwerk/domain/ShortEntityObject;", "shifter", "deleteById", "", "deleteUserServices", "userProfileId", "", "fillShifterWithShifterId", "stdSaveLogic", "update", "shifternetzwerk"})
public class ShifterService {
    @NotNull
    private final ShifterRepository shifterRepository;
    @NotNull
    private final AddressRepository addressRepository;
    @NotNull
    private final UserprofileRepository usersProfileRepository;
    @NotNull
    private final OfferedserviceRepository offeredserviceRepository;
    @NotNull
    private final ServiceProviderRepositoryDbDirectSearch serviceProviderRepositoryDbDirectSearch;
    @NotNull
    private final ShifterIdCreationService shifterIdCreationService;
    private final Logger log;

    public ShifterService(@NotNull ShifterRepository shifterRepository, @NotNull AddressRepository addressRepository, @NotNull UserprofileRepository usersProfileRepository, @NotNull OfferedserviceRepository offeredserviceRepository, @NotNull ServiceProviderRepositoryDbDirectSearch serviceProviderRepositoryDbDirectSearch, @NotNull ShifterIdCreationService shifterIdCreationService) {
        Intrinsics.checkNotNullParameter((Object)shifterRepository, (String)"shifterRepository");
        Intrinsics.checkNotNullParameter((Object)addressRepository, (String)"addressRepository");
        Intrinsics.checkNotNullParameter((Object)usersProfileRepository, (String)"usersProfileRepository");
        Intrinsics.checkNotNullParameter((Object)offeredserviceRepository, (String)"offeredserviceRepository");
        Intrinsics.checkNotNullParameter((Object)serviceProviderRepositoryDbDirectSearch, (String)"serviceProviderRepositoryDbDirectSearch");
        Intrinsics.checkNotNullParameter((Object)shifterIdCreationService, (String)"shifterIdCreationService");
        this.shifterRepository = shifterRepository;
        this.addressRepository = addressRepository;
        this.usersProfileRepository = usersProfileRepository;
        this.offeredserviceRepository = offeredserviceRepository;
        this.serviceProviderRepositoryDbDirectSearch = serviceProviderRepositoryDbDirectSearch;
        this.shifterIdCreationService = shifterIdCreationService;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    public AddressRepository getAddressRepository() {
        return this.addressRepository;
    }

    @NotNull
    public UserprofileRepository getUsersProfileRepository() {
        return this.usersProfileRepository;
    }

    @NotNull
    public OfferedserviceRepository getOfferedserviceRepository() {
        return this.offeredserviceRepository;
    }

    @NotNull
    public ServiceProviderRepositoryDbDirectSearch getServiceProviderRepositoryDbDirectSearch() {
        return this.serviceProviderRepositoryDbDirectSearch;
    }

    @NotNull
    public ShifterIdCreationService getShifterIdCreationService() {
        return this.shifterIdCreationService;
    }

    @Transactional
    public void deleteUserServices(@NotNull String userProfileId) {
        Intrinsics.checkNotNullParameter((Object)userProfileId, (String)"userProfileId");
        this.log.info(Intrinsics.stringPlus((String)"Try to delete userprofile:", (Object)userProfileId));
        int result = this.getServiceProviderRepositoryDbDirectSearch().deleteServiceForOldShifter(userProfileId);
        this.log.info("delete userprofile:" + userProfileId + " result:" + result);
    }

    @Transactional
    @NotNull
    public ShortEntityObject create(@NotNull ShifterDataManipulationObject shifter) {
        Intrinsics.checkNotNullParameter((Object)shifter, (String)"shifter");
        Shifter result = this.stdSaveLogic(shifter);
        Long id = result.getId();
        this.log.info(Intrinsics.stringPlus((String)"Created new serviceProvider ", (Object)id));
        Long l = id;
        Intrinsics.checkNotNull((Object)l);
        return new ShortEntityObject(l.longValue());
    }

    @Transactional
    @NotNull
    public ShortEntityObject create(@NotNull Shifter shifter) {
        Intrinsics.checkNotNullParameter((Object)shifter, (String)"shifter");
        Shifter result = this.stdSaveLogic(shifter);
        Long id = result.getId();
        this.log.info(Intrinsics.stringPlus((String)"Created new serviceProvider ", (Object)id));
        Long l = id;
        Intrinsics.checkNotNull((Object)l);
        return new ShortEntityObject(l.longValue());
    }

    @Transactional
    public void update(@NotNull ShifterDataManipulationObject shifter) {
        Intrinsics.checkNotNullParameter((Object)shifter, (String)"shifter");
        Shifter result = this.stdSaveLogic(shifter);
        Long id = result.getId();
        this.log.info(Intrinsics.stringPlus((String)"updated serviceProvider ", (Object)id));
    }

    @Transactional
    public void update(@NotNull Shifter shifter) {
        Intrinsics.checkNotNullParameter((Object)shifter, (String)"shifter");
        this.getAddressRepository().removeAddressesByShifter(shifter);
        Shifter result = this.stdSaveLogic(shifter);
        Long id = result.getId();
        this.log.info(Intrinsics.stringPlus((String)"updated serviceProvider ", (Object)id));
    }

    /*
     * WARNING - void declaration
     */
    private final Shifter stdSaveLogic(ShifterDataManipulationObject shifterDmObj) {
        void $this$mapTo$iv$iv;
        Shifter shifter = this.convertDmObj2PersObj(shifterDmObj);
        Iterable $this$map$iv = shifterDmObj.getUsers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void upid;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Optional up = this.getUsersProfileRepository().findById((Object)upid);
            Userprofile userprofile = !up.isPresent() ? (Userprofile)this.getUsersProfileRepository().save((Object)new Userprofile((String)upid, null, 2, null)) : (Userprofile)up.get();
            collection.add(userprofile);
        }
        Set userObjects = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        this.fillShifterWithShifterId(shifter);
        Shifter result = (Shifter)this.shifterRepository.save((Object)shifter);
        Iterable $this$forEach$iv = userObjects;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Userprofile it = (Userprofile)element$iv;
            boolean bl = false;
            it.setShifter(shifter);
            this.getUsersProfileRepository().save((Object)it);
        }
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        return result;
    }

    private final void fillShifterWithShifterId(Shifter shifter) {
        String string = shifter.getShifterdisplayId();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            return;
        }
        shifter.setShifterdisplayId(this.getShifterIdCreationService().createNewShifterId());
    }

    private final Shifter convertDmObj2PersObj(ShifterDataManipulationObject shifterDmObj) {
        Long l = shifterDmObj.getId();
        if (l != null) {
            Long l2 = l;
            boolean bl = false;
            boolean bl2 = false;
            long it = ((Number)l2).longValue();
            boolean bl3 = false;
            Optional optShifter = this.shifterRepository.findById((Object)it);
            Object object = optShifter.get();
            Intrinsics.checkNotNullExpressionValue(object, (String)"optShifter.get()");
            Shifter shifter = (Shifter)object;
            object = shifter;
            boolean bl4 = false;
            boolean bl5 = false;
            Object $this$convertDmObj2PersObj_u24lambda_u2d4_u24lambda_u2d3 = object;
            boolean bl6 = false;
            $this$convertDmObj2PersObj_u24lambda_u2d4_u24lambda_u2d3.setDisables(shifterDmObj.getDisables());
            $this$convertDmObj2PersObj_u24lambda_u2d4_u24lambda_u2d3.setReactivationDate(shifterDmObj.getReactivationDate());
            $this$convertDmObj2PersObj_u24lambda_u2d4_u24lambda_u2d3.setBusiness(shifterDmObj.getBusiness());
            $this$convertDmObj2PersObj_u24lambda_u2d4_u24lambda_u2d3.setHomepage(shifterDmObj.getHomepage());
            $this$convertDmObj2PersObj_u24lambda_u2d4_u24lambda_u2d3.setCompanyName(shifterDmObj.getCompanyName());
            $this$convertDmObj2PersObj_u24lambda_u2d4_u24lambda_u2d3.setDisplayName(shifterDmObj.getDisplayName());
            $this$convertDmObj2PersObj_u24lambda_u2d4_u24lambda_u2d3.setDescription(shifterDmObj.getDescription());
            $this$convertDmObj2PersObj_u24lambda_u2d4_u24lambda_u2d3.setInternalDescription(shifterDmObj.getInternalDescription());
            $this$convertDmObj2PersObj_u24lambda_u2d4_u24lambda_u2d3.setImage(shifterDmObj.getImage());
            $this$convertDmObj2PersObj_u24lambda_u2d4_u24lambda_u2d3.setImageContentType(shifterDmObj.getImageContentType());
            $this$convertDmObj2PersObj_u24lambda_u2d4_u24lambda_u2d3.setMessangerIOR(shifterDmObj.getMessangerIOR());
            return shifter;
        }
        return new Shifter(null, shifterDmObj.getDisables(), shifterDmObj.getReactivationDate(), shifterDmObj.getBusiness(), shifterDmObj.getHomepage(), shifterDmObj.getCompanyName(), shifterDmObj.getDisplayName(), shifterDmObj.getDescription(), shifterDmObj.getInternalDescription(), shifterDmObj.getImage(), shifterDmObj.getImageContentType(), null, null, null, null, shifterDmObj.getMessangerIOR(), null, 96257, null);
    }

    private final Shifter stdSaveLogic(Shifter shifter) {
        Address it;
        boolean bl;
        Object object;
        Userprofile it2;
        Collection<Address> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = shifter.getAdresses();
        Object object2 = shifter;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Address address = (Address)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            Object mappedProfile = null;
            mappedProfile = it2;
            object = it2.getId();
            if (object != null) {
                Long l = object;
                bl = false;
                boolean bl3 = false;
                long upid = ((Number)l).longValue();
                boolean bl4 = false;
                Optional up = this.getAddressRepository().findById((Object)upid);
                ((Address)up.get()).setShifter(shifter);
                Object t = up.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"up.get()");
                mappedProfile = t;
            }
            Address address2 = mappedProfile;
            collection.add(address2);
        }
        collection = (List)destination$iv$iv;
        object2.setAdresses(CollectionsKt.toMutableSet((Iterable)collection));
        $this$map$iv = shifter.getUsers();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object3;
            it2 = (Userprofile)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl5 = false;
            String string = it2.getId();
            if (string == null) {
                object3 = null;
            } else {
                object = string;
                boolean bl6 = false;
                bl = false;
                Object upid = object;
                boolean bl7 = false;
                Optional up = this.getUsersProfileRepository().findById(upid);
                if (!up.isPresent()) {
                    this.getUsersProfileRepository().save((Object)new Userprofile((String)upid, null, 2, null));
                }
                object3 = object;
            }
            collection = object3;
            object2.add(collection);
        }
        CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        Shifter result = (Shifter)this.shifterRepository.save((Object)shifter);
        Iterable $this$forEach$iv = shifter.getAdresses();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Address)element$iv;
            boolean bl8 = false;
            this.getAddressRepository().save((Object)it);
        }
        $this$forEach$iv = shifter.getUsers();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Userprofile)element$iv;
            boolean bl9 = false;
            it.setShifter(shifter);
            this.getUsersProfileRepository().save((Object)it);
        }
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        return result;
    }

    @Transactional
    @NotNull
    public ShortIdAnswer addService2Shifter(long id, @NotNull Offeredservice offeredservice) {
        Intrinsics.checkNotNullParameter((Object)offeredservice, (String)"offeredservice");
        Object t = this.shifterRepository.findById((Object)id).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"shifterRepository.findById(id).get()");
        Shifter shifter = (Shifter)t;
        offeredservice.setShifter(shifter);
        Long l = ((Offeredservice)this.getOfferedserviceRepository().save((Object)offeredservice)).getId();
        Intrinsics.checkNotNull((Object)l);
        return new ShortIdAnswer(l.longValue(), null, 2, null);
    }

    public void deleteById(long id) {
        Shifter shifter = (Shifter)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.shifterRepository), (Object)id);
        if (shifter != null) {
            Shifter shifter2 = shifter;
            boolean bl = false;
            boolean bl2 = false;
            Shifter it = shifter2;
            boolean bl3 = false;
            it.setDeleteTimepoint(ZonedDateTime.now());
            it.setDisplayName("deleted user");
            this.shifterRepository.save((Object)it);
            this.log.info(Intrinsics.stringPlus((String)"Shifter deleted ", (Object)it.getId()));
        }
    }
}

