/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.service;

import com.shiftphones.shifternetzwerk.domain.Authority;
import com.shiftphones.shifternetzwerk.domain.User;
import com.shiftphones.shifternetzwerk.repository.AuthorityRepository;
import com.shiftphones.shifternetzwerk.repository.UserRepository;
import com.shiftphones.shifternetzwerk.security.SecurityUtils;
import com.shiftphones.shifternetzwerk.service.UserService;
import com.shiftphones.shifternetzwerk.service.dto.UserDTO;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Exception performing whole class analysis ignored.
 */
@Service
@Transactional
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\b\b\u0017\u0018\u0000 '2\u00020\u0001:\u0001'B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0017J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001c2\u0006\u0010\u001d\u001a\u00020\u0017H\u0017J$\u0010\u001e\u001a\u00020\u000f2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00010 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J:\u0010!\u001a\u00020\r2\b\u0010\"\u001a\u0004\u0018\u00010\u00172\b\u0010#\u001a\u0004\u0018\u00010\u00172\b\u0010$\u001a\u0004\u0018\u00010\u00172\b\u0010%\u001a\u0004\u0018\u00010\u00172\b\u0010&\u001a\u0004\u0018\u00010\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/shiftphones/shifternetzwerk/service/UserService;", "", "userRepository", "Lcom/shiftphones/shifternetzwerk/repository/UserRepository;", "authorityRepository", "Lcom/shiftphones/shifternetzwerk/repository/AuthorityRepository;", "cacheManager", "Lorg/springframework/cache/CacheManager;", "(Lcom/shiftphones/shifternetzwerk/repository/UserRepository;Lcom/shiftphones/shifternetzwerk/repository/AuthorityRepository;Lorg/springframework/cache/CacheManager;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "clearUserCaches", "", "user", "Lcom/shiftphones/shifternetzwerk/domain/User;", "getAllManagedUsers", "Lorg/springframework/data/domain/Page;", "Lcom/shiftphones/shifternetzwerk/service/dto/UserDTO;", "pageable", "Lorg/springframework/data/domain/Pageable;", "getAuthorities", "", "", "getUserFromAuthentication", "authToken", "Lorg/springframework/security/authentication/AbstractAuthenticationToken;", "getUserWithAuthoritiesByLogin", "Ljava/util/Optional;", "login", "syncUserWithIdP", "details", "", "updateUser", "firstName", "lastName", "email", "langKey", "imageUrl", "Companion", "shifternetzwerk"})
public class UserService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserRepository userRepository;
    @NotNull
    private final AuthorityRepository authorityRepository;
    @NotNull
    private final CacheManager cacheManager;
    private final Logger log;

    public UserService(@NotNull UserRepository userRepository, @NotNull AuthorityRepository authorityRepository, @NotNull CacheManager cacheManager) {
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        Intrinsics.checkNotNullParameter((Object)authorityRepository, (String)"authorityRepository");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        this.userRepository = userRepository;
        this.authorityRepository = authorityRepository;
        this.cacheManager = cacheManager;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public void updateUser(@Nullable String firstName, @Nullable String lastName, @Nullable String email, @Nullable String langKey, @Nullable String imageUrl) {
        SecurityUtils.getCurrentUserLogin().flatMap(arg_0 -> ((UserRepository)this.userRepository).findOneByLogin(arg_0)).ifPresent(arg_0 -> UserService.updateUser$lambda-0(firstName, lastName, email, langKey, imageUrl, this, arg_0));
    }

    @Transactional(readOnly=true)
    @NotNull
    public Page<UserDTO> getAllManagedUsers(@NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.userRepository.findAllByLoginNot(pageable, "anonymoususer").map(UserService::getAllManagedUsers$lambda-1);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"userRepository.findAllBy\u2026USER).map { UserDTO(it) }");
        return page;
    }

    @Transactional(readOnly=true)
    @NotNull
    public Optional<User> getUserWithAuthoritiesByLogin(@NotNull String login) {
        Intrinsics.checkNotNullParameter((Object)login, (String)"login");
        return this.userRepository.findOneWithAuthoritiesByLogin(login);
    }

    @Transactional(readOnly=true)
    @NotNull
    public List<String> getAuthorities() {
        List list = this.authorityRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"authorityRepository.findAll()");
        boolean bl = false;
        return (List)SequencesKt.filterNotNullTo((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)getAuthorities.1.INSTANCE)), (Collection)new ArrayList());
    }

    /*
     * WARNING - void declaration
     */
    private final User syncUserWithIdP(Map<String, ? extends Object> details, User user) {
        void destination$iv;
        Iterator $this$mapTo$iv;
        List dbAuthorities = this.getAuthorities();
        Sequence sequence = CollectionsKt.asSequence((Iterable)user.getAuthorities());
        boolean bl = false;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        Object object = $this$mapTo$iv.iterator();
        while (object.hasNext()) {
            void p0;
            Object item$iv = object.next();
            Authority authority = (Authority)item$iv;
            void var12_14 = destination$iv;
            boolean bl2 = false;
            String string = p0.getName();
            var12_14.add(string);
        }
        List userAuthorities = (List)destination$iv;
        for (String authority : userAuthorities) {
            if (CollectionsKt.contains((Iterable)dbAuthorities, (Object)authority)) continue;
            this.log.debug("Saving authority '" + authority + "' in local database");
            Authority authorityToSave = new Authority(authority);
            this.authorityRepository.save((Object)authorityToSave);
        }
        String string = user.getLogin();
        Intrinsics.checkNotNull((Object)string);
        Optional existingUser = this.userRepository.findOneByLogin(string);
        if (existingUser.isPresent()) {
            if (details.get("updated_at") != null) {
                Instant dbModifiedDate = ((User)existingUser.get()).getLastModifiedDate();
                object = details.get("updated_at");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.time.Instant");
                }
                Instant idpModifiedDate = (Instant)object;
                if (idpModifiedDate.isAfter(dbModifiedDate)) {
                    this.log.debug("Updating user '" + user.getLogin() + "' in local database");
                    this.updateUser(user.getFirstName(), user.getLastName(), user.getEmail(), user.getLangKey(), user.getImageUrl());
                }
            } else {
                this.log.debug("Updating user '" + user.getLogin() + "' in local database");
                this.updateUser(user.getFirstName(), user.getLastName(), user.getEmail(), user.getLangKey(), user.getImageUrl());
            }
        } else {
            this.log.debug("Saving user '" + user.getLogin() + "' in local database");
            this.userRepository.save((Object)user);
            this.clearUserCaches(user);
        }
        return user;
    }

    @Transactional
    @NotNull
    public UserDTO getUserFromAuthentication(@NotNull AbstractAuthenticationToken authToken) {
        Map map;
        Map map2;
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        AbstractAuthenticationToken abstractAuthenticationToken = authToken;
        if (abstractAuthenticationToken instanceof OAuth2AuthenticationToken) {
            map2 = ((OAuth2AuthenticationToken)authToken).getPrincipal().getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"authToken.principal.attributes");
            map = map2;
        } else if (abstractAuthenticationToken instanceof JwtAuthenticationToken) {
            map2 = ((JwtAuthenticationToken)authToken).getTokenAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"authToken.tokenAttributes");
            map = map2;
        } else {
            throw new IllegalArgumentException("AuthenticationToken is not OAuth2 or JWT!");
        }
        Map attributes = map;
        User user = Companion.access$getUser((Companion)Companion, (Map)attributes);
        this.log.info("User " + user.getLogin() + " has the following auths " + user.getAuthorities());
        return new UserDTO(this.syncUserWithIdP(attributes, user));
    }

    private final void clearUserCaches(User user) {
        Cache cache = this.cacheManager.getCache("usersByLogin");
        if (cache != null) {
            String string = user.getLogin();
            Intrinsics.checkNotNull((Object)string);
            cache.evict((Object)string);
        }
        if (user.getEmail() != null && (cache = this.cacheManager.getCache("usersByEmail")) != null) {
            cache.evict((Object)user.getEmail());
        }
    }

    private static final void updateUser$lambda-0(String $firstName, String $lastName, String $email, String $langKey, String $imageUrl, UserService this$0, User it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setFirstName($firstName);
        it.setLastName($lastName);
        String string2 = $email;
        if (string2 == null) {
            string = null;
        } else {
            String string3 = string2;
            boolean bl = false;
            String string4 = string3.toLowerCase();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        }
        it.setEmail(string);
        it.setLangKey($langKey);
        it.setImageUrl($imageUrl);
        this$0.clearUserCaches(it);
        this$0.log.debug(Intrinsics.stringPlus((String)"Changed Information for User: ", (Object)it));
    }

    private static final UserDTO getAllManagedUsers$lambda-1(User it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return new UserDTO(it);
    }
}

