/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.Addresstag;
import com.shiftphones.shifternetzwerk.repository.AddresstagRepository;
import com.shiftphones.shifternetzwerk.web.rest.AddresstagResource;
import com.shiftphones.shifternetzwerk.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Transactional
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\r\b\u0001\u0010\u0011\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0012H\u0017J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\u001f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u000f\b\u0001\u0010\u0011\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u0012H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/AddresstagResource;", "", "addresstagRepository", "Lcom/shiftphones/shifternetzwerk/repository/AddresstagRepository;", "(Lcom/shiftphones/shifternetzwerk/repository/AddresstagRepository;)V", "allAddresstags", "", "Lcom/shiftphones/shifternetzwerk/domain/Addresstag;", "getAllAddresstags", "()Ljava/util/List;", "applicationName", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createAddresstag", "Lorg/springframework/http/ResponseEntity;", "addresstag", "Ljavax/validation/Valid;", "deleteAddresstag", "Ljava/lang/Void;", "id", "", "getAddresstag", "updateAddresstag", "Companion", "shifternetzwerk"})
public class AddresstagResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AddresstagRepository addresstagRepository;
    private final Logger log;
    @Value(value="${jhipster.clientApp.name}")
    @Nullable
    private final String applicationName;
    @NotNull
    private static final String ENTITY_NAME = "addresstag";

    public AddresstagResource(@NotNull AddresstagRepository addresstagRepository) {
        Intrinsics.checkNotNullParameter((Object)addresstagRepository, (String)"addresstagRepository");
        this.addresstagRepository = addresstagRepository;
        this.log = LoggerFactory.getLogger(AddresstagResource.class);
    }

    @PostMapping(value={"/addresstags"})
    @NotNull
    public ResponseEntity<Addresstag> createAddresstag(@RequestBody @NotNull Addresstag addresstag) throws URISyntaxException {
        Intrinsics.checkNotNullParameter((Object)addresstag, (String)ENTITY_NAME);
        this.log.debug("REST request to save Addresstag : {}", (Object)addresstag);
        if (addresstag.getId() != null) {
            throw new BadRequestAlertException("A new addresstag cannot already have an ID", ENTITY_NAME, "idexists");
        }
        Addresstag result = (Addresstag)this.addresstagRepository.save((Object)addresstag);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI(Intrinsics.stringPlus((String)"/api/addresstags/", (Object)result.getId()))).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)String.valueOf(result.getId())))).body((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"created(URI(\"/api/addres\u2026            .body(result)");
        return responseEntity;
    }

    @PutMapping(value={"/addresstags"})
    @NotNull
    public ResponseEntity<Addresstag> updateAddresstag(@RequestBody @Nullable Addresstag addresstag) throws URISyntaxException {
        this.log.debug("REST request to update Addresstag : {}", (Object)addresstag);
        Addresstag addresstag2 = addresstag;
        Intrinsics.checkNotNull((Object)addresstag2);
        if (addresstag2.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        Addresstag result = (Addresstag)this.addresstagRepository.save((Object)addresstag);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)String.valueOf(addresstag.getId())))).body((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok()\n            .header\u2026            .body(result)");
        return responseEntity;
    }

    @GetMapping(value={"/addresstags"})
    @NotNull
    public List<Addresstag> getAllAddresstags() {
        this.log.debug("REST request to get all Addresstags");
        List list = this.addresstagRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"addresstagRepository.findAll()");
        return list;
    }

    @GetMapping(value={"/addresstags/{id}"})
    @NotNull
    public ResponseEntity<Addresstag> getAddresstag(@PathVariable long id) {
        this.log.debug("REST request to get Addresstag : {}", (Object)id);
        Optional addresstag = this.addresstagRepository.findById((Object)id);
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound((Optional)addresstag);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"wrapOrNotFound(addresstag)");
        return responseEntity;
    }

    @DeleteMapping(value={"/addresstags/{id}"})
    @NotNull
    public ResponseEntity<Void> deleteAddresstag(@PathVariable long id) {
        this.log.debug("REST request to delete Addresstag : {}", (Object)id);
        this.addresstagRepository.deleteById((Object)id);
        ResponseEntity responseEntity = ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)String.valueOf(id))).build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"noContent().headers(Head\u2026, id.toString())).build()");
        return responseEntity;
    }
}

