/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.Alarmsignal;
import com.shiftphones.shifternetzwerk.repository.AlarmsignalRepository;
import com.shiftphones.shifternetzwerk.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\r\u001a\u00020\fH\u0017J\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0017J\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\r\u001a\u00020\fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/AlarmsignalResource;", "", "alarmsignalRepository", "Lcom/shiftphones/shifternetzwerk/repository/AlarmsignalRepository;", "(Lcom/shiftphones/shifternetzwerk/repository/AlarmsignalRepository;)V", "applicationName", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createAlarmsignal", "Lorg/springframework/http/ResponseEntity;", "Lcom/shiftphones/shifternetzwerk/domain/Alarmsignal;", "alarmsignal", "deleteAlarmsignal", "Ljava/lang/Void;", "id", "", "getAlarmsignal", "getAllAlarmsignals", "", "updateAlarmsignal", "shifternetzwerk"})
public class AlarmsignalResource {
    @NotNull
    private final AlarmsignalRepository alarmsignalRepository;
    private final Logger log;
    @Value(value="${jhipster.clientApp.name}")
    @Nullable
    private String applicationName;

    public AlarmsignalResource(@NotNull AlarmsignalRepository alarmsignalRepository) {
        Intrinsics.checkNotNullParameter((Object)alarmsignalRepository, (String)"alarmsignalRepository");
        this.alarmsignalRepository = alarmsignalRepository;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @PostMapping(value={"/alarmsignals"})
    @NotNull
    public ResponseEntity<Alarmsignal> createAlarmsignal(@Valid @RequestBody @NotNull Alarmsignal alarmsignal) {
        Intrinsics.checkNotNullParameter((Object)alarmsignal, (String)"alarmsignal");
        this.log.debug("REST request to save Alarmsignal : {}", (Object)alarmsignal);
        if (alarmsignal.getId() != null) {
            throw new BadRequestAlertException("A new alarmsignal cannot already have an ID", "alarmsignal", "idexists");
        }
        Alarmsignal result = (Alarmsignal)this.alarmsignalRepository.save((Object)alarmsignal);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI(Intrinsics.stringPlus((String)"/api/alarmsignals/", (Object)result.getId()))).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)"alarmsignal", (String)String.valueOf(result.getId())))).body((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"created(URI(\"/api/alarms\u2026            .body(result)");
        return responseEntity;
    }

    @PutMapping(value={"/alarmsignals"})
    @NotNull
    public ResponseEntity<Alarmsignal> updateAlarmsignal(@Valid @RequestBody @NotNull Alarmsignal alarmsignal) {
        Intrinsics.checkNotNullParameter((Object)alarmsignal, (String)"alarmsignal");
        this.log.debug("REST request to update Alarmsignal : {}", (Object)alarmsignal);
        if (alarmsignal.getId() == null) {
            throw new BadRequestAlertException("Invalid id", "alarmsignal", "idnull");
        }
        Alarmsignal result = (Alarmsignal)this.alarmsignalRepository.save((Object)alarmsignal);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)"alarmsignal", (String)String.valueOf(alarmsignal.getId())))).body((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok()\n            .header\u2026            .body(result)");
        return responseEntity;
    }

    @GetMapping(value={"/alarmsignals"})
    @NotNull
    public List<Alarmsignal> getAllAlarmsignals() {
        this.log.debug("REST request to get all Alarmsignals");
        List list = this.alarmsignalRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"alarmsignalRepository.findAll()");
        return list;
    }

    @GetMapping(value={"/alarmsignals/{id}"})
    @NotNull
    public ResponseEntity<Alarmsignal> getAlarmsignal(@PathVariable long id) {
        this.log.debug("REST request to get Alarmsignal : {}", (Object)id);
        Optional alarmsignal = this.alarmsignalRepository.findById((Object)id);
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound((Optional)alarmsignal);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"wrapOrNotFound(alarmsignal)");
        return responseEntity;
    }

    @DeleteMapping(value={"/alarmsignals/{id}"})
    @NotNull
    public ResponseEntity<Void> deleteAlarmsignal(@PathVariable long id) {
        this.log.debug("REST request to delete Alarmsignal : {}", (Object)id);
        this.alarmsignalRepository.deleteById((Object)id);
        ResponseEntity responseEntity = ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)"alarmsignal", (String)String.valueOf(id))).build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"noContent()\n            \u2026, id.toString())).build()");
        return responseEntity;
    }
}

