/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.Histownedproduct;
import com.shiftphones.shifternetzwerk.domain.HistownedproductRestData;
import com.shiftphones.shifternetzwerk.domain.Productinstance;
import com.shiftphones.shifternetzwerk.domain.Shifter;
import com.shiftphones.shifternetzwerk.hateoas.HistownedproductHateOasResource;
import com.shiftphones.shifternetzwerk.repository.HistownedproductRepository;
import com.shiftphones.shifternetzwerk.repository.ProductinstanceRepository;
import com.shiftphones.shifternetzwerk.repository.ShifterRepository;
import com.shiftphones.shifternetzwerk.web.rest.Histownedproducts;
import com.shiftphones.shifternetzwerk.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\b\u0010\u0016\u001a\u00020\u0017H\u0017J\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000f2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017R\u0014\u0010\t\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/HistownedproductResource;", "", "histownedproductRepository", "Lcom/shiftphones/shifternetzwerk/repository/HistownedproductRepository;", "shifterRepository", "Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;", "productInstanceRepository", "Lcom/shiftphones/shifternetzwerk/repository/ProductinstanceRepository;", "(Lcom/shiftphones/shifternetzwerk/repository/HistownedproductRepository;Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;Lcom/shiftphones/shifternetzwerk/repository/ProductinstanceRepository;)V", "applicationName", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createHistownedproduct", "Lorg/springframework/http/ResponseEntity;", "histownedproduct", "Lcom/shiftphones/shifternetzwerk/domain/HistownedproductRestData;", "deleteHistownedproduct", "Ljava/lang/Void;", "id", "", "getAllHistownedproducts", "Lcom/shiftphones/shifternetzwerk/web/rest/Histownedproducts;", "getHistownedproduct", "Lcom/shiftphones/shifternetzwerk/hateoas/HistownedproductHateOasResource;", "toBo", "Lcom/shiftphones/shifternetzwerk/domain/Histownedproduct;", "horest", "updateHistownedproduct", "shifternetzwerk"})
public class HistownedproductResource {
    @NotNull
    private final HistownedproductRepository histownedproductRepository;
    @NotNull
    private final ShifterRepository shifterRepository;
    @NotNull
    private final ProductinstanceRepository productInstanceRepository;
    private final Logger log;
    @Value(value="${jhipster.clientApp.name}")
    @Nullable
    private String applicationName;

    public HistownedproductResource(@NotNull HistownedproductRepository histownedproductRepository, @NotNull ShifterRepository shifterRepository, @NotNull ProductinstanceRepository productInstanceRepository) {
        Intrinsics.checkNotNullParameter((Object)histownedproductRepository, (String)"histownedproductRepository");
        Intrinsics.checkNotNullParameter((Object)shifterRepository, (String)"shifterRepository");
        Intrinsics.checkNotNullParameter((Object)productInstanceRepository, (String)"productInstanceRepository");
        this.histownedproductRepository = histownedproductRepository;
        this.shifterRepository = shifterRepository;
        this.productInstanceRepository = productInstanceRepository;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @PostMapping(value={"/histownedproducts"})
    @Transactional
    @NotNull
    public ResponseEntity<Object> createHistownedproduct(@RequestBody @NotNull HistownedproductRestData histownedproduct) {
        Intrinsics.checkNotNullParameter((Object)histownedproduct, (String)"histownedproduct");
        this.log.debug("REST request to save Histownedproduct : {}", (Object)histownedproduct);
        if (histownedproduct.getId() != null) {
            throw new BadRequestAlertException("A new histownedproduct cannot already have an ID", "histownedproduct", "idexists");
        }
        Histownedproduct result = (Histownedproduct)this.histownedproductRepository.save((Object)this.toBo(histownedproduct));
        Long id = result.getId();
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI(Intrinsics.stringPlus((String)"/api/histownedproducts/", (Object)id))).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)"histownedproduct", (String)String.valueOf(id)))).body((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"created(URI(\"/api/histow\u2026            .body(result)");
        return responseEntity;
    }

    private final Histownedproduct toBo(HistownedproductRestData horest) {
        Histownedproduct hop = new Histownedproduct(horest.getId(), ZonedDateTime.now(), null, (Productinstance)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.productInstanceRepository), (Object)horest.getProductinstanceId()), (Shifter)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.shifterRepository), (Object)horest.getShifterId()));
        return hop;
    }

    @PutMapping(value={"/histownedproducts"})
    @NotNull
    public ResponseEntity<Histownedproduct> updateHistownedproduct(@RequestBody @NotNull HistownedproductRestData histownedproduct) {
        Intrinsics.checkNotNullParameter((Object)histownedproduct, (String)"histownedproduct");
        this.log.debug("REST request to update Histownedproduct : {}", (Object)histownedproduct);
        if (histownedproduct.getId() == null) {
            throw new BadRequestAlertException("Invalid id", "histownedproduct", "idnull");
        }
        Histownedproduct result = (Histownedproduct)this.histownedproductRepository.save((Object)this.toBo(histownedproduct));
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)"histownedproduct", (String)histownedproduct.getId().toString()))).body((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok()\n            .header\u2026            .body(result)");
        return responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/histownedproducts"})
    @NotNull
    public Histownedproducts getAllHistownedproducts() {
        void $this$mapTo$iv$iv;
        this.log.debug("REST request to get all Histownedproducts");
        List list = this.histownedproductRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"histownedproductRepository.findAll()");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Histownedproduct histownedproduct = (Histownedproduct)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            HistownedproductHateOasResource histownedproductHateOasResource = new HistownedproductHateOasResource((Histownedproduct)it);
            collection.add(histownedproductHateOasResource);
        }
        List products = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        return new Histownedproducts(products);
    }

    @GetMapping(value={"/histownedproducts/{id}"})
    @NotNull
    public ResponseEntity<HistownedproductHateOasResource> getHistownedproduct(@PathVariable long id) {
        this.log.debug("REST request to get Histownedproduct : {}", (Object)id);
        Optional histownedproduct = this.histownedproductRepository.findById((Object)id);
        if (histownedproduct.isPresent()) {
            Object t = histownedproduct.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"histownedproduct.get()");
            ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.of(new HistownedproductHateOasResource((Histownedproduct)t)));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"wrapOrNotFound(Optional.\u2026histownedproduct.get())))");
            return responseEntity;
        }
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.empty());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"wrapOrNotFound(Optional.empty())");
        return responseEntity;
    }

    @DeleteMapping(value={"/histownedproducts/{id}"})
    @NotNull
    public ResponseEntity<Void> deleteHistownedproduct(@PathVariable long id) {
        this.log.debug("REST request to delete Histownedproduct : {}", (Object)id);
        this.histownedproductRepository.deleteById((Object)id);
        ResponseEntity responseEntity = ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)"histownedproduct", (String)String.valueOf(id))).build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"noContent()\n            \u2026, id.toString())).build()");
        return responseEntity;
    }
}

