/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\rH\u0017R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/LogoutResource;", "", "registrations", "Lorg/springframework/security/oauth2/client/registration/ClientRegistrationRepository;", "(Lorg/springframework/security/oauth2/client/registration/ClientRegistrationRepository;)V", "registration", "Lorg/springframework/security/oauth2/client/registration/ClientRegistration;", "kotlin.jvm.PlatformType", "logout", "Lorg/springframework/http/ResponseEntity;", "request", "Ljavax/servlet/http/HttpServletRequest;", "idToken", "Lorg/springframework/security/oauth2/core/oidc/OidcIdToken;", "shifternetzwerk"})
public class LogoutResource {
    private final ClientRegistration registration;

    public LogoutResource(@NotNull ClientRegistrationRepository registrations) {
        Intrinsics.checkNotNullParameter((Object)registrations, (String)"registrations");
        this.registration = registrations.findByRegistrationId("oidc");
    }

    @PostMapping(value={"/api/logout"})
    @NotNull
    public ResponseEntity<?> logout(@NotNull HttpServletRequest request, @AuthenticationPrincipal(expression="idToken") @Nullable OidcIdToken idToken) {
        Map map;
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ClientRegistration clientRegistration = this.registration;
        String logoutUrl = String.valueOf(clientRegistration == null ? null : ((responseEntity = clientRegistration.getProviderDetails()) == null ? null : ((map = responseEntity.getConfigurationMetadata()) == null ? null : map.get("end_session_endpoint"))));
        responseEntity = new Pair[2];
        responseEntity[0] = TuplesKt.to((Object)"logoutUrl", (Object)logoutUrl);
        map = idToken;
        responseEntity[1] = TuplesKt.to((Object)"idToken", (Object)(map == null ? null : map.getTokenValue()));
        Map logoutDetails = MapsKt.mutableMapOf((Pair[])responseEntity);
        request.getSession().invalidate();
        responseEntity = ResponseEntity.ok().body((Object)logoutDetails);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok().body(logoutDetails)");
        return responseEntity;
    }
}

