/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.MailTo;
import com.shiftphones.shifternetzwerk.repository.MailToRepository;
import com.shiftphones.shifternetzwerk.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\r\u001a\u00020\fH\u0017J\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0017J\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\r\u001a\u00020\fH\u0017R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/MailToResource;", "", "mailToRepository", "Lcom/shiftphones/shifternetzwerk/repository/MailToRepository;", "(Lcom/shiftphones/shifternetzwerk/repository/MailToRepository;)V", "applicationName", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createMailTo", "Lorg/springframework/http/ResponseEntity;", "Lcom/shiftphones/shifternetzwerk/domain/MailTo;", "mailTo", "deleteMailTo", "Ljava/lang/Void;", "id", "", "getAllMailTos", "", "getMailTo", "updateMailTo", "shifternetzwerk"})
public class MailToResource {
    @NotNull
    private final MailToRepository mailToRepository;
    private final Logger log;
    @Value(value="${jhipster.clientApp.name}")
    @Nullable
    private String applicationName;

    public MailToResource(@NotNull MailToRepository mailToRepository) {
        Intrinsics.checkNotNullParameter((Object)mailToRepository, (String)"mailToRepository");
        this.mailToRepository = mailToRepository;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @PostMapping(value={"/mail-tos"})
    @NotNull
    public ResponseEntity<MailTo> createMailTo(@RequestBody @NotNull MailTo mailTo) {
        Intrinsics.checkNotNullParameter((Object)mailTo, (String)"mailTo");
        this.log.debug("REST request to save MailTo : {}", (Object)mailTo);
        if (mailTo.getId() != null) {
            throw new BadRequestAlertException("A new mailTo cannot already have an ID", "mailTo", "idexists");
        }
        MailTo result = (MailTo)this.mailToRepository.save((Object)mailTo);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI(Intrinsics.stringPlus((String)"/api/mail-tos/", (Object)result.getId()))).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)"mailTo", (String)String.valueOf(result.getId())))).body((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"created(URI(\"/api/mail-t\u2026            .body(result)");
        return responseEntity;
    }

    @PutMapping(value={"/mail-tos"})
    @NotNull
    public ResponseEntity<MailTo> updateMailTo(@RequestBody @NotNull MailTo mailTo) {
        Intrinsics.checkNotNullParameter((Object)mailTo, (String)"mailTo");
        this.log.debug("REST request to update MailTo : {}", (Object)mailTo);
        if (mailTo.getId() == null) {
            throw new BadRequestAlertException("Invalid id", "mailTo", "idnull");
        }
        MailTo result = (MailTo)this.mailToRepository.save((Object)mailTo);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)"mailTo", (String)String.valueOf(mailTo.getId())))).body((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok()\n            .header\u2026            .body(result)");
        return responseEntity;
    }

    @GetMapping(value={"/mail-tos"})
    @NotNull
    public List<MailTo> getAllMailTos() {
        this.log.debug("REST request to get all MailTos");
        List list = this.mailToRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mailToRepository.findAll()");
        return list;
    }

    @GetMapping(value={"/mail-tos/{id}"})
    @NotNull
    public ResponseEntity<MailTo> getMailTo(@PathVariable long id) {
        this.log.debug("REST request to get MailTo : {}", (Object)id);
        Optional mailTo = this.mailToRepository.findById((Object)id);
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound((Optional)mailTo);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"wrapOrNotFound(mailTo)");
        return responseEntity;
    }

    @DeleteMapping(value={"/mail-tos/{id}"})
    @NotNull
    public ResponseEntity<Void> deleteMailTo(@PathVariable long id) {
        this.log.debug("REST request to delete MailTo : {}", (Object)id);
        this.mailToRepository.deleteById((Object)id);
        ResponseEntity responseEntity = ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)"mailTo", (String)String.valueOf(id))).build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"noContent()\n            \u2026, id.toString())).build()");
        return responseEntity;
    }
}

