/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.OfferedserviceCreationRequest;
import com.shiftphones.shifternetzwerk.domain.OfferedserviceRequest;
import com.shiftphones.shifternetzwerk.domain.OfferedserviceRequestGui;
import com.shiftphones.shifternetzwerk.domain.Product;
import com.shiftphones.shifternetzwerk.domain.Userprofile;
import com.shiftphones.shifternetzwerk.domain.enumeration.ServiceState;
import com.shiftphones.shifternetzwerk.domain.enumeration.ShifterRolesEnum;
import com.shiftphones.shifternetzwerk.hateoas.OfferedServiceRequestOasResource;
import com.shiftphones.shifternetzwerk.repository.OfferedserviceRequestRepository;
import com.shiftphones.shifternetzwerk.repository.ServiceProviderRepositoryDbDirectSearch;
import com.shiftphones.shifternetzwerk.security.oauth2.Attributes;
import com.shiftphones.shifternetzwerk.security.oauth2.KeyCloakUserData;
import com.shiftphones.shifternetzwerk.service.KeyCloakService;
import com.shiftphones.shifternetzwerk.service.OfferedServiceService;
import com.shiftphones.shifternetzwerk.web.rest.OfferedserviceRequestResource;
import com.shiftphones.shifternetzwerk.web.rest.ResourceHelperService;
import com.shiftphones.shifternetzwerk.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.validation.Valid;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J\u001a\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u001eH\u0002J$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 2\b\b\u0001\u0010!\u001a\u00020\u000e2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u000eH\u0017J\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u000eH\u0017J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0017J\u0018\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J@\u0010&\u001a\u0004\u0018\u00010\u001e2\u0006\u0010'\u001a\u00020$2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020*0)2\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0 0)H\u0002J$\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\n\b\u0003\u0010-\u001a\u0004\u0018\u00010\u000eH\u0017J\u0018\u0010.\u001a\b\u0012\u0004\u0012\u00020$0\u00132\b\b\u0001\u0010\u0015\u001a\u00020$H\u0017J\"\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u00100\u001a\u00020\u001cH\u0017R\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/OfferedserviceRequestResource;", "", "service", "Lcom/shiftphones/shifternetzwerk/service/OfferedServiceService;", "offeredserviceRequestRepository", "Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRequestRepository;", "resourceHelperService", "Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;", "keyCloakService", "Lcom/shiftphones/shifternetzwerk/service/KeyCloakService;", "serviceProviderRepositoryDbDirectSearch", "Lcom/shiftphones/shifternetzwerk/repository/ServiceProviderRepositoryDbDirectSearch;", "(Lcom/shiftphones/shifternetzwerk/service/OfferedServiceService;Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRequestRepository;Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;Lcom/shiftphones/shifternetzwerk/service/KeyCloakService;Lcom/shiftphones/shifternetzwerk/repository/ServiceProviderRepositoryDbDirectSearch;)V", "applicationName", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createOfferedserviceRequest", "Lorg/springframework/http/ResponseEntity;", "Lcom/shiftphones/shifternetzwerk/hateoas/OfferedServiceRequestOasResource;", "offeredserviceRequest", "Lcom/shiftphones/shifternetzwerk/domain/OfferedserviceCreationRequest;", "deleteOfferedserviceRequest", "Ljava/lang/Void;", "id", "", "filterBySearchName", "", "searchName", "Lcom/shiftphones/shifternetzwerk/domain/OfferedserviceRequestGui;", "getAllOfferedserviceRequestGuis", "", "states", "getAllOfferedserviceRequests", "", "Lcom/shiftphones/shifternetzwerk/domain/OfferedserviceRequest;", "getOfferedserviceRequest", "mapOrr", "it", "usrEntries", "", "Lcom/shiftphones/shifternetzwerk/security/oauth2/KeyCloakUserData;", "shifter2Mei", "reject", "rejectMessage", "updateOfferedserviceRequest", "updateState", "accept", "shifternetzwerk"})
public class OfferedserviceRequestResource {
    @NotNull
    private final OfferedServiceService service;
    @NotNull
    private final OfferedserviceRequestRepository offeredserviceRequestRepository;
    @NotNull
    private final ResourceHelperService resourceHelperService;
    @NotNull
    private final KeyCloakService keyCloakService;
    @NotNull
    private final ServiceProviderRepositoryDbDirectSearch serviceProviderRepositoryDbDirectSearch;
    private final Logger log;
    @Value(value="${jhipster.clientApp.name}")
    @Nullable
    private String applicationName;

    public OfferedserviceRequestResource(@NotNull OfferedServiceService service, @NotNull OfferedserviceRequestRepository offeredserviceRequestRepository, @NotNull ResourceHelperService resourceHelperService, @NotNull KeyCloakService keyCloakService, @NotNull ServiceProviderRepositoryDbDirectSearch serviceProviderRepositoryDbDirectSearch) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)offeredserviceRequestRepository, (String)"offeredserviceRequestRepository");
        Intrinsics.checkNotNullParameter((Object)resourceHelperService, (String)"resourceHelperService");
        Intrinsics.checkNotNullParameter((Object)keyCloakService, (String)"keyCloakService");
        Intrinsics.checkNotNullParameter((Object)serviceProviderRepositoryDbDirectSearch, (String)"serviceProviderRepositoryDbDirectSearch");
        this.service = service;
        this.offeredserviceRequestRepository = offeredserviceRequestRepository;
        this.resourceHelperService = resourceHelperService;
        this.keyCloakService = keyCloakService;
        this.serviceProviderRepositoryDbDirectSearch = serviceProviderRepositoryDbDirectSearch;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @PostMapping(value={"/offeredservice-requests"})
    @NotNull
    public ResponseEntity<OfferedServiceRequestOasResource> createOfferedserviceRequest(@Valid @RequestBody @NotNull OfferedserviceCreationRequest offeredserviceRequest) {
        Intrinsics.checkNotNullParameter((Object)offeredserviceRequest, (String)"offeredserviceRequest");
        this.log.debug("REST request to save OfferedserviceRequest : {}", (Object)offeredserviceRequest);
        boolean isPoweruser = this.keyCloakService.isCurrentUserPoweruser();
        Long shifterId = this.resourceHelperService.getShifterId();
        if (isPoweruser || shifterId != null) {
            OfferedserviceRequest result = this.service.createRequest(offeredserviceRequest, shifterId, isPoweruser);
            ResponseEntity responseEntity = ResponseEntity.created((URI)new URI(Intrinsics.stringPlus((String)"/api/offeredservice-requests/", (Object)result.getId()))).body((Object)new OfferedServiceRequestOasResource(result));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"created(URI(\"/api/offere\u2026questOasResource(result))");
            return responseEntity;
        }
        throw new BadRequestAlertException("No shifter assigned ", "offeredserviceRequest", "offeredserviceRequest.noShifterToUserAssigned");
    }

    @PutMapping(value={"/offeredservice-requests/{id}/{accept}"})
    @NotNull
    public ResponseEntity<String> updateState(@PathVariable long id, @PathVariable boolean accept) {
        this.log.debug("REST request to updateState OfferedserviceRequest : " + id + ' ' + accept);
        if (accept) {
            this.service.acceptOfferedServiceRequest(id);
        } else {
            this.service.rejectOfferedServiceRequest(id, null);
        }
        ResponseEntity responseEntity = ResponseEntity.ok((Object)"OK");
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(\"OK\")");
        return responseEntity;
    }

    @PutMapping(value={"/offeredservice-requests/{id}/reject/{rejectMessage}"})
    @NotNull
    public ResponseEntity<String> reject(@PathVariable long id, @PathVariable @Nullable String rejectMessage) {
        this.log.debug("REST request to rejectMessage OfferedserviceRequest : " + id + ' ' + rejectMessage);
        this.service.rejectOfferedServiceRequest(id, rejectMessage);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)"OK");
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(\"OK\")");
        return responseEntity;
    }

    public static /* synthetic */ ResponseEntity reject$default(OfferedserviceRequestResource offeredserviceRequestResource, long l, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reject");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return offeredserviceRequestResource.reject(l, string);
    }

    @PutMapping(value={"/offeredservice-requests"})
    @NotNull
    public ResponseEntity<OfferedserviceRequest> updateOfferedserviceRequest(@Valid @RequestBody @NotNull OfferedserviceRequest offeredserviceRequest) {
        Intrinsics.checkNotNullParameter((Object)offeredserviceRequest, (String)"offeredserviceRequest");
        this.log.debug("REST request to update OfferedserviceRequest : {}", (Object)offeredserviceRequest);
        if (offeredserviceRequest.getId() == null) {
            throw new BadRequestAlertException("Invalid id", "offeredserviceRequest", "idnull");
        }
        if (!this.keyCloakService.isCurrentUserPoweruser() && offeredserviceRequest.getState() != ServiceState.REQUESTED) {
            throw new BadRequestAlertException("change state not allowed for non poweruser", "offeredserviceRequest", "rightproblem");
        }
        OfferedserviceRequest result = (OfferedserviceRequest)this.offeredserviceRequestRepository.save((Object)offeredserviceRequest);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)"offeredserviceRequest", (String)String.valueOf(offeredserviceRequest.getId())))).body((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok()\n            .header\u2026            .body(result)");
        return responseEntity;
    }

    @GetMapping(value={"/offeredservice-requests"})
    @PreAuthorize(value="hasRole(\"ROLE_POWERUSER\")")
    @NotNull
    public List<OfferedserviceRequest> getAllOfferedserviceRequests() {
        this.log.debug("REST request to get all OfferedserviceRequests");
        List list = this.offeredserviceRequestRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"offeredserviceRequestRepository.findAll()");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/offeredservice-requests-gui/search"})
    @Transactional(readOnly=true)
    @NotNull
    public List<OfferedserviceRequestGui> getAllOfferedserviceRequestGuis(@RequestParam @NotNull String states, @RequestParam @Nullable String searchName) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)states, (String)"states");
        this.log.info("Search states: " + states + " with name: " + searchName);
        Map usrEntries = this.keyCloakService.getAllUserAttributes();
        Map shifter2Mei = this.serviceProviderRepositoryDbDirectSearch.shifterId2IMeis();
        Iterable $this$mapNotNull$iv = this.offeredserviceRequestRepository.findByState(ServiceState.valueOf((String)states));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            OfferedserviceRequestGui offeredserviceRequestGui;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            OfferedserviceRequest it = (OfferedserviceRequest)element$iv$iv;
            boolean bl2 = false;
            if (this.mapOrr(it, usrEntries, shifter2Mei) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            OfferedserviceRequestGui it$iv$iv = offeredserviceRequestGui;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OfferedserviceRequestGui it = (OfferedserviceRequestGui)element$iv$iv;
            boolean bl = false;
            if (!this.filterBySearchName(searchName, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List result = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        return result;
    }

    private final boolean filterBySearchName(String searchName, OfferedserviceRequestGui offeredserviceRequest) {
        String string = searchName;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            if (StringUtils.isBlank((CharSequence)searchName) || Intrinsics.areEqual((Object)searchName, (Object)"null")) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)offeredserviceRequest.getUserName(), (CharSequence)searchName)) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)offeredserviceRequest.getFirstName(), (CharSequence)searchName)) {
                return true;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)offeredserviceRequest.getLastName(), (CharSequence)searchName)) {
                return true;
            }
            return StringUtils.containsIgnoreCase((CharSequence)(offeredserviceRequest.getFirstName() + ' ' + offeredserviceRequest.getLastName()), (CharSequence)searchName);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/offeredservice-requests-gui"})
    @Transactional(readOnly=true)
    @NotNull
    public List<OfferedserviceRequestGui> getAllOfferedserviceRequestGuis(@RequestParam @Nullable String searchName) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Map usrEntries = this.keyCloakService.getAllUserAttributes();
        Map shifter2Mei = this.serviceProviderRepositoryDbDirectSearch.shifterId2IMeis();
        this.log.debug("REST request to get all OfferedserviceRequestsgui");
        List list = this.offeredserviceRequestRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"this.offeredserviceRequestRepository.findAll()");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            OfferedserviceRequestGui offeredserviceRequestGui;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            OfferedserviceRequest it = (OfferedserviceRequest)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (this.mapOrr(it, usrEntries, shifter2Mei) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            OfferedserviceRequestGui it$iv$iv = offeredserviceRequestGui;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OfferedserviceRequestGui it = (OfferedserviceRequestGui)element$iv$iv;
            boolean bl = false;
            if (!this.filterBySearchName(searchName, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final OfferedserviceRequestGui mapOrr(OfferedserviceRequest it, Map<String, KeyCloakUserData> usrEntries, Map<Long, ? extends List<String>> shifter2Mei) {
        boolean bl;
        boolean bl2;
        Userprofile userprofile;
        Set imeis = null;
        imeis = SetsKt.emptySet();
        Long l = it.getShifter().getId();
        Intrinsics.checkNotNull((Object)l);
        Userprofile userprofile2 = shifter2Mei.get(l);
        if (userprofile2 != null) {
            userprofile = userprofile2;
            bl2 = false;
            bl = false;
            Userprofile ims = userprofile;
            boolean bl3 = false;
            imeis = CollectionsKt.toSet((Iterable)((Iterable)ims));
        }
        userprofile2 = (Userprofile)CollectionsKt.firstOrNull((Iterable)it.getShifter().getUsers());
        if (userprofile2 != null) {
            userprofile = userprofile2;
            bl2 = false;
            bl = false;
            Userprofile up = userprofile;
            boolean bl4 = false;
            String string = up.getId();
            Intrinsics.checkNotNull((Object)string);
            KeyCloakUserData keyCloakUserData = usrEntries.get(string);
            if (keyCloakUserData != null) {
                List list;
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                List list2;
                String string2;
                String string3;
                Object object;
                Object object2;
                KeyCloakUserData keyCloakUserData2 = keyCloakUserData;
                boolean bl5 = false;
                boolean bl6 = false;
                KeyCloakUserData kcUser = keyCloakUserData2;
                boolean bl7 = false;
                Attributes attributes = kcUser.getAttributes();
                String postalCode = attributes == null ? "" : ((object2 = attributes.getPostal_code()) == null ? "" : ((object = (String)CollectionsKt.firstOrNull((List)object2)) == null ? "" : object));
                object2 = kcUser.getAttributes();
                String city = object2 == null ? "" : ((object = object2.getLocality()) == null ? "" : ((string3 = (String)CollectionsKt.firstOrNull((List)object)) == null ? "" : string3));
                Long l2 = it.getId();
                Intrinsics.checkNotNull((Object)l2);
                long l3 = l2;
                ShifterRolesEnum shifterRolesEnum = it.getServiceType();
                object2 = it.getState();
                int n = WhenMappings.$EnumSwitchMapping$0[object2.ordinal()];
                switch (n) {
                    case 1: {
                        string2 = "Aktiv";
                        break;
                    }
                    case 2: {
                        string2 = "Abgelehnt";
                        break;
                    }
                    case 3: {
                        string2 = "Angefragt";
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                object2 = it.getProductgroup();
                String string4 = object2 == null ? null : object2.getName();
                object2 = kcUser.getFirstName();
                Object object3 = object2 == null ? "" : object2;
                object2 = kcUser.getLastName();
                Object object4 = object2 == null ? "" : object2;
                object2 = kcUser.getAttributes();
                String string5 = object2 == null ? "" : ((list2 = object2.getStreet()) == null ? "" : ((string3 = (String)CollectionsKt.firstOrNull((List)list2)) == null ? "" : string3));
                object2 = it.getProducts();
                String string6 = postalCode + ' ' + city;
                String string7 = string5;
                Object object5 = object4;
                Object object6 = object3;
                String string8 = string4;
                String string9 = it.getDescription();
                String string10 = string2;
                ShifterRolesEnum shifterRolesEnum2 = shifterRolesEnum;
                long l4 = l3;
                boolean $i$f$mapNotNull = false;
                string3 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String string11;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl8 = false;
                    Product p = (Product)element$iv$iv;
                    boolean bl9 = false;
                    if (p.getName() == null) continue;
                    boolean bl10 = false;
                    boolean bl11 = false;
                    String it$iv$iv = string11;
                    boolean bl12 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list3 = (List)destination$iv$iv;
                object2 = kcUser.getAttributes();
                String string12 = object2 == null ? null : ((list = object2.getPhoneNumber()) == null ? null : (String)CollectionsKt.firstOrNull((List)list));
                String string13 = it.getReasonRejection();
                String string14 = it.getShifter().getDisplayName();
                ZonedDateTime zonedDateTime = it.getCreationTime();
                Set set = imeis;
                String string15 = kcUser.getEmail();
                String string16 = string12;
                Set set2 = CollectionsKt.toSet((Iterable)list3);
                String string17 = string6;
                String string18 = string7;
                Object object7 = object5;
                Object object8 = object6;
                String string19 = string8;
                String string20 = string9;
                String string21 = string10;
                ShifterRolesEnum shifterRolesEnum3 = shifterRolesEnum2;
                long l5 = l4;
                return new OfferedserviceRequestGui(l5, shifterRolesEnum3, string21, string20, string19, (String)object8, (String)object7, string18, string17, set2, string16, string15, set, zonedDateTime, string14, string13);
            }
            this.log.error("keycloakuser not found for shifter :" + it.getShifter().getId() + " user(kc-id):" + up.getId());
            return null;
        }
        this.log.error(Intrinsics.stringPlus((String)"shifter without user:", (Object)it.getShifter().getId()));
        return null;
    }

    @GetMapping(value={"/offeredservice-requests/{id}"})
    @Transactional
    @NotNull
    public ResponseEntity<OfferedServiceRequestOasResource> getOfferedserviceRequest(@PathVariable long id) {
        this.log.debug("REST request to get OfferedserviceRequest : {}", (Object)id);
        Optional offeredserviceRequest = this.offeredserviceRequestRepository.findById((Object)id);
        if (offeredserviceRequest.isPresent()) {
            Object t = offeredserviceRequest.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"offeredserviceRequest.get()");
            ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.of(new OfferedServiceRequestOasResource((OfferedserviceRequest)t)));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"wrapOrNotFound(Optional.\u2026edserviceRequest.get())))");
            return responseEntity;
        }
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.empty());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"wrapOrNotFound(Optional.empty())");
        return responseEntity;
    }

    @DeleteMapping(value={"/offeredservice-requests/{id}"})
    @NotNull
    public ResponseEntity<Void> deleteOfferedserviceRequest(@PathVariable long id) {
        this.log.debug("REST request to delete OfferedserviceRequest : {}", (Object)id);
        this.offeredserviceRequestRepository.deleteById((Object)id);
        ResponseEntity responseEntity = ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)"offeredserviceRequest", (String)String.valueOf(id))).build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"noContent()\n            \u2026, id.toString())).build()");
        return responseEntity;
    }
}

