/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.Offeredservice;
import com.shiftphones.shifternetzwerk.hateoas.OfferedServiceHateOasResource;
import com.shiftphones.shifternetzwerk.repository.OfferedserviceRepository;
import com.shiftphones.shifternetzwerk.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\r\u001a\u00020\fH\u0017J\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\r\u001a\u00020\fH\u0017R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/OfferedserviceResource;", "", "offeredserviceRepository", "Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRepository;", "(Lcom/shiftphones/shifternetzwerk/repository/OfferedserviceRepository;)V", "applicationName", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createOfferedservice", "Lorg/springframework/http/ResponseEntity;", "Lcom/shiftphones/shifternetzwerk/domain/Offeredservice;", "offeredservice", "deleteOfferedservice", "Ljava/lang/Void;", "id", "", "getAllOfferedservices", "", "eagerload", "", "getOfferedservice", "Lcom/shiftphones/shifternetzwerk/hateoas/OfferedServiceHateOasResource;", "updateOfferedservice", "shifternetzwerk"})
public class OfferedserviceResource {
    @NotNull
    private final OfferedserviceRepository offeredserviceRepository;
    private final Logger log;
    @Value(value="${jhipster.clientApp.name}")
    @Nullable
    private String applicationName;

    public OfferedserviceResource(@NotNull OfferedserviceRepository offeredserviceRepository) {
        Intrinsics.checkNotNullParameter((Object)offeredserviceRepository, (String)"offeredserviceRepository");
        this.offeredserviceRepository = offeredserviceRepository;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @PostMapping(value={"/offeredservices"})
    @NotNull
    public ResponseEntity<Offeredservice> createOfferedservice(@Valid @RequestBody @NotNull Offeredservice offeredservice) {
        Intrinsics.checkNotNullParameter((Object)offeredservice, (String)"offeredservice");
        this.log.debug("REST request to save Offeredservice : {}", (Object)offeredservice);
        if (offeredservice.getId() != null) {
            throw new BadRequestAlertException("A new offeredservice cannot already have an ID", "offeredservice", "idexists");
        }
        Offeredservice result = (Offeredservice)this.offeredserviceRepository.save((Object)offeredservice);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI(Intrinsics.stringPlus((String)"/api/offeredservices/", (Object)result.getId()))).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)"offeredservice", (String)String.valueOf(result.getId())))).body((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"created(URI(\"/api/offere\u2026            .body(result)");
        return responseEntity;
    }

    @PutMapping(value={"/offeredservices"})
    @NotNull
    public ResponseEntity<Offeredservice> updateOfferedservice(@Valid @RequestBody @NotNull Offeredservice offeredservice) {
        Intrinsics.checkNotNullParameter((Object)offeredservice, (String)"offeredservice");
        this.log.debug("REST request to update Offeredservice : {}", (Object)offeredservice);
        if (offeredservice.getId() == null) {
            throw new BadRequestAlertException("Invalid id", "offeredservice", "idnull");
        }
        Offeredservice result = (Offeredservice)this.offeredserviceRepository.save((Object)offeredservice);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)"offeredservice", (String)String.valueOf(offeredservice.getId())))).body((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok()\n            .header\u2026            .body(result)");
        return responseEntity;
    }

    @GetMapping(value={"/offeredservices"})
    @NotNull
    public List<Offeredservice> getAllOfferedservices(@RequestParam(required=false, defaultValue="false") boolean eagerload) {
        this.log.debug("REST request to get all Offeredservices");
        return this.offeredserviceRepository.findAllWithEagerRelationships();
    }

    @GetMapping(value={"/offeredservices/{id}"})
    @NotNull
    public ResponseEntity<OfferedServiceHateOasResource> getOfferedservice(@PathVariable long id) {
        this.log.debug("REST request to get Offeredservice : {}", (Object)id);
        Optional offeredservice = this.offeredserviceRepository.findOneWithEagerRelationships(id);
        if (offeredservice.isPresent()) {
            Object object = offeredservice.get();
            Intrinsics.checkNotNullExpressionValue(object, (String)"offeredservice.get()");
            Offeredservice os = (Offeredservice)object;
            object = ResponseUtil.wrapOrNotFound(Optional.of(new OfferedServiceHateOasResource(os)));
            Intrinsics.checkNotNullExpressionValue(object, (String)"wrapOrNotFound(Optional.\u2026viceHateOasResource(os)))");
            return object;
        }
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.empty());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"wrapOrNotFound(Optional.empty())");
        return responseEntity;
    }

    @DeleteMapping(value={"/offeredservices/{id}"})
    @NotNull
    public ResponseEntity<Void> deleteOfferedservice(@PathVariable long id) {
        this.log.debug("REST request to delete Offeredservice : {}", (Object)id);
        this.offeredserviceRepository.deleteById((Object)id);
        ResponseEntity responseEntity = ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)"offeredservice", (String)String.valueOf(id))).build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"noContent()\n            \u2026, id.toString())).build()");
        return responseEntity;
    }
}

