/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.config.KeyCloakConfiguration;
import com.shiftphones.shifternetzwerk.domain.Shifter;
import com.shiftphones.shifternetzwerk.domain.User;
import com.shiftphones.shifternetzwerk.domain.Userprofile;
import com.shiftphones.shifternetzwerk.repository.ShifterRepository;
import com.shiftphones.shifternetzwerk.repository.UserRepository;
import com.shiftphones.shifternetzwerk.repository.UserprofileRepository;
import com.shiftphones.shifternetzwerk.security.SecurityUtils;
import com.shiftphones.shifternetzwerk.service.KeyCloakService;
import com.shiftphones.shifternetzwerk.web.rest.SecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u000f\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\n\u0010!\u001a\u0004\u0018\u00010 H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020 H\u0016J\u0010\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u001aH\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;", "", "userRepository", "Lcom/shiftphones/shifternetzwerk/repository/UserRepository;", "shifterRepository", "Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;", "upRepo", "Lcom/shiftphones/shifternetzwerk/repository/UserprofileRepository;", "keyCloakConfiguration", "Lcom/shiftphones/shifternetzwerk/config/KeyCloakConfiguration;", "keyCloakService", "Lcom/shiftphones/shifternetzwerk/service/KeyCloakService;", "(Lcom/shiftphones/shifternetzwerk/repository/UserRepository;Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;Lcom/shiftphones/shifternetzwerk/repository/UserprofileRepository;Lcom/shiftphones/shifternetzwerk/config/KeyCloakConfiguration;Lcom/shiftphones/shifternetzwerk/service/KeyCloakService;)V", "getKeyCloakConfiguration", "()Lcom/shiftphones/shifternetzwerk/config/KeyCloakConfiguration;", "getKeyCloakService", "()Lcom/shiftphones/shifternetzwerk/service/KeyCloakService;", "getShifterRepository", "()Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;", "getUpRepo", "()Lcom/shiftphones/shifternetzwerk/repository/UserprofileRepository;", "getUserRepository", "()Lcom/shiftphones/shifternetzwerk/repository/UserRepository;", "getShifter", "Lcom/shiftphones/shifternetzwerk/domain/Shifter;", "getShifterId", "", "()Ljava/lang/Long;", "getUser", "Ljava/util/Optional;", "Lcom/shiftphones/shifternetzwerk/domain/User;", "getUserId", "", "getUserIdOrNull", "isCurrentUserPowerUserAndThrowIfNotAllowed", "", "isCurrentUserPowerUserOrGivenUserAndThrow", "concerningUserProfileId", "isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed", "shifterId", "shifternetzwerk"})
public class ResourceHelperService {
    @NotNull
    private final UserRepository userRepository;
    @NotNull
    private final ShifterRepository shifterRepository;
    @NotNull
    private final UserprofileRepository upRepo;
    @NotNull
    private final KeyCloakConfiguration keyCloakConfiguration;
    @NotNull
    private final KeyCloakService keyCloakService;

    public ResourceHelperService(@NotNull UserRepository userRepository, @NotNull ShifterRepository shifterRepository, @NotNull UserprofileRepository upRepo, @NotNull KeyCloakConfiguration keyCloakConfiguration, @NotNull KeyCloakService keyCloakService) {
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        Intrinsics.checkNotNullParameter((Object)shifterRepository, (String)"shifterRepository");
        Intrinsics.checkNotNullParameter((Object)upRepo, (String)"upRepo");
        Intrinsics.checkNotNullParameter((Object)keyCloakConfiguration, (String)"keyCloakConfiguration");
        Intrinsics.checkNotNullParameter((Object)keyCloakService, (String)"keyCloakService");
        this.userRepository = userRepository;
        this.shifterRepository = shifterRepository;
        this.upRepo = upRepo;
        this.keyCloakConfiguration = keyCloakConfiguration;
        this.keyCloakService = keyCloakService;
    }

    @NotNull
    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    @NotNull
    public ShifterRepository getShifterRepository() {
        return this.shifterRepository;
    }

    @NotNull
    public UserprofileRepository getUpRepo() {
        return this.upRepo;
    }

    @NotNull
    public KeyCloakConfiguration getKeyCloakConfiguration() {
        return this.keyCloakConfiguration;
    }

    @NotNull
    public KeyCloakService getKeyCloakService() {
        return this.keyCloakService;
    }

    private final Optional<User> getUser() {
        Object t = SecurityUtils.getCurrentUserLogin().orElseThrow(ResourceHelperService::getUser$lambda-0);
        Intrinsics.checkNotNullExpressionValue(t, (String)"getCurrentUserLogin()\n  \u2026user login not found\") })");
        String userLogin = (String)t;
        return this.getUserRepository().findOneByLogin(userLogin);
    }

    @Nullable
    public String getUserIdOrNull() {
        if (this.getUser().isPresent()) {
            String string = ((User)this.getUser().get()).getId();
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        return SecurityUtils.extractUserIdIfUnknownUser();
    }

    @NotNull
    public String getUserId() {
        if (this.getUser().isPresent()) {
            String string = ((User)this.getUser().get()).getId();
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        String string = SecurityUtils.extractUserIdIfUnknownUser();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Nullable
    public Long getShifterId() {
        Shifter shifter = this.getShifter();
        if (shifter != null) {
            Shifter shifter2 = shifter;
            boolean bl = false;
            boolean bl2 = false;
            Shifter it = shifter2;
            boolean bl3 = false;
            return it.getId();
        }
        return null;
    }

    public void isCurrentUserPowerUserOrGivenUserAndThrow(@NotNull String concerningUserProfileId) {
        Intrinsics.checkNotNullParameter((Object)concerningUserProfileId, (String)"concerningUserProfileId");
        if (this.getKeyCloakService().isCurrentUserPoweruser()) {
            return;
        }
        if (Intrinsics.areEqual((Object)concerningUserProfileId, (Object)this.getUserId())) {
            return;
        }
        throw new SecurityException(Intrinsics.stringPlus((String)"concerningUserProfileId not power user or given user ", (Object)concerningUserProfileId));
    }

    private final Shifter getShifter() {
        String string = this.getUserIdOrNull();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            Userprofile userprofile = (Userprofile)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.getUpRepo()), (Object)it);
            if (userprofile != null) {
                Userprofile userprofile2 = userprofile;
                boolean bl4 = false;
                boolean bl5 = false;
                Userprofile up = userprofile2;
                boolean bl6 = false;
                return up.getShifter();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed(long shifterId) {
        if (this.getKeyCloakService().isCurrentUserPoweruser()) {
            return;
        }
        String usrId = this.getUserId();
        Shifter shifter = (Shifter)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.getShifterRepository()), (Object)shifterId);
        if (shifter != null) {
            Object v0;
            boolean bl;
            Object object;
            block5: {
                void $this$mapNotNullTo$iv$iv;
                Shifter shifter2 = shifter;
                boolean bl2 = false;
                boolean bl3 = false;
                Shifter it = shifter2;
                boolean bl4 = false;
                Iterable $this$mapNotNull$iv = it.getUsers();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv22 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String string;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl5 = false;
                    Userprofile u = (Userprofile)element$iv$iv;
                    boolean bl6 = false;
                    if (u.getId() == null) continue;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    String it$iv$iv = string;
                    boolean bl9 = false;
                    destination$iv$iv22.add(it$iv$iv);
                }
                object = (List)destination$iv$iv22;
                bl = false;
                iterable = object;
                boolean destination$iv$iv22 = false;
                for (Object t : iterable) {
                    String uId = (String)t;
                    boolean bl10 = false;
                    if (!Intrinsics.areEqual((Object)usrId, (Object)uId)) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            String string = v0;
            if (string != null) {
                object = string;
                bl = false;
                boolean bl11 = false;
                Object it = object;
                boolean bl12 = false;
                return;
            }
            throw new SecurityException(Intrinsics.stringPlus((String)"no poweruser and no user of shifter ", (Object)shifterId));
        }
        throw new RuntimeException(Intrinsics.stringPlus((String)"unknown shifter ", (Object)shifterId));
    }

    public void isCurrentUserPowerUserAndThrowIfNotAllowed() {
        if (this.getKeyCloakService().isCurrentUserPoweruser()) {
            return;
        }
        throw new RuntimeException("not a poweruser shifter");
    }

    private static final RuntimeException getUser$lambda-0() {
        return new RuntimeException("Current user login not found");
    }
}

