/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.Review;
import com.shiftphones.shifternetzwerk.repository.ReviewRepository;
import com.shiftphones.shifternetzwerk.web.rest.ResourceHelperService;
import com.shiftphones.shifternetzwerk.web.rest.ReviewDataManipulationObject;
import com.shiftphones.shifternetzwerk.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0017J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016H\u0017J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0017R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/ReviewResource;", "", "reviewRepository", "Lcom/shiftphones/shifternetzwerk/repository/ReviewRepository;", "resourceHelperService", "Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;", "(Lcom/shiftphones/shifternetzwerk/repository/ReviewRepository;Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;)V", "applicationName", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createReview", "Lorg/springframework/http/ResponseEntity;", "Lcom/shiftphones/shifternetzwerk/domain/Review;", "review", "Lcom/shiftphones/shifternetzwerk/web/rest/ReviewDataManipulationObject;", "deleteReview", "Ljava/lang/Void;", "id", "", "getAllReviews", "", "getReview", "updateReview", "shifternetzwerk"})
public class ReviewResource {
    @NotNull
    private final ReviewRepository reviewRepository;
    @NotNull
    private final ResourceHelperService resourceHelperService;
    private final Logger log;
    @Value(value="${jhipster.clientApp.name}")
    @Nullable
    private String applicationName;

    public ReviewResource(@NotNull ReviewRepository reviewRepository, @NotNull ResourceHelperService resourceHelperService) {
        Intrinsics.checkNotNullParameter((Object)reviewRepository, (String)"reviewRepository");
        Intrinsics.checkNotNullParameter((Object)resourceHelperService, (String)"resourceHelperService");
        this.reviewRepository = reviewRepository;
        this.resourceHelperService = resourceHelperService;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @PostMapping(value={"/reviews"})
    @NotNull
    public ResponseEntity<Review> createReview(@Valid @RequestBody @NotNull ReviewDataManipulationObject review) {
        Intrinsics.checkNotNullParameter((Object)review, (String)"review");
        this.log.debug("REST request to save Review : {}", (Object)review);
        if (review.getId() != null) {
            throw new BadRequestAlertException("A new review cannot already have an ID", "review", "idexists");
        }
        Long shifterId = this.resourceHelperService.getShifterId();
        Object object = shifterId;
        if (object == null) {
            throw new RuntimeException("No shifter");
        }
        ((Long)object).longValue();
        object = this.reviewRepository.findByShifterCreatorIdAndShifterAboutId(shifterId.longValue(), review.getShifterAboutId());
        boolean bl = false;
        if (!object.isEmpty()) {
            this.log.info("only one review allowed in combination creator: " + shifterId + " aboutId: " + review.getShifterAboutId());
            object = ResponseEntity.status((int)417).build();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"status(417).build()");
            return object;
        }
        Review createdReview = review.from(shifterId.longValue());
        Review result = (Review)this.reviewRepository.save((Object)createdReview);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI(Intrinsics.stringPlus((String)"/api/reviews/", (Object)result.getId()))).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)"review", (String)String.valueOf(result.getId())))).body((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"created(URI(\"/api/review\u2026            .body(result)");
        return responseEntity;
    }

    @PutMapping(value={"/reviews"})
    @NotNull
    public ResponseEntity<Review> updateReview(@Valid @RequestBody @NotNull ReviewDataManipulationObject review) {
        Intrinsics.checkNotNullParameter((Object)review, (String)"review");
        this.log.debug("REST request to update Review : {}", (Object)review);
        if (review.getId() == null) {
            throw new BadRequestAlertException("Invalid id", "review", "idnull");
        }
        Long shifterId = this.resourceHelperService.getShifterId();
        Long l = shifterId;
        if (l == null) {
            throw new RuntimeException("No shifter");
        }
        l.longValue();
        Review createdReview = review.from(shifterId.longValue());
        Review result = (Review)this.reviewRepository.save((Object)createdReview);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)"review", (String)review.getId().toString()))).body((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok()\n            .header\u2026            .body(result)");
        return responseEntity;
    }

    @GetMapping(value={"/reviews"})
    @NotNull
    public List<Review> getAllReviews() {
        this.log.debug("REST request to get all Reviews");
        List list = this.reviewRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"reviewRepository.findAll()");
        return list;
    }

    @GetMapping(value={"/reviews/{id}"})
    @NotNull
    public ResponseEntity<Review> getReview(@PathVariable long id) {
        this.log.debug("REST request to get Review : {}", (Object)id);
        Optional review = this.reviewRepository.findById((Object)id);
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound((Optional)review);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"wrapOrNotFound(review)");
        return responseEntity;
    }

    @DeleteMapping(value={"/reviews/{id}"})
    @NotNull
    public ResponseEntity<Void> deleteReview(@PathVariable long id) {
        this.log.debug("REST request to delete Review : {}", (Object)id);
        Optional optRev = this.reviewRepository.findById((Object)id);
        if (optRev.isPresent()) {
            if (Intrinsics.areEqual((Object)((Review)optRev.get()).getShifterCreatorId(), (Object)this.resourceHelperService.getShifterId())) {
                this.reviewRepository.deleteById((Object)id);
                ResponseEntity responseEntity = ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)"review", (String)String.valueOf(id))).build();
                Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"noContent()\n            \u2026                 .build()");
                return responseEntity;
            }
            throw new BadRequestAlertException("only shifter can delete own ratings", "review", "idnull");
        }
        throw new BadRequestAlertException("Invalid id", "review", "idnull");
    }
}

