/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.Offeredservice;
import com.shiftphones.shifternetzwerk.domain.Review;
import com.shiftphones.shifternetzwerk.domain.Shifter;
import com.shiftphones.shifternetzwerk.domain.ShortEntityObject;
import com.shiftphones.shifternetzwerk.hateoas.ShifterCreatorReviewEntry;
import com.shiftphones.shifternetzwerk.hateoas.ShifterDataManipulationObject;
import com.shiftphones.shifternetzwerk.hateoas.ShifterHateOasDomainObject;
import com.shiftphones.shifternetzwerk.hateoas.ShifterOverviewHateOasResource;
import com.shiftphones.shifternetzwerk.hateoas.TypeConstants;
import com.shiftphones.shifternetzwerk.repository.ReviewRepository;
import com.shiftphones.shifternetzwerk.repository.ServiceProviderRepositoryDbDirectSearch;
import com.shiftphones.shifternetzwerk.repository.ShifterRepository;
import com.shiftphones.shifternetzwerk.service.ShifterService;
import com.shiftphones.shifternetzwerk.service.ShortIdAnswer;
import com.shiftphones.shifternetzwerk.service.ShortShifterOverview;
import com.shiftphones.shifternetzwerk.web.rest.ResourceHelperService;
import com.shiftphones.shifternetzwerk.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u0018H\u0017J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\b\b\u0001\u0010\u001b\u001a\u00020\u001cH\u0017J\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\b\b\u0001\u0010\u001b\u001a\u00020\u001eH\u0017J\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00132\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00132\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\b\b\u0001\u0010\u001b\u001a\u00020\u001cH\u0017R\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/ShifterResource;", "", "shifterRepository", "Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;", "shifterService", "Lcom/shiftphones/shifternetzwerk/service/ShifterService;", "resourceHelperService", "Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;", "serviceProviderRepositoryDbDirectSearch", "Lcom/shiftphones/shifternetzwerk/repository/ServiceProviderRepositoryDbDirectSearch;", "reviewRepository", "Lcom/shiftphones/shifternetzwerk/repository/ReviewRepository;", "(Lcom/shiftphones/shifternetzwerk/repository/ShifterRepository;Lcom/shiftphones/shifternetzwerk/service/ShifterService;Lcom/shiftphones/shifternetzwerk/web/rest/ResourceHelperService;Lcom/shiftphones/shifternetzwerk/repository/ServiceProviderRepositoryDbDirectSearch;Lcom/shiftphones/shifternetzwerk/repository/ReviewRepository;)V", "applicationName", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addService2Shifter", "Lorg/springframework/http/ResponseEntity;", "Lcom/shiftphones/shifternetzwerk/service/ShortIdAnswer;", "id", "", "offeredservice", "Lcom/shiftphones/shifternetzwerk/domain/Offeredservice;", "createShifter", "Lcom/shiftphones/shifternetzwerk/domain/ShortEntityObject;", "shifter", "Lcom/shiftphones/shifternetzwerk/hateoas/ShifterDataManipulationObject;", "createShifterMigr", "Lcom/shiftphones/shifternetzwerk/domain/Shifter;", "deleteShifter", "Ljava/lang/Void;", "getShifter", "Lcom/shiftphones/shifternetzwerk/hateoas/ShifterOverviewHateOasResource;", "updateShifter", "shifternetzwerk"})
public class ShifterResource {
    @NotNull
    private final ShifterRepository shifterRepository;
    @NotNull
    private final ShifterService shifterService;
    @NotNull
    private final ResourceHelperService resourceHelperService;
    @NotNull
    private final ServiceProviderRepositoryDbDirectSearch serviceProviderRepositoryDbDirectSearch;
    @NotNull
    private final ReviewRepository reviewRepository;
    private final Logger log;
    @Value(value="${jhipster.clientApp.name}")
    @Nullable
    private String applicationName;

    public ShifterResource(@NotNull ShifterRepository shifterRepository, @NotNull ShifterService shifterService, @NotNull ResourceHelperService resourceHelperService, @NotNull ServiceProviderRepositoryDbDirectSearch serviceProviderRepositoryDbDirectSearch, @NotNull ReviewRepository reviewRepository) {
        Intrinsics.checkNotNullParameter((Object)shifterRepository, (String)"shifterRepository");
        Intrinsics.checkNotNullParameter((Object)shifterService, (String)"shifterService");
        Intrinsics.checkNotNullParameter((Object)resourceHelperService, (String)"resourceHelperService");
        Intrinsics.checkNotNullParameter((Object)serviceProviderRepositoryDbDirectSearch, (String)"serviceProviderRepositoryDbDirectSearch");
        Intrinsics.checkNotNullParameter((Object)reviewRepository, (String)"reviewRepository");
        this.shifterRepository = shifterRepository;
        this.shifterService = shifterService;
        this.resourceHelperService = resourceHelperService;
        this.serviceProviderRepositoryDbDirectSearch = serviceProviderRepositoryDbDirectSearch;
        this.reviewRepository = reviewRepository;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @PostMapping(value={"/shifters"})
    @NotNull
    public ResponseEntity<ShortEntityObject> createShifter(@RequestBody @NotNull ShifterDataManipulationObject shifter) {
        Intrinsics.checkNotNullParameter((Object)shifter, (String)"shifter");
        this.log.debug("REST request to save Shifter : {}", (Object)shifter);
        if (shifter.getId() != null) {
            throw new BadRequestAlertException("A new shifter cannot already have an ID", "shifter", "idexists");
        }
        this.resourceHelperService.isCurrentUserPowerUserOrGivenUserAndThrow((String)CollectionsKt.first((Iterable)shifter.getUsers()));
        ShortEntityObject result = this.shifterService.create(shifter);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI(Intrinsics.stringPlus((String)"/api/shifters/", (Object)result.getId()))).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)"shifter", (String)String.valueOf(result.getId())))).body((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"created(URI(\"/api/shifte\u2026            .body(result)");
        return responseEntity;
    }

    @PostMapping(value={"/shiftersMigr"})
    @NotNull
    public ResponseEntity<ShortEntityObject> createShifterMigr(@RequestBody @NotNull Shifter shifter) {
        Intrinsics.checkNotNullParameter((Object)shifter, (String)"shifter");
        this.log.error("REST request to save createShifterMigr only in dev : {}", (Object)shifter);
        if (shifter.getId() != null) {
            throw new BadRequestAlertException("A new shifter cannot already have an ID", "shifter", "idexists");
        }
        ShortEntityObject result = this.shifterService.create(shifter);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI(Intrinsics.stringPlus((String)"/api/shifters/", (Object)result.getId()))).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)"shifter", (String)String.valueOf(result.getId())))).body((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"created(URI(\"/api/shifte\u2026            .body(result)");
        return responseEntity;
    }

    @PutMapping(value={"/shifters"})
    @Transactional
    @NotNull
    public ResponseEntity<String> updateShifter(@RequestBody @NotNull ShifterDataManipulationObject shifter) {
        Intrinsics.checkNotNullParameter((Object)shifter, (String)"shifter");
        this.log.debug("REST request to update Shifter : {}", (Object)shifter);
        if (shifter.getId() == null) {
            throw new BadRequestAlertException("Invalid id", "shifter", "idnull");
        }
        Long l = shifter.getId();
        Intrinsics.checkNotNull((Object)l);
        this.resourceHelperService.isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed(l.longValue());
        this.shifterService.update(shifter);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)"shifter", (String)String.valueOf(shifter.getId())))).body((Object)"OK");
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok()\n            .header\u2026)\n            .body(\"OK\")");
        return responseEntity;
    }

    @PutMapping(value={"/shifters/{id}/addService"})
    @NotNull
    public ResponseEntity<ShortIdAnswer> addService2Shifter(@PathVariable long id, @RequestBody @NotNull Offeredservice offeredservice) {
        Intrinsics.checkNotNullParameter((Object)offeredservice, (String)"offeredservice");
        this.resourceHelperService.isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed(id);
        ShortIdAnswer result = this.shifterService.addService2Shifter(id, offeredservice);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)"shifter", (String)String.valueOf(id)))).body((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok()\n            .header\u2026            .body(result)");
        return responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/shifters/{id}"})
    @Transactional(readOnly=true)
    @NotNull
    public ResponseEntity<ShifterOverviewHateOasResource> getShifter(@PathVariable long id) {
        this.log.debug("REST request to get Shifter : {}", (Object)id);
        this.resourceHelperService.isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed(id);
        Shifter shifter = (Shifter)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.shifterRepository), (Object)id);
        if (shifter != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapNotNullTo$iv$iv;
            Shifter shifter2 = shifter;
            boolean bl = false;
            boolean bl2 = false;
            Shifter it = shifter2;
            boolean bl3 = false;
            ZonedDateTime zonedDateTime = it.getDeleteTimepoint();
            if (zonedDateTime != null) {
                ZonedDateTime zonedDateTime2 = zonedDateTime;
                boolean bl4 = false;
                boolean bl5 = false;
                ZonedDateTime it2 = zonedDateTime2;
                boolean bl6 = false;
                ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(Optional.empty());
                Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"wrapOrNotFound(Optional.empty())");
                return responseEntity;
            }
            Pair res = this.serviceProviderRepositoryDbDirectSearch.findServiceIdSummaryByShifter(id);
            Set offeredServices = (Set)res.getSecond();
            Set offeredServiceRequests = (Set)res.getFirst();
            int sumOfHelpful = 0;
            ShortShifterOverview it2 = (ShortShifterOverview)CollectionsKt.firstOrNull((List)this.serviceProviderRepositoryDbDirectSearch.findAllShifterForOneShifter(id));
            if (it2 != null) {
                ShortShifterOverview bl6 = it2;
                boolean bl7 = false;
                boolean bl8 = false;
                ShortShifterOverview it3 = bl6;
                boolean bl9 = false;
                sumOfHelpful = it3.getRating();
            }
            Set histOwnedProdIds = this.serviceProviderRepositoryDbDirectSearch.findHistoryProdOwnedIdsByShifterId(id);
            String wodaTypeConstantName = new TypeConstants().getREVIEW_WODA_NAME();
            Iterable $this$mapNotNull$iv = this.reviewRepository.findByShifterCreatorId(id);
            boolean $i$f$mapNotNull = false;
            Iterable bl9 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Long l;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl10 = false;
                Review it4 = (Review)element$iv$iv;
                boolean bl11 = false;
                if (it4.getId() == null) continue;
                boolean bl12 = false;
                boolean bl13 = false;
                Long it$iv$iv = l;
                boolean bl14 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it5;
                long l = ((Number)item$iv$iv).longValue();
                Collection collection = destination$iv$iv;
                boolean bl15 = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"href", (Object)Intrinsics.stringPlus((String)"reviews/", (Object)((long)it5))), TuplesKt.to((Object)"type", (Object)wodaTypeConstantName), TuplesKt.to((Object)"media", (Object)"application/vnd.EAMD+json")};
                ShifterCreatorReviewEntry shifterCreatorReviewEntry = new ShifterCreatorReviewEntry(Long.valueOf((long)it5), MapsKt.mapOf((Pair[])pairArray));
                collection.add(shifterCreatorReviewEntry);
            }
            List ratingOnOthers = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            ResponseEntity responseEntity = ResponseEntity.ok((Object)new ShifterOverviewHateOasResource(new ShifterHateOasDomainObject(it, offeredServiceRequests, offeredServices, sumOfHelpful, ratingOnOthers, histOwnedProdIds)));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(ShifterOverviewHateOa\u2026hers, histOwnedProdIds)))");
            return responseEntity;
        }
        shifter = ResponseUtil.wrapOrNotFound(Optional.empty());
        Intrinsics.checkNotNullExpressionValue((Object)shifter, (String)"wrapOrNotFound(Optional.empty())");
        return shifter;
    }

    @DeleteMapping(value={"/shifters/{id}"})
    @Transactional
    @NotNull
    public ResponseEntity<Void> deleteShifter(@PathVariable long id) {
        this.log.debug("REST request to delete Shifter : {}", (Object)id);
        this.resourceHelperService.isCurrentUserPowerUserOrOneOfTheShifterAndThrowIfNotAllowed(id);
        this.shifterService.deleteById(id);
        ResponseEntity responseEntity = ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)"shifter", (String)String.valueOf(id))).build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"noContent()\n            \u2026, id.toString())).build()");
        return responseEntity;
    }
}

