/*
 * Decompiled with CFR 0.152.
 */
package com.shiftphones.shifternetzwerk.web.rest;

import com.shiftphones.shifternetzwerk.domain.User;
import com.shiftphones.shifternetzwerk.service.UserService;
import com.shiftphones.shifternetzwerk.service.dto.UserDTO;
import io.github.jhipster.web.util.PaginationUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011H\u0017J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u000b2\b\b\u0001\u0010\u0013\u001a\u00020\u0006H\u0017R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/shiftphones/shifternetzwerk/web/rest/UserResource;", "", "userService", "Lcom/shiftphones/shifternetzwerk/service/UserService;", "(Lcom/shiftphones/shifternetzwerk/service/UserService;)V", "applicationName", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getAllUsers", "Lorg/springframework/http/ResponseEntity;", "", "Lcom/shiftphones/shifternetzwerk/service/dto/UserDTO;", "pageable", "Lorg/springframework/data/domain/Pageable;", "getAuthorities", "", "getUser", "login", "shifternetzwerk"})
public class UserResource {
    @NotNull
    private final UserService userService;
    private final Logger log;
    @Value(value="${jhipster.clientApp.name}")
    @Nullable
    private final String applicationName;

    public UserResource(@NotNull UserService userService) {
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        this.userService = userService;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @GetMapping(value={"/users"})
    @NotNull
    public ResponseEntity<List<UserDTO>> getAllUsers(@NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.userService.getAllManagedUsers(pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest()), (Page)page);
        return new ResponseEntity((Object)page.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(value={"/users/authorities"})
    @PreAuthorize(value="hasAuthority(\"ROLE_ADMIN\")")
    @NotNull
    public List<String> getAuthorities() {
        return this.userService.getAuthorities();
    }

    @GetMapping(value={"/users/{login:^(?>[a-zA-Z0-9!$&*+=?^_`{|}~.-]+@[a-zA-Z0-9-]+(?:\\.[a-zA-Z0-9-]+)*)|(?>[_.@A-Za-z0-9-]+)$}"})
    @NotNull
    public ResponseEntity<UserDTO> getUser(@PathVariable @NotNull String login) {
        Intrinsics.checkNotNullParameter((Object)login, (String)"login");
        this.log.debug(Intrinsics.stringPlus((String)"REST request to get User : ", (Object)login));
        ResponseEntity responseEntity = ResponseUtil.wrapOrNotFound(this.userService.getUserWithAuthoritiesByLogin(login).map(UserResource::getUser$lambda-0));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"wrapOrNotFound(\n        \u2026    .map { UserDTO(it) })");
        return responseEntity;
    }

    private static final UserDTO getUser$lambda-0(User it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return new UserDTO(it);
    }
}

