#!/bin/sh

checkOne() {
    if [ $2 $3 ]; then
    	echo "ok            : $1: $3"
    else
        echo "does not exist: $1: $3" 
        echo ">     fix with:                                          $4"
    fi
}

checkCommand() {
    command=$1
    package=$2
    if [ -z "$package" ]; then
        package=$command
    fi   

    checkPMs
    if ! [ -x "$(command -v $command)" ]; then
        echo "no $command"
        if [ -n "$PM" ]; then
            $PM $package
        else
            echo no package manger
        fi
    fi
}

checkPMs() {
    checkPM apt "apt-get -y install"
    checkPM apk "apk add"
    checkPM dpkg "dpkg install"
}

checkPM() {
    packageManager=$1
    packageManagerCommand=$2
    if [ -z "$packageManagerCommand" ]; then
        package=$packageManager
    fi   
    if ! [ -x "$(command -v $packageManager)" ]; then
        echo "no $packageManager"
    else
    if [ -z "$PM" ]; then
        export PM=$packageManagerCommand
        echo "Package Manager found: using $PM somePackage"
        if [ "$packageManager" = "apt" ]; then
            apt-get update
        fi
    fi
    fi
}

checkBash() {
    checkPMs

    if ! [ -x "$(command -v bash)" ]; then
        echo "no bash"
        $PM bash
        echo "start bash" 
        bash $0 installed
        exit
    else
        echo "bash: $(which $SHELL) $*"
        if [ -z "$1" ]; then
            echo "start bash" 
            bash $0 found
            exit
        fi
    fi
}

stepDebugger() {
    echo " function stepDebugger($1)"
    if [ "$1" = "ON" ]; then
        echo step debugger is now ON
        trap step DEBUG
    fi
}

function step {
  set +x
  if [[ -n "$BASH_COMMAND" ]]; then
    echo "<-----------------------------------------"
    echo \> \'$BASH_COMMAND\'
    read -p '' CONT
    if [[ ! "$CONT" = "" ]]; then
      echo Exiting prematurely
      exit 1
    fi
    set -x
  fi
}


checkBash $*
#checkCommand tree
#checkCommand git

#stepDebugger ON
#cd
#tree -L 2 

#rm eamd
#wget http://192.168.178.49:8080/EAMD.ucp/Components/tla/EAMD/UcpComponentSupport/1.0.0/src/sh/eamd
#wget http://wo-da.de/EAMD.ucp/Components/tla/EAMD/UcpComponentSupport/1.0.0/src/sh/eamd
#chmod 700 eamd
export PATH=$PATH:.
#eamd check
#eamd init all
oosh init profile
#. eamd check
#cd /usr/local/sbin
#rm eamd
#cp $defaultWorkspace/eamd eamd
#cd $gitDir

echo ""

echo "done - SUCESS, EAMD is installed... enter newly confugured bash"

bash
echo "done - SUCESS, WODA is installed"
exit 0