/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaIdFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jxmpp.util.XmppStringUtils;

public class IQReplyFilter
implements StanzaFilter {
    private static final Logger LOGGER = Logger.getLogger(IQReplyFilter.class.getName());
    private final StanzaFilter iqAndIdFilter;
    private final OrFilter fromFilter;
    private final String to;
    private final String local;
    private final String server;
    private final String packetId;

    public IQReplyFilter(IQ iqPacket, XMPPConnection conn) {
        if (!iqPacket.isRequestIQ()) {
            throw new IllegalArgumentException("IQ must be a request IQ, i.e. of type 'get' or 'set'.");
        }
        this.to = iqPacket.getTo() != null ? iqPacket.getTo().toLowerCase(Locale.US) : null;
        String localJid = conn.getUser();
        if (localJid == null) {
            throw new IllegalArgumentException("Must have a local (user) JID set. Either you didn't configure one or you where not connected at least once");
        }
        this.local = localJid.toLowerCase(Locale.US);
        this.server = conn.getServiceName().toLowerCase(Locale.US);
        this.packetId = iqPacket.getStanzaId();
        OrFilter iqFilter = new OrFilter(IQTypeFilter.ERROR, IQTypeFilter.RESULT);
        StanzaIdFilter idFilter = new StanzaIdFilter(iqPacket);
        this.iqAndIdFilter = new AndFilter(iqFilter, idFilter);
        this.fromFilter = new OrFilter();
        this.fromFilter.addFilter(FromMatchesFilter.createFull(this.to));
        if (this.to == null) {
            this.fromFilter.addFilter(FromMatchesFilter.createBare(this.local));
            this.fromFilter.addFilter(FromMatchesFilter.createFull(this.server));
        } else if (this.to.equals(XmppStringUtils.parseBareJid((String)this.local))) {
            this.fromFilter.addFilter(FromMatchesFilter.createFull(null));
        }
    }

    @Override
    public boolean accept(Stanza packet) {
        if (!this.iqAndIdFilter.accept(packet)) {
            return false;
        }
        if (this.fromFilter.accept(packet)) {
            return true;
        }
        String msg = String.format("Rejected potentially spoofed reply to IQ-packet. Filter settings: packetId=%s, to=%s, local=%s, server=%s. Received packet with from=%s", this.packetId, this.to, this.local, this.server, packet.getFrom());
        LOGGER.log(Level.WARNING, msg, packet);
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(": iqAndIdFilter (").append(this.iqAndIdFilter.toString()).append("), ");
        sb.append(": fromFilter (").append(this.fromFilter.toString()).append(')');
        return sb.toString();
    }
}

