/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

class StructurePropagation<KEY> {
    boolean hasLeftChildUpdate;
    boolean hasRightChildUpdate;
    boolean hasMidChildUpdate;
    boolean hasRightKeyInsert;
    boolean hasLeftKeyReplace;
    boolean hasRightKeyReplace;
    final KEY leftKey;
    final KEY rightKey;
    final KEY bubbleKey;
    long leftChild;
    long midChild;
    long rightChild;
    KeyReplaceStrategy keyReplaceStrategy;
    static final StructureUpdate UPDATE_LEFT_CHILD = (sp, childId) -> {
        sp.hasLeftChildUpdate = true;
        sp.leftChild = childId;
    };
    static final StructureUpdate UPDATE_MID_CHILD = (sp, childId) -> {
        sp.hasMidChildUpdate = true;
        sp.midChild = childId;
    };
    static final StructureUpdate UPDATE_RIGHT_CHILD = (sp, childId) -> {
        sp.hasRightChildUpdate = true;
        sp.rightChild = childId;
    };

    StructurePropagation(KEY leftKey, KEY rightKey, KEY bubbleKey) {
        this.leftKey = leftKey;
        this.rightKey = rightKey;
        this.bubbleKey = bubbleKey;
    }

    void clear() {
        this.hasLeftChildUpdate = false;
        this.hasRightChildUpdate = false;
        this.hasMidChildUpdate = false;
        this.hasRightKeyInsert = false;
        this.hasLeftKeyReplace = false;
        this.hasRightKeyReplace = false;
    }

    static enum KeyReplaceStrategy {
        REPLACE,
        BUBBLE;

    }

    static interface StructureUpdate {
        public void update(StructurePropagation var1, long var2);
    }
}

