/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.time.Clock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bouncycastle.operator.OperatorCreationException;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.BasicAuthentication;
import org.neo4j.bolt.security.ssl.Certificates;
import org.neo4j.bolt.security.ssl.KeyStoreFactory;
import org.neo4j.bolt.security.ssl.KeyStoreInformation;
import org.neo4j.bolt.transport.BoltProtocol;
import org.neo4j.bolt.transport.Netty4LoggerFactory;
import org.neo4j.bolt.transport.NettyServer;
import org.neo4j.bolt.transport.SocketTransport;
import org.neo4j.bolt.v1.runtime.BoltConnectionDescriptor;
import org.neo4j.bolt.v1.runtime.BoltFactory;
import org.neo4j.bolt.v1.runtime.BoltFactoryImpl;
import org.neo4j.bolt.v1.runtime.BoltWorker;
import org.neo4j.bolt.v1.runtime.MonitoredWorkerFactory;
import org.neo4j.bolt.v1.runtime.WorkerFactory;
import org.neo4j.bolt.v1.runtime.concurrent.ThreadedWorkerFactory;
import org.neo4j.bolt.v1.transport.BoltProtocolV1;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.Internal;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.UserManagerSupplier;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.udc.UsageData;

public class BoltKernelExtension
extends KernelExtensionFactory<Dependencies> {
    public BoltKernelExtension() {
        super("bolt-server");
    }

    public Lifecycle newInstance(KernelContext context, Dependencies dependencies) throws Throwable {
        Config config = dependencies.config();
        GraphDatabaseService gdb = dependencies.db();
        GraphDatabaseAPI api = (GraphDatabaseAPI)gdb;
        LogService logService = dependencies.logService();
        Clock clock = dependencies.clock();
        Log log = logService.getInternalLog(WorkerFactory.class);
        LifeSupport life = new LifeSupport();
        JobScheduler scheduler = dependencies.scheduler();
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Netty4LoggerFactory(logService.getInternalLogProvider()));
        Authentication authentication = this.authentication(dependencies.authManager(), dependencies.userManagerSupplier());
        BoltFactory boltFactory = (BoltFactory)life.add((Lifecycle)new BoltFactoryImpl(api, dependencies.usageData(), logService, dependencies.txBridge(), authentication, dependencies.sessionTracker(), config));
        WorkerFactory workerFactory = this.createWorkerFactory(boltFactory, scheduler, dependencies, logService, clock);
        List<NettyServer.ProtocolInitializer> connectors = config.enabledBoltConnectors().stream().map(connConfig -> {
            SslContext sslCtx;
            boolean requireEncryption;
            ListenSocketAddress listenAddress = (ListenSocketAddress)config.get(connConfig.listen_address);
            AdvertisedSocketAddress advertisedAddress = (AdvertisedSocketAddress)config.get(connConfig.advertised_address);
            BoltConnector.EncryptionLevel encryptionLevel = (BoltConnector.EncryptionLevel)config.get(connConfig.encryption_level);
            switch (encryptionLevel) {
                case REQUIRED: {
                    requireEncryption = true;
                    sslCtx = this.createSslContext(config, log, advertisedAddress);
                    break;
                }
                case OPTIONAL: {
                    requireEncryption = false;
                    sslCtx = this.createSslContext(config, log, advertisedAddress);
                    break;
                }
                case DISABLED: {
                    requireEncryption = false;
                    sslCtx = null;
                    break;
                }
                default: {
                    log.warn(String.format("Unhandled encryption level %s - assuming DISABLED.", encryptionLevel.name()));
                    requireEncryption = false;
                    sslCtx = null;
                }
            }
            Map<Long, BiFunction<Channel, Boolean, BoltProtocol>> versions = this.newVersions(logService, workerFactory);
            return new SocketTransport(listenAddress, sslCtx, requireEncryption, logService.getInternalLogProvider(), versions);
        }).collect(Collectors.toList());
        if (connectors.size() > 0 && !((Boolean)config.get(GraphDatabaseSettings.disconnected)).booleanValue()) {
            life.add((Lifecycle)new NettyServer(scheduler.threadFactory(JobScheduler.Groups.boltNetworkIO), connectors));
            log.info("Bolt Server extension loaded.");
            for (NettyServer.ProtocolInitializer connector : connectors) {
                logService.getUserLog(WorkerFactory.class).info("Bolt enabled on %s.", new Object[]{connector.address()});
            }
        }
        return life;
    }

    protected WorkerFactory createWorkerFactory(BoltFactory boltFactory, JobScheduler scheduler, Dependencies dependencies, LogService logService, Clock clock) {
        ThreadedWorkerFactory threadedWorkerFactory = new ThreadedWorkerFactory(boltFactory, scheduler, logService, clock);
        return new MonitoredWorkerFactory(dependencies.monitors(), threadedWorkerFactory, clock);
    }

    private SslContext createSslContext(Config config, Log log, AdvertisedSocketAddress address) {
        try {
            KeyStoreInformation keyStore = this.createKeyStore((Configuration)config, log, address);
            return SslContextBuilder.forServer((File)keyStore.getCertificatePath(), (File)keyStore.getPrivateKeyPath()).build();
        }
        catch (IOException | GeneralSecurityException | OperatorCreationException e) {
            throw new RuntimeException("Failed to initialize SSL encryption support, which is required to start this connector. Error was: " + e.getMessage(), e);
        }
    }

    private Map<Long, BiFunction<Channel, Boolean, BoltProtocol>> newVersions(LogService logging, WorkerFactory workerFactory) {
        HashMap<Long, BiFunction<Channel, Boolean, BoltProtocol>> availableVersions = new HashMap<Long, BiFunction<Channel, Boolean, BoltProtocol>>();
        availableVersions.put(1L, (channel, isEncrypted) -> {
            BoltConnectionDescriptor descriptor = new BoltConnectionDescriptor(channel.remoteAddress(), channel.localAddress());
            BoltWorker worker = workerFactory.newWorker(descriptor, () -> ((Channel)channel).close());
            return new BoltProtocolV1(worker, (Channel)channel, logging);
        });
        return availableVersions;
    }

    private KeyStoreInformation createKeyStore(Configuration config, Log log, AdvertisedSocketAddress address) throws GeneralSecurityException, IOException, OperatorCreationException {
        File privateKeyPath = ((File)config.get(Settings.tls_key_file)).getAbsoluteFile();
        File certificatePath = ((File)config.get(Settings.tls_certificate_file)).getAbsoluteFile();
        if (!certificatePath.exists() && !privateKeyPath.exists()) {
            log.info("No SSL certificate found, generating a self-signed certificate..");
            Certificates certFactory = new Certificates();
            certFactory.createSelfSignedCertificate(certificatePath, privateKeyPath, address.getHostname());
        }
        if (!certificatePath.exists()) {
            throw new IllegalStateException(String.format("TLS private key found, but missing certificate at '%s'. Cannot start server without certificate.", certificatePath));
        }
        if (!privateKeyPath.exists()) {
            throw new IllegalStateException(String.format("TLS certificate found, but missing key at '%s'. Cannot start server without key.", privateKeyPath));
        }
        return new KeyStoreFactory().createKeyStore(privateKeyPath, certificatePath);
    }

    private Authentication authentication(AuthManager authManager, UserManagerSupplier userManagerSupplier) {
        return new BasicAuthentication(authManager, userManagerSupplier);
    }

    public static interface Dependencies {
        public LogService logService();

        public Config config();

        public GraphDatabaseService db();

        public JobScheduler scheduler();

        public UsageData usageData();

        public Monitors monitors();

        public ThreadToStatementContextBridge txBridge();

        public BoltConnectionTracker sessionTracker();

        public Clock clock();

        public AuthManager authManager();

        public UserManagerSupplier userManagerSupplier();
    }

    public static class Settings {
        @Description(value="Directory for storing certificates to be used by Neo4j for TLS connections")
        public static Setting<File> certificates_directory = org.neo4j.kernel.configuration.Settings.pathSetting((String)"dbms.directories.certificates", (String)"certificates");
        @Internal
        @Description(value="Path to the X.509 public certificate to be used by Neo4j for TLS connections")
        public static Setting<File> tls_certificate_file = org.neo4j.kernel.configuration.Settings.derivedSetting((String)"unsupported.dbms.security.tls_certificate_file", certificates_directory, certificates -> new File((File)certificates, "neo4j.cert"), (Function)org.neo4j.kernel.configuration.Settings.PATH);
        @Internal
        @Description(value="Path to the X.509 private key to be used by Neo4j for TLS connections")
        public static final Setting<File> tls_key_file = org.neo4j.kernel.configuration.Settings.derivedSetting((String)"unsupported.dbms.security.tls_key_file", certificates_directory, certificates -> new File((File)certificates, "neo4j.key"), (Function)org.neo4j.kernel.configuration.Settings.PATH);
    }
}

