/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.Map;
import org.neo4j.bolt.v1.messaging.BoltResponseMessage;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageBoundaryHook;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageHandler;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.runtime.spi.Record;
import org.neo4j.kernel.api.exceptions.Status;

public class BoltResponseMessageWriter
implements BoltResponseMessageHandler<IOException> {
    public static final BoltResponseMessageBoundaryHook NO_BOUNDARY_HOOK = () -> {};
    private final Neo4jPack.Packer packer;
    private final BoltResponseMessageBoundaryHook onMessageComplete;

    public BoltResponseMessageWriter(Neo4jPack.Packer packer, BoltResponseMessageBoundaryHook onMessageComplete) {
        this.packer = packer;
        this.onMessageComplete = onMessageComplete;
    }

    @Override
    public void onRecord(Record item) throws IOException {
        Object[] fields = item.fields();
        this.packer.packStructHeader(1, BoltResponseMessage.RECORD.signature());
        this.packer.packListHeader(fields.length);
        for (Object field : fields) {
            this.packer.pack(field);
        }
        this.onMessageComplete.onMessageComplete();
        this.packer.consumeError();
    }

    @Override
    public void onSuccess(Map<String, Object> metadata) throws IOException {
        this.packer.packStructHeader(1, BoltResponseMessage.SUCCESS.signature());
        this.packer.packRawMap(metadata);
        this.onMessageComplete.onMessageComplete();
    }

    @Override
    public void onIgnored() throws IOException {
        this.packer.packStructHeader(0, BoltResponseMessage.IGNORED.signature());
        this.onMessageComplete.onMessageComplete();
    }

    @Override
    public void onFailure(Status status, String message) throws IOException {
        this.packer.packStructHeader(1, BoltResponseMessage.FAILURE.signature());
        this.packer.packMapHeader(2);
        this.packer.pack("code");
        this.packer.pack(status.code().serialize());
        this.packer.pack("message");
        this.packer.pack(message);
        this.onMessageComplete.onMessageComplete();
    }

    @Override
    public void onFatal(Status status, String message) throws IOException {
        this.onFailure(status, message);
        this.flush();
    }

    public void flush() throws IOException {
        this.packer.flush();
    }
}

