/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.bolt.v1.messaging.BoltIOException;
import org.neo4j.bolt.v1.messaging.PathPack;
import org.neo4j.bolt.v1.messaging.infrastructure.ValueNode;
import org.neo4j.bolt.v1.messaging.infrastructure.ValueRelationship;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.packstream.PackStream;
import org.neo4j.bolt.v1.packstream.PackType;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.api.exceptions.Status;

public class Neo4jPack {
    public static final List<Object> EMPTY_LIST = new ArrayList<Object>();
    public static final Map<String, Object> EMPTY_MAP = new HashMap<String, Object>();
    public static final byte NODE = 78;
    public static final byte RELATIONSHIP = 82;
    public static final byte UNBOUND_RELATIONSHIP = 114;
    public static final byte PATH = 80;

    private static class Error {
        private final Status status;
        private final String msg;

        private Error(Status status, String msg) {
            this.status = status;
            this.msg = msg;
        }

        Status status() {
            return this.status;
        }

        String msg() {
            return this.msg;
        }
    }

    public static class Unpacker
    extends PackStream.Unpacker {
        private List<Neo4jError> errors = new ArrayList<Neo4jError>(2);

        public Unpacker(PackInput input) {
            super(input);
        }

        public Object unpack() throws IOException {
            PackType valType = this.peekNextType();
            switch (valType) {
                case BYTES: {
                    return this.unpackBytes();
                }
                case STRING: {
                    return this.unpackString();
                }
                case INTEGER: {
                    return this.unpackLong();
                }
                case FLOAT: {
                    return this.unpackDouble();
                }
                case BOOLEAN: {
                    return this.unpackBoolean();
                }
                case NULL: {
                    this.unpackNull();
                    return null;
                }
                case LIST: {
                    return this.unpackList();
                }
                case MAP: {
                    return this.unpackMap();
                }
                case STRUCT: {
                    this.unpackStructHeader();
                    char signature = this.unpackStructSignature();
                    switch (signature) {
                        case 'N': {
                            throw new BoltIOException((Status)Status.Request.Invalid, "Nodes cannot be unpacked.");
                        }
                        case 'R': {
                            throw new BoltIOException((Status)Status.Request.Invalid, "Relationships cannot be unpacked.");
                        }
                        case 'r': {
                            throw new BoltIOException((Status)Status.Request.Invalid, "Relationships cannot be unpacked.");
                        }
                        case 'P': {
                            throw new BoltIOException((Status)Status.Request.Invalid, "Paths cannot be unpacked.");
                        }
                    }
                    throw new BoltIOException((Status)Status.Request.InvalidFormat, "Unknown struct type: " + Integer.toHexString(signature));
                }
                case END_OF_STREAM: {
                    this.unpackEndOfStream();
                    return null;
                }
            }
            throw new BoltIOException((Status)Status.Request.InvalidFormat, "Unknown value type: " + (Object)((Object)valType));
        }

        public List<Object> unpackList() throws IOException {
            ArrayList<Object> list;
            int size = (int)this.unpackListHeader();
            if (size == 0) {
                return EMPTY_LIST;
            }
            if ((long)size == -1L) {
                list = new ArrayList<Object>();
                boolean more = true;
                block3: while (more) {
                    PackType keyType = this.peekNextType();
                    switch (keyType) {
                        case END_OF_STREAM: {
                            this.unpack();
                            more = false;
                            continue block3;
                        }
                    }
                    list.add(this.unpack());
                }
            } else {
                list = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    list.add(this.unpack());
                }
            }
            return list;
        }

        public Map<String, Object> unpackMap() throws IOException {
            HashMap<String, Object> map;
            int size = (int)this.unpackMapHeader();
            if (size == 0) {
                return EMPTY_MAP;
            }
            if ((long)size == -1L) {
                map = new HashMap<String, Object>();
                boolean more = true;
                block9: while (more) {
                    PackType keyType = this.peekNextType();
                    switch (keyType) {
                        case END_OF_STREAM: {
                            this.unpack();
                            more = false;
                            continue block9;
                        }
                        case STRING: {
                            Object val;
                            String key = this.unpackString();
                            if (map.put(key, val = this.unpack()) == null) continue block9;
                            this.errors.add(Neo4jError.from((Status)Status.Request.Invalid, "Duplicate map key `" + key + "`."));
                            continue block9;
                        }
                        case NULL: {
                            this.errors.add(Neo4jError.from((Status)Status.Request.Invalid, "Value `null` is not supported as key in maps, must be a non-nullable string."));
                            this.unpackNull();
                            Object val = this.unpack();
                            map.put(null, val);
                            continue block9;
                        }
                    }
                    throw new PackStream.PackStreamException("Bad key type");
                }
            } else {
                map = new HashMap(size, 1.0f);
                for (int i = 0; i < size; ++i) {
                    String key;
                    PackType type = this.peekNextType();
                    switch (type) {
                        case NULL: {
                            this.errors.add(Neo4jError.from((Status)Status.Request.Invalid, "Value `null` is not supported as key in maps, must be a non-nullable string."));
                            this.unpackNull();
                            key = null;
                            break;
                        }
                        case STRING: {
                            key = this.unpackString();
                            break;
                        }
                        default: {
                            throw new PackStream.PackStreamException("Bad key type: " + (Object)((Object)type));
                        }
                    }
                    Object val = this.unpack();
                    if (map.put(key, val) == null) continue;
                    this.errors.add(Neo4jError.from((Status)Status.Request.Invalid, "Duplicate map key `" + key + "`."));
                }
            }
            return map;
        }

        public Optional<Neo4jError> consumeError() {
            if (this.errors.isEmpty()) {
                return Optional.empty();
            }
            Neo4jError combined = Neo4jError.combine(this.errors);
            this.errors.clear();
            return Optional.of(combined);
        }
    }

    public static class Packer
    extends PackStream.Packer {
        private PathPack.Packer pathPacker = new PathPack.Packer();
        private Optional<Error> error = Optional.empty();

        public Packer(PackOutput output) {
            super(output);
        }

        public void pack(Object obj) throws IOException {
            if (obj == null) {
                this.packNull();
            } else if (obj instanceof Boolean) {
                this.pack((Boolean)obj);
            } else if (obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Long) {
                this.pack(((Number)obj).longValue());
            } else if (obj instanceof Float || obj instanceof Double) {
                this.pack(((Number)obj).doubleValue());
            } else if (obj instanceof String) {
                this.pack((String)obj);
            } else if (obj instanceof Character) {
                this.pack(((Character)obj).charValue());
            } else if (obj instanceof Map) {
                Map map = (Map)obj;
                this.packMapHeader(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    Object key = entry.getKey();
                    if (key == null) {
                        this.error = Optional.of(new Error((Status)Status.Request.Invalid, "Value `null` is not supported as key in maps, must be a non-nullable string."));
                        this.packNull();
                        this.pack(entry.getValue());
                        continue;
                    }
                    this.pack(key.toString());
                    this.pack(entry.getValue());
                }
            } else if (obj instanceof Collection) {
                Collection list = (Collection)obj;
                this.packListHeader(list.size());
                for (Object item : list) {
                    this.pack(item);
                }
            } else if (obj instanceof byte[]) {
                this.pack((byte[])obj);
            } else if (obj instanceof char[]) {
                char[] array = (char[])obj;
                this.packListHeader(array.length);
                for (char item : array) {
                    this.pack(item);
                }
            } else if (obj instanceof short[]) {
                short[] array = (short[])obj;
                this.packListHeader(array.length);
                for (short item : array) {
                    this.pack(item);
                }
            } else if (obj instanceof int[]) {
                int[] array = (int[])obj;
                this.packListHeader(array.length);
                for (int item : array) {
                    this.pack(item);
                }
            } else if (obj instanceof long[]) {
                long[] array = (long[])obj;
                this.packListHeader(array.length);
                for (long item : array) {
                    this.pack(item);
                }
            } else if (obj instanceof float[]) {
                float[] array = (float[])obj;
                this.packListHeader(array.length);
                for (float item : array) {
                    this.pack(item);
                }
            } else if (obj instanceof double[]) {
                double[] array = (double[])obj;
                this.packListHeader(array.length);
                for (double item : array) {
                    this.pack(item);
                }
            } else if (obj instanceof boolean[]) {
                boolean[] array = (boolean[])obj;
                this.packListHeader(array.length);
                for (boolean item : array) {
                    this.pack(item);
                }
            } else if (obj.getClass().isArray()) {
                Object[] array = (Object[])obj;
                this.packListHeader(array.length);
                for (Object item : array) {
                    this.pack(item);
                }
            } else if (obj instanceof Node) {
                ValueNode.pack(this, (Node)obj);
            } else if (obj instanceof Relationship) {
                ValueRelationship.pack(this, (Relationship)obj);
            } else if (obj instanceof Path) {
                this.pathPacker.pack(this, (Path)obj);
            } else if (obj instanceof Point) {
                this.error = Optional.of(new Error((Status)Status.Request.Invalid, "Point is not yet supported as a return type in Bolt"));
                this.packNull();
            } else {
                this.error = Optional.of(new Error((Status)Status.Request.Invalid, "Unpackable value " + obj + " of type " + obj.getClass().getName()));
                this.packNull();
            }
        }

        public void packRawMap(Map<String, Object> map) throws IOException {
            this.packMapHeader(map.size());
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.pack(entry.getKey());
                this.pack(entry.getValue());
            }
        }

        public void consumeError() throws BoltIOException {
            if (this.error.isPresent()) {
                Error e = this.error.get();
                this.error = Optional.empty();
                throw new BoltIOException(e.status(), e.msg());
            }
        }

        public boolean hasErrors() {
            return this.error.isPresent();
        }
    }
}

