/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.util.Map;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.v1.runtime.BoltConnectionDescriptor;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.ErrorReporter;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.bolt.v1.runtime.TransactionStateMachine;
import org.neo4j.concurrent.RecentK;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.api.bolt.ManagedBoltStateMachine;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.internal.Version;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

class BoltStateMachineSPI
implements BoltStateMachine.SPI {
    private final BoltConnectionDescriptor connectionDescriptor;
    private final UsageData usageData;
    private final ErrorReporter errorReporter;
    private final BoltConnectionTracker connectionTracker;
    private final Authentication authentication;
    private final String version;
    private final TransactionStateMachine.SPI transactionSpi;

    BoltStateMachineSPI(BoltConnectionDescriptor connectionDescriptor, UsageData usageData, LogService logging, Authentication authentication, BoltConnectionTracker connectionTracker, TransactionStateMachine.SPI transactionStateMachineSPI) {
        this.connectionDescriptor = connectionDescriptor;
        this.usageData = usageData;
        this.errorReporter = new ErrorReporter(logging);
        this.connectionTracker = connectionTracker;
        this.authentication = authentication;
        this.transactionSpi = transactionStateMachineSPI;
        this.version = "Neo4j/" + Version.getNeo4jVersion();
    }

    @Override
    public BoltConnectionDescriptor connectionDescriptor() {
        return this.connectionDescriptor;
    }

    @Override
    public void register(BoltStateMachine machine, String owner) {
        this.connectionTracker.onRegister((ManagedBoltStateMachine)machine, owner);
    }

    @Override
    public TransactionStateMachine.SPI transactionSpi() {
        return this.transactionSpi;
    }

    @Override
    public void onTerminate(BoltStateMachine machine) {
        this.connectionTracker.onTerminate((ManagedBoltStateMachine)machine);
    }

    @Override
    public void reportError(Neo4jError err) {
        this.errorReporter.report(err);
    }

    @Override
    public AuthenticationResult authenticate(Map<String, Object> authToken) throws AuthenticationException {
        return this.authentication.authenticate(authToken);
    }

    @Override
    public void udcRegisterClient(String clientName) {
        ((RecentK)this.usageData.get(UsageDataKeys.clientNames)).add((Object)clientName);
    }

    @Override
    public String version() {
        return this.version;
    }
}

