/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.bookmarking;

import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;

public class Bookmark {
    private static final String BOOKMARK_TX_PREFIX = "neo4j:bookmark:v1:tx";
    private final long txId;

    public Bookmark(long txId) {
        this.txId = txId;
    }

    public String toString() {
        return String.format("neo4j:bookmark:v1:tx%d", this.txId);
    }

    public static Bookmark fromString(String bookmarkString) throws BookmarkFormatException {
        if (bookmarkString != null && bookmarkString.startsWith(BOOKMARK_TX_PREFIX)) {
            try {
                return new Bookmark(Long.parseLong(bookmarkString.substring(BOOKMARK_TX_PREFIX.length())));
            }
            catch (NumberFormatException e) {
                throw new BookmarkFormatException(bookmarkString, e);
            }
        }
        throw new BookmarkFormatException(bookmarkString);
    }

    public long txId() {
        return this.txId;
    }

    static class BookmarkFormatException
    extends KernelException {
        BookmarkFormatException(String bookmarkString, NumberFormatException e) {
            super((Status)Status.Transaction.InvalidBookmark, (Throwable)e, "Supplied bookmark [%s] does not conform to pattern %s; unable to parse transaction id", new Object[]{bookmarkString, Bookmark.BOOKMARK_TX_PREFIX});
        }

        BookmarkFormatException(String bookmarkString) {
            super((Status)Status.Transaction.InvalidBookmark, "Supplied bookmark [%s] does not conform to pattern %s", new Object[]{bookmarkString, Bookmark.BOOKMARK_TX_PREFIX});
        }
    }
}

