/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageBoundaryHook;
import org.neo4j.bolt.v1.packstream.PackOutput;

public class ChunkedOutput
implements PackOutput,
BoltResponseMessageBoundaryHook {
    public static final int CHUNK_HEADER_SIZE = 2;
    public static final int MESSAGE_BOUNDARY = 0;
    private final int bufferSize;
    private final int maxChunkSize;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private ByteBuf buffer;
    private Channel channel;
    private int currentChunkHeaderOffset;
    private boolean chunkOpen = false;

    public ChunkedOutput(Channel ch, int bufferSize) {
        this.channel = ch;
        this.bufferSize = Math.max(16, bufferSize);
        this.maxChunkSize = this.bufferSize - 2;
        this.buffer = this.channel.alloc().buffer(this.bufferSize, this.bufferSize);
    }

    @Override
    public synchronized PackOutput flush() throws IOException {
        if (this.buffer != null && this.buffer.readableBytes() > 0) {
            this.closeChunkIfOpen();
            ByteBuf out = this.buffer;
            this.buffer = null;
            this.channel.writeAndFlush((Object)out, this.channel.voidPromise());
            this.newBuffer();
        }
        return this;
    }

    @Override
    public synchronized PackOutput writeByte(byte value) throws IOException {
        this.ensure(1);
        this.buffer.writeByte((int)value);
        return this;
    }

    @Override
    public synchronized PackOutput writeShort(short value) throws IOException {
        this.ensure(2);
        this.buffer.writeShort((int)value);
        return this;
    }

    @Override
    public synchronized PackOutput writeInt(int value) throws IOException {
        this.ensure(4);
        this.buffer.writeInt(value);
        return this;
    }

    @Override
    public synchronized PackOutput writeLong(long value) throws IOException {
        this.ensure(8);
        this.buffer.writeLong(value);
        return this;
    }

    @Override
    public synchronized PackOutput writeDouble(double value) throws IOException {
        this.ensure(8);
        this.buffer.writeDouble(value);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackOutput writeBytes(ByteBuffer data) throws IOException {
        while (data.remaining() > 0) {
            this.ensure(1);
            int oldLimit = data.limit();
            ChunkedOutput chunkedOutput = this;
            synchronized (chunkedOutput) {
                data.limit(data.position() + Math.min(this.buffer.writableBytes(), data.remaining()));
                this.buffer.writeBytes(data);
            }
            data.limit(oldLimit);
        }
        return this;
    }

    @Override
    public PackOutput writeBytes(byte[] data, int offset, int length) throws IOException {
        if (offset + length > data.length) {
            throw new IOException("Asked to write " + length + " bytes, but there is only " + (data.length - offset) + " bytes available in data provided.");
        }
        return this.writeBytes(ByteBuffer.wrap(data, offset, length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensure(int size) throws IOException {
        assert (size <= this.maxChunkSize) : size + " > " + this.maxChunkSize;
        if (this.closed.get()) {
            throw new IOException("Cannot write to buffer when closed");
        }
        int toWriteSize = this.chunkOpen ? size : size + 2;
        ChunkedOutput chunkedOutput = this;
        synchronized (chunkedOutput) {
            if (this.buffer.writableBytes() < toWriteSize) {
                this.flush();
            }
            if (!this.chunkOpen) {
                this.currentChunkHeaderOffset = this.buffer.writerIndex();
                this.buffer.writerIndex(this.buffer.writerIndex() + 2);
                this.chunkOpen = true;
            }
        }
    }

    private synchronized void closeChunkIfOpen() {
        if (this.chunkOpen) {
            int chunkSize = this.buffer.writerIndex() - (this.currentChunkHeaderOffset + 2);
            this.buffer.setShort(this.currentChunkHeaderOffset, chunkSize);
            this.chunkOpen = false;
        }
    }

    private void newBuffer() {
        this.buffer = this.channel.alloc().buffer(this.bufferSize, this.bufferSize);
        this.chunkOpen = false;
    }

    public synchronized void close() {
        if (this.buffer != null) {
            try {
                this.flush();
            }
            catch (IOException iOException) {
            }
            finally {
                this.closed.set(true);
                this.buffer.release();
                this.buffer = null;
            }
        }
    }

    @Override
    public synchronized void onMessageComplete() throws IOException {
        this.closeChunkIfOpen();
        if (this.buffer.writableBytes() < 2) {
            this.flush();
        }
        this.buffer.writeShort(0);
        this.chunkOpen = false;
    }
}

