/*
 * Decompiled with CFR 0.152.
 */
package org.structr.transform;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.util.Iterables;
import org.structr.common.GraphObjectComparator;
import org.structr.common.ResultTransformer;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.Result;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.EndNodes;
import org.structr.core.property.IntProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.core.script.Scripting;
import org.structr.schema.action.ActionContext;
import org.structr.transform.Transformation;
import org.structr.transform.VirtualProperty;
import org.structr.transform.VirtualTypeProperty;

public class VirtualType
extends AbstractNode
implements ResultTransformer {
    private static final Logger logger = LoggerFactory.getLogger((String)VirtualType.class.getName());
    public static final Property<List<VirtualProperty>> properties = new EndNodes("properties", VirtualTypeProperty.class);
    public static final Property<Integer> position = new IntProperty("position").indexed();
    public static final Property<String> sourceType = new StringProperty("sourceType");
    public static final Property<String> filterExpression = new StringProperty("filterExpression");
    public static final View defaultView = new View(VirtualType.class, "public", new Property[]{name, sourceType, position, properties, filterExpression});
    public static final View uiView = new View(VirtualType.class, "ui", new Property[]{name, sourceType, position, properties, filterExpression});

    public String getSourceType() {
        return (String)this.getProperty((PropertyKey)sourceType);
    }

    public Result transformOutput(SecurityContext securityContext, Class sourceType, Result result) throws FrameworkException {
        List<VirtualProperty> props = this.sort((List)this.getProperty((PropertyKey)properties));
        Mapper mapper = new Mapper(securityContext, props, this.entityType);
        Filter filter = new Filter(securityContext, (String)this.getProperty((PropertyKey)filterExpression));
        Iterable iterable = Iterables.map((Function)mapper, (Iterable)Iterables.filter((Predicate)filter, (Iterable)result.getResults()));
        List transformedResult = Iterables.toList((Iterable)iterable);
        return new Result(transformedResult, Integer.valueOf(transformedResult.size()), result.isCollection(), result.isPrimitiveArray());
    }

    public void transformInput(SecurityContext securityContext, Class type, Map<String, Object> propertySet) throws FrameworkException {
        ActionContext actionContext = new ActionContext(securityContext);
        List<VirtualProperty> props = this.sort((List)this.getProperty((PropertyKey)properties));
        for (VirtualProperty property : props) {
            Transformation transformation = property.getTransformation(type);
            transformation.transformInput(actionContext, propertySet);
        }
    }

    public boolean isPrimitiveArray() {
        return false;
    }

    private List<VirtualProperty> sort(List<VirtualProperty> source) {
        Collections.sort(source, new GraphObjectComparator(VirtualProperty.position, false));
        return source;
    }

    private static class Mapper
    implements Function<GraphObject, GraphObject> {
        private final List<Transformation> transformations = new LinkedList<Transformation>();
        private ActionContext actionContext = null;

        public Mapper(SecurityContext securityContext, List<VirtualProperty> properties, Class type) throws FrameworkException {
            this.actionContext = new ActionContext(securityContext);
            for (VirtualProperty property : properties) {
                Transformation transformation = property.getTransformation(type);
                if (transformation == null) continue;
                this.transformations.add(transformation);
            }
        }

        @Override
        public GraphObject apply(GraphObject source) {
            GraphObjectMap obj = new GraphObjectMap();
            try {
                for (Transformation transformation : this.transformations) {
                    PropertyKey targetProperty = transformation.getTargetProperty();
                    obj.put(targetProperty, transformation.transformOutput(this.actionContext, source));
                }
            }
            catch (FrameworkException ex) {
                logger.error("", (Throwable)ex);
            }
            return obj;
        }
    }

    private static class Filter
    implements Predicate<GraphObject> {
        private ActionContext ctx = null;
        private String expression = null;

        public Filter(SecurityContext securityContext, String expression) {
            this.ctx = new ActionContext(securityContext);
            this.expression = expression;
        }

        public boolean accept(GraphObject value) {
            if (StringUtils.isNotBlank((String)this.expression)) {
                try {
                    return Boolean.TRUE.equals(Scripting.evaluate((ActionContext)this.ctx, (GraphObject)value, (String)("${" + this.expression + "}"), (String)"virtual type filter"));
                }
                catch (FrameworkException fex) {
                    logger.warn("", (Throwable)fex);
                }
            }
            return true;
        }
    }
}

