/*
 * Decompiled with CFR 0.152.
 */
package org.structr.bolt.index;

import java.util.Iterator;
import java.util.function.Function;
import org.structr.api.QueryResult;
import org.structr.api.graph.Relationship;
import org.structr.api.util.Iterables;
import org.structr.bolt.BoltDatabaseService;
import org.structr.bolt.SessionTransaction;
import org.structr.bolt.index.AbstractCypherIndex;
import org.structr.bolt.index.CypherQuery;
import org.structr.bolt.mapper.RelationshipRelationshipMapper;

public class CypherRelationshipIndex
extends AbstractCypherIndex<Relationship> {
    public CypherRelationshipIndex(BoltDatabaseService db, int queryCacheSize) {
        super(db, queryCacheSize);
    }

    @Override
    public String getQueryPrefix(String typeLabel, String sourceTypeLabel, String targetTypeLabel) {
        if (typeLabel != null) {
            if (sourceTypeLabel != null && targetTypeLabel != null) {
                return "MATCH (:" + sourceTypeLabel + ")-[n: " + typeLabel + "]->(: " + targetTypeLabel + ")";
            }
            return "MATCH ()-[n: " + typeLabel + "]-()";
        }
        return "MATCH ()-[n]-()";
    }

    @Override
    public String getQuerySuffix() {
        return " RETURN DISTINCT n";
    }

    @Override
    public QueryResult<Relationship> getResult(CypherQuery context) {
        SessionTransaction tx = this.db.getCurrentTransaction();
        RelationshipRelationshipMapper mapper = new RelationshipRelationshipMapper(this.db);
        final Iterable mapped = Iterables.map((Function)mapper, tx.getRelationships(context.getStatement(), context.getParameters()));
        return new QueryResult<Relationship>(){

            public void close() {
            }

            public Iterator<Relationship> iterator() {
                return mapped.iterator();
            }
        };
    }
}

