/*
 * Decompiled with CFR 0.152.
 */
package org.structr.bolt.index.factory;

import org.structr.api.search.Occurrence;
import org.structr.api.search.TypeConverter;
import org.structr.bolt.index.AbstractCypherIndex;
import org.structr.bolt.index.CypherQuery;
import org.structr.bolt.index.factory.QueryFactory;

public abstract class AbstractQueryFactory
implements QueryFactory {
    protected Object getReadValue(Object value) {
        if (value != null) {
            TypeConverter converter = AbstractCypherIndex.CONVERTERS.get(value.getClass());
            if (converter != null) {
                return converter.getReadValue(value);
            }
            if (value.getClass().isEnum()) {
                return value.toString();
            }
        }
        return value;
    }

    protected Object getWriteValue(Object value) {
        TypeConverter converter;
        if (value != null && (converter = AbstractCypherIndex.CONVERTERS.get(value.getClass())) != null) {
            return converter.getWriteValue(value);
        }
        return value;
    }

    protected void checkOccur(CypherQuery query, Occurrence occ, boolean first) {
        if (!first || occ.equals((Object)Occurrence.FORBIDDEN)) {
            this.addOccur(query, occ, first);
        }
    }

    protected void addOccur(CypherQuery query, Occurrence occ, boolean first) {
        switch (occ) {
            case FORBIDDEN: {
                if (first) {
                    query.not();
                    break;
                }
                query.andNot();
                break;
            }
            case OPTIONAL: {
                query.or();
                break;
            }
            default: {
                query.and();
            }
        }
    }
}

