/*
 * Decompiled with CFR 0.152.
 */
package org.structr.bolt.index.factory;

import java.util.HashMap;
import java.util.Map;
import org.structr.api.search.QueryPredicate;
import org.structr.bolt.index.CypherQuery;
import org.structr.bolt.index.factory.AbstractQueryFactory;
import org.structr.bolt.index.factory.QueryFactory;

public class KeywordQueryFactory
extends AbstractQueryFactory {
    protected static final Map<Character, String> SPECIAL_CHARS = new HashMap<Character, String>();

    @Override
    public boolean createQuery(QueryFactory parent, QueryPredicate predicate, CypherQuery query, boolean isFirst) {
        boolean isString = predicate.getType().equals(String.class);
        Object value = this.getReadValue(predicate.getValue());
        String name = predicate.getName();
        this.checkOccur(query, predicate.getOccurrence(), isFirst);
        if (predicate.isExactMatch() || !isString) {
            if (isString && value == null) {
                query.beginGroup();
                query.addSimpleParameter(name, "is", null);
                query.or();
                query.addSimpleParameter(name, "=", "");
                query.endGroup();
            } else {
                query.addSimpleParameter(name, value != null ? "=" : "is", value);
            }
        } else if (value != null && isString) {
            query.addSimpleParameter(name, "=~", "(?i).*" + this.escape(value) + ".*");
        } else {
            query.beginGroup();
            query.addSimpleParameter(name, "is", null);
            query.or();
            query.addSimpleParameter(name, "=", "");
            query.endGroup();
        }
        return true;
    }

    protected String escape(Object src) {
        StringBuilder output = new StringBuilder();
        String input = src.toString();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            String prefix = SPECIAL_CHARS.get(Character.valueOf(c));
            if (prefix != null) {
                output.append(prefix);
            }
            output.append(c);
        }
        return output.toString();
    }

    static {
        SPECIAL_CHARS.put(Character.valueOf('+'), "\\");
        SPECIAL_CHARS.put(Character.valueOf('-'), "\\");
        SPECIAL_CHARS.put(Character.valueOf('*'), ".");
        SPECIAL_CHARS.put(Character.valueOf('?'), ".");
        SPECIAL_CHARS.put(Character.valueOf('~'), "\\");
        SPECIAL_CHARS.put(Character.valueOf('.'), "\\");
        SPECIAL_CHARS.put(Character.valueOf('('), "\\");
        SPECIAL_CHARS.put(Character.valueOf(')'), "\\");
        SPECIAL_CHARS.put(Character.valueOf('{'), "\\");
        SPECIAL_CHARS.put(Character.valueOf('}'), "\\");
        SPECIAL_CHARS.put(Character.valueOf('['), "\\");
        SPECIAL_CHARS.put(Character.valueOf(']'), "\\");
        SPECIAL_CHARS.put(Character.valueOf(':'), "\\");
        SPECIAL_CHARS.put(Character.valueOf('^'), "\\");
        SPECIAL_CHARS.put(Character.valueOf('&'), "\\");
        SPECIAL_CHARS.put(Character.valueOf('|'), "\\");
    }
}

