/*
 * Decompiled with CFR 0.152.
 */
package org.structr.bolt.wrapper;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.driver.v1.exceptions.NoSuchRecordException;
import org.neo4j.driver.v1.types.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.NotFoundException;
import org.structr.api.NotInTransactionException;
import org.structr.api.graph.PropertyContainer;
import org.structr.api.util.Cachable;
import org.structr.bolt.BoltDatabaseService;
import org.structr.bolt.SessionTransaction;

public abstract class EntityWrapper<T extends Entity>
implements PropertyContainer,
Cachable {
    private static final Logger logger = LoggerFactory.getLogger((String)EntityWrapper.class.getName());
    protected final Map<String, Object> data = new ConcurrentHashMap<String, Object>();
    protected BoltDatabaseService db = null;
    protected boolean stale = false;
    protected long id = -1L;

    public EntityWrapper(BoltDatabaseService db, T entity) {
        this.data.putAll(entity.asMap());
        this.id = entity.id();
        this.db = db;
    }

    protected abstract String getQueryPrefix();

    public abstract void clearCaches();

    public long getId() {
        return this.id;
    }

    public boolean hasProperty(String name) {
        this.assertNotStale();
        return this.data.containsKey(name);
    }

    public Object getProperty(String name) {
        this.assertNotStale();
        Object value = this.data.get(name);
        if (value instanceof List) {
            try {
                List list = (List)value;
                if (!list.isEmpty()) {
                    Object firstElement = ((List)value).get(0);
                    Object[] arr = (Object[])Array.newInstance(firstElement.getClass(), 0);
                    return ((List)value).toArray(arr);
                }
                return null;
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
        }
        return value;
    }

    public Object getProperty(String name, Object defaultValue) {
        this.assertNotStale();
        Object value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public void setProperty(String key, Object value) {
        this.assertNotStale();
        SessionTransaction tx = this.db.getCurrentTransaction();
        if (this.differentValue(key, value)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String query = this.getQueryPrefix() + " WHERE ID(n) = {id} SET n.`" + key + "` = {value}";
            map.put("id", this.id);
            map.put("value", value);
            tx.set(query, map);
            this.update(key, value);
        }
        tx.modified(this);
    }

    public void setProperties(Map<String, Object> values) {
        this.assertNotStale();
        SessionTransaction tx = this.db.getCurrentTransaction();
        HashMap<String, Object> map = new HashMap<String, Object>(values);
        String query = this.getQueryPrefix() + " WHERE ID(n) = {id} SET n += {properties}";
        map.put("id", this.id);
        map.put("properties", values);
        tx.set(query, map);
        this.update(values);
        tx.modified(this);
    }

    public void removeProperty(String key) {
        this.assertNotStale();
        SessionTransaction tx = this.db.getCurrentTransaction();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String query = this.getQueryPrefix() + " WHERE ID(n) = {id} SET n.`" + key + "` = Null";
        map.put("id", this.id);
        tx.set(query, map);
        this.data.remove(key);
        tx.modified(this);
    }

    public Iterable<String> getPropertyKeys() {
        this.assertNotStale();
        return this.data.keySet();
    }

    public void delete() throws NotInTransactionException {
        this.assertNotStale();
        SessionTransaction tx = this.db.getCurrentTransaction();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.id);
        tx.set(this.getQueryPrefix() + " WHERE ID(n) = {id} DELETE n", map);
        tx.modified(this);
        this.stale = true;
    }

    public boolean isSpatialEntity() {
        return false;
    }

    public boolean isStale() {
        return this.stale;
    }

    public void stale() {
        this.stale = true;
    }

    protected synchronized void assertNotStale() {
        if (this.stale) {
            this.onRemoveFromCache();
            SessionTransaction tx = this.db.getCurrentTransaction();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", this.id);
            try {
                this.data.clear();
                this.update(tx.getEntity(this.getQueryPrefix() + " WHERE ID(n) = {id} RETURN n", map).asMap());
            }
            catch (NoSuchRecordException nex) {
                throw new NotFoundException((Throwable)nex);
            }
            this.stale = false;
        }
    }

    private void update(Map<String, Object> values) {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            this.update(entry.getKey(), entry.getValue());
        }
    }

    private void update(String key, Object value) {
        if (value != null) {
            this.data.put(key, value);
        } else {
            this.data.remove(key);
        }
    }

    private boolean differentValue(String key, Object value) {
        if (value == null && !this.data.containsKey(key)) {
            return false;
        }
        return value == null || !value.equals(this.data.get(key));
    }
}

