/*
 * Decompiled with CFR 0.152.
 */
package org.structr.bolt.wrapper;

import java.util.HashMap;
import org.structr.api.NotFoundException;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.api.graph.RelationshipType;
import org.structr.api.util.FixedSizeCache;
import org.structr.bolt.BoltDatabaseService;
import org.structr.bolt.SessionTransaction;
import org.structr.bolt.wrapper.EntityWrapper;
import org.structr.bolt.wrapper.NodeWrapper;

public class RelationshipWrapper
extends EntityWrapper<org.neo4j.driver.v1.types.Relationship>
implements Relationship {
    private static FixedSizeCache<Long, RelationshipWrapper> relationshipCache = null;
    private long sourceNodeId = -1L;
    private long targetNodeId = -1L;
    private String type = null;

    private RelationshipWrapper(BoltDatabaseService db, org.neo4j.driver.v1.types.Relationship relationship) {
        super(db, relationship);
        this.sourceNodeId = relationship.startNodeId();
        this.targetNodeId = relationship.endNodeId();
        this.type = relationship.type();
    }

    public static void initialize(int cacheSize) {
        relationshipCache = new FixedSizeCache(cacheSize);
    }

    @Override
    protected String getQueryPrefix() {
        return "MATCH ()-[n]-()";
    }

    public void onRemoveFromCache() {
        try {
            NodeWrapper endNode;
            NodeWrapper startNode = (NodeWrapper)this.getStartNode();
            if (startNode != null) {
                startNode.onRemoveFromCache();
            }
            if ((endNode = (NodeWrapper)this.getEndNode()) != null) {
                endNode.onRemoveFromCache();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.stale = true;
    }

    @Override
    public void clearCaches() {
    }

    public Node getStartNode() {
        try {
            return this.db.getNodeById(this.sourceNodeId);
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
    }

    public Node getEndNode() {
        try {
            return this.db.getNodeById(this.targetNodeId);
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
    }

    public Node getOtherNode(Node node) {
        if (node.getId() == this.sourceNodeId) {
            return this.getEndNode();
        }
        return this.getStartNode();
    }

    public RelationshipType getType() {
        return this.db.forName(RelationshipType.class, this.type);
    }

    @Override
    public void delete() {
        NodeWrapper endNode;
        super.delete();
        relationshipCache.remove((Object)this.id);
        NodeWrapper startNode = (NodeWrapper)this.getStartNode();
        if (startNode != null) {
            startNode.clearCaches();
        }
        if ((endNode = (NodeWrapper)this.getEndNode()) != null) {
            endNode.clearCaches();
        }
    }

    public static void clearCache() {
        relationshipCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RelationshipWrapper newInstance(BoltDatabaseService db, org.neo4j.driver.v1.types.Relationship relationship) {
        FixedSizeCache<Long, RelationshipWrapper> fixedSizeCache = relationshipCache;
        synchronized (fixedSizeCache) {
            RelationshipWrapper wrapper = (RelationshipWrapper)relationshipCache.get((Object)relationship.id());
            if (wrapper == null) {
                wrapper = new RelationshipWrapper(db, relationship);
                relationshipCache.put((Object)relationship.id(), (Object)wrapper);
            }
            return wrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RelationshipWrapper newInstance(BoltDatabaseService db, long id) {
        FixedSizeCache<Long, RelationshipWrapper> fixedSizeCache = relationshipCache;
        synchronized (fixedSizeCache) {
            RelationshipWrapper wrapper = (RelationshipWrapper)relationshipCache.get((Object)id);
            if (wrapper == null) {
                SessionTransaction tx = db.getCurrentTransaction();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", id);
                wrapper = new RelationshipWrapper(db, tx.getRelationship("MATCH ()-[n]-() WHERE ID(n) = {id} RETURN n", map));
                relationshipCache.put((Object)id, (Object)wrapper);
            }
            return wrapper;
        }
    }
}

