/*
 * Decompiled with CFR 0.152.
 */
package org.structr.bolt.wrapper;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.driver.v1.Records;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.TransientException;
import org.structr.api.NativeResult;
import org.structr.api.RetryException;
import org.structr.api.util.Iterables;
import org.structr.bolt.BoltDatabaseService;
import org.structr.bolt.wrapper.MapResultWrapper;
import org.structr.bolt.wrapper.MixedResultWrapper;

public class StatementResultWrapper<T>
implements NativeResult<T> {
    private MixedResultWrapper wrapper = null;
    private StatementResult result = null;
    private BoltDatabaseService db = null;

    public StatementResultWrapper(BoltDatabaseService db, StatementResult result) {
        this.wrapper = new MixedResultWrapper(db);
        this.result = result;
        this.db = db;
    }

    public Iterator columnAs(String name) {
        Iterator it = this.result.list(Records.column((String)name)).iterator();
        return Iterables.map((Function)new Function<Value, Object>(){

            @Override
            public Object apply(Value t) {
                return StatementResultWrapper.this.wrapper.apply(t.asObject());
            }
        }, it);
    }

    public boolean hasNext() {
        try {
            return this.result.hasNext();
        }
        catch (TransientException tex) {
            this.db.getCurrentTransaction().setClosed(true);
            throw new RetryException((Throwable)tex);
        }
    }

    public Map next() {
        return new MapResultWrapper(this.db, this.result.next().asMap());
    }

    public void close() {
    }
}

