/*
 * Decompiled with CFR 0.152.
 */
package org.structr.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.console.rest.RestCommand;
import org.structr.console.shell.AdminConsoleCommand;
import org.structr.console.tabcompletion.AdminTabCompletionProvider;
import org.structr.console.tabcompletion.CypherTabCompletionProvider;
import org.structr.console.tabcompletion.JavaScriptTabCompletionProvider;
import org.structr.console.tabcompletion.RestTabCompletionProvider;
import org.structr.console.tabcompletion.StructrScriptTabCompletionProvider;
import org.structr.console.tabcompletion.TabCompletionProvider;
import org.structr.console.tabcompletion.TabCompletionResult;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.Principal;
import org.structr.core.function.Functions;
import org.structr.core.graph.Tx;
import org.structr.core.script.StructrScriptable;
import org.structr.schema.action.ActionContext;
import org.structr.util.Writable;

public class Console {
    private final Map<ConsoleMode, TabCompletionProvider> tabCompletionProviders = new HashMap<ConsoleMode, TabCompletionProvider>();
    private ConsoleMode mode = ConsoleMode.JavaScript;
    private StructrScriptable scriptable = null;
    private ActionContext actionContext = null;
    private ScriptableObject scope = null;
    private String username = null;
    private String password = null;

    public Console(SecurityContext securityContext, Map<String, Object> parameters) {
        this(securityContext, ConsoleMode.JavaScript, parameters);
    }

    public Console(SecurityContext securityContext, ConsoleMode consoleMode, Map<String, Object> parameters) {
        this.actionContext = new ActionContext(securityContext, parameters);
        this.mode = consoleMode;
        this.tabCompletionProviders.put(ConsoleMode.Cypher, new CypherTabCompletionProvider());
        this.tabCompletionProviders.put(ConsoleMode.JavaScript, new JavaScriptTabCompletionProvider());
        this.tabCompletionProviders.put(ConsoleMode.StructrScript, new StructrScriptTabCompletionProvider());
        this.tabCompletionProviders.put(ConsoleMode.AdminShell, new AdminTabCompletionProvider());
        this.tabCompletionProviders.put(ConsoleMode.REST, new RestTabCompletionProvider());
    }

    public String runForTest(String line) throws FrameworkException {
        PrintWritable writable = new PrintWritable();
        try {
            this.run(line, writable);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writable.getBuffer();
    }

    public void run(String line, Writable output) throws FrameworkException, IOException {
        if (line.startsWith("Console.getMode()")) {
            output.println(new Object[]{"Mode is '" + this.getMode() + "'."});
        } else if (line.startsWith("Console.setMode('" + ConsoleMode.JavaScript.name() + "')") || line.startsWith("Console.setMode(\"" + ConsoleMode.JavaScript.name() + "\")")) {
            this.mode = ConsoleMode.JavaScript;
            output.println(new Object[]{"Mode set to '" + ConsoleMode.JavaScript.name() + "'."});
        } else if (line.startsWith("Console.setMode('" + ConsoleMode.Cypher.name() + "')") || line.startsWith("Console.setMode(\"" + ConsoleMode.Cypher.name() + "\")")) {
            this.mode = ConsoleMode.Cypher;
            output.println(new Object[]{"Mode set to '" + ConsoleMode.Cypher.name() + "'."});
        } else if (line.startsWith("Console.setMode('" + ConsoleMode.StructrScript.name() + "')") || line.startsWith("Console.setMode(\"" + ConsoleMode.StructrScript.name() + "\")")) {
            this.mode = ConsoleMode.StructrScript;
            output.println(new Object[]{"Mode set to '" + ConsoleMode.StructrScript.name() + "'."});
        } else if (line.startsWith("Console.setMode('" + ConsoleMode.AdminShell.name() + "')") || line.startsWith("Console.setMode(\"" + ConsoleMode.AdminShell.name() + "\")")) {
            this.mode = ConsoleMode.AdminShell;
            output.println(new Object[]{"Mode set to '" + ConsoleMode.AdminShell.name() + "'. Type 'help' to get a list of commands."});
        } else if (line.startsWith("Console.setMode('" + ConsoleMode.REST.name() + "')") || line.startsWith("Console.setMode(\"" + ConsoleMode.REST.name() + "\")")) {
            this.mode = ConsoleMode.REST;
            output.println(new Object[]{"Mode set to '" + ConsoleMode.REST.name() + "'. Type 'help' to get a list of commands."});
        } else {
            switch (this.mode) {
                case Cypher: {
                    this.runCypher(line, output);
                    break;
                }
                case JavaScript: {
                    this.runJavascript(line, output);
                    break;
                }
                case StructrScript: {
                    this.runStructrScript(line, output);
                    break;
                }
                case AdminShell: {
                    this.runAdminShell(line, output);
                    break;
                }
                case REST: {
                    RestCommand.run(this, line, output);
                }
            }
        }
    }

    public List<TabCompletionResult> getTabCompletion(String line) {
        TabCompletionProvider provider = this.tabCompletionProviders.get((Object)this.mode);
        if (provider != null) {
            return provider.getTabCompletion(this.actionContext.getSecurityContext(), line);
        }
        return Collections.emptyList();
    }

    public SecurityContext getSecurityContext() {
        return this.actionContext.getSecurityContext();
    }

    public String getMode() {
        return this.mode.name();
    }

    public String getPrompt() {
        Principal principal = this.actionContext.getSecurityContext().getUser(false);
        StringBuilder buf = new StringBuilder();
        switch (this.mode) {
            case Cypher: 
            case JavaScript: 
            case StructrScript: 
            case AdminShell: {
                if (principal == null) break;
                buf.append(principal.getName());
                break;
            }
            case REST: {
                if (this.username != null) {
                    buf.append(this.username);
                    break;
                }
                buf.append("anonymous");
            }
        }
        buf.append("@");
        buf.append("Structr");
        return buf.toString();
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Map<String, Object> getVariables() {
        return this.actionContext.getAllVariables();
    }

    public void store(String key, Object value) {
        this.actionContext.store(key, value);
    }

    public Object retrieve(String key) {
        return this.actionContext.retrieve(key);
    }

    private void runCypher(String line, Writable writable) throws FrameworkException, IOException {
        App app = StructrApp.getInstance((SecurityContext)this.actionContext.getSecurityContext());
        try (Tx tx = app.tx();){
            long t0 = System.currentTimeMillis();
            List result = app.cypher(line, Collections.emptyMap());
            long t1 = System.currentTimeMillis();
            int size = result.size();
            writable.print(new Object[]{"Query returned ", size, " objects in ", t1 - t0, " ms."});
            writable.println();
            writable.println();
            if (size <= 10) {
                writable.print(new Object[]{Functions.get((String)"to_json").apply(this.actionContext, null, new Object[]{result})});
            } else {
                writable.print(new Object[]{"Too many results (> 10), please use LIMIT to reduce the result count of your Cypher query."});
            }
            writable.println();
            tx.success();
        }
    }

    private void runStructrScript(String line, Writable writable) throws FrameworkException, IOException {
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.actionContext.getSecurityContext()).tx();){
            Object result = Functions.evaluate((ActionContext)this.actionContext, null, (String)line);
            if (result != null) {
                writable.println(new Object[]{result.toString()});
            }
            tx.success();
        }
        catch (UnlicensedException ex) {
            ex.log(LoggerFactory.getLogger(Console.class));
        }
    }

    private void runJavascript(String line, Writable writable) throws FrameworkException {
        Context scriptingContext = Context.enter();
        this.init(scriptingContext);
        try (Tx tx = StructrApp.getInstance((SecurityContext)this.actionContext.getSecurityContext()).tx();){
            Object extractedValue = scriptingContext.evaluateString((Scriptable)this.scope, line, "interactive script, line ", 1, null);
            if (this.scriptable.hasException()) {
                throw this.scriptable.getException();
            }
            String output = this.actionContext.getOutput();
            if (output != null && !output.isEmpty()) {
                extractedValue = output;
            }
            if (extractedValue != null) {
                writable.println(new Object[]{extractedValue.toString()});
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            throw fex;
        }
        catch (Throwable t) {
            throw new FrameworkException(422, t.getMessage());
        }
        finally {
            Context.exit();
        }
    }

    private void runAdminShell(String line, Writable writable) throws FrameworkException, IOException {
        List<String> parts = this.splitAndClean(line);
        if (!parts.isEmpty()) {
            AdminConsoleCommand cmd = AdminConsoleCommand.getCommand(parts.get(0));
            if (cmd != null) {
                if (cmd.requiresEnclosingTransaction()) {
                    try (Tx tx = StructrApp.getInstance((SecurityContext)this.actionContext.getSecurityContext()).tx();){
                        cmd.run(this.actionContext.getSecurityContext(), parts, writable);
                        tx.success();
                    }
                } else {
                    cmd.run(this.actionContext.getSecurityContext(), parts, writable);
                }
            } else {
                writable.println(new Object[]{"Unknown command '" + line + "'."});
            }
        } else {
            writable.println(new Object[]{"Syntax error."});
        }
    }

    private void init(Context scriptingContext) {
        scriptingContext.setLanguageVersion(120);
        if (this.scope == null) {
            this.scope = scriptingContext.initStandardObjects();
        }
        if (this.scriptable == null) {
            this.scriptable = new StructrScriptable(this.actionContext, null, scriptingContext);
            this.scriptable.setParentScope((Scriptable)this.scope);
            this.scope.put("Structr", (Scriptable)this.scope, (Object)this.scriptable);
        }
        this.actionContext.clear();
    }

    private List<String> splitAndClean(String src) {
        ArrayList<String> parts = new ArrayList<String>();
        for (String part : src.split("[ ]+")) {
            String trimmed = part.trim();
            if (!StringUtils.isNotBlank((CharSequence)trimmed)) continue;
            parts.add(trimmed);
        }
        return parts;
    }

    private static class PrintWritable
    implements Writable {
        final StringBuilder buf = new StringBuilder();

        private PrintWritable() {
        }

        public void print(Object ... text) throws IOException {
            for (Object o : text) {
                this.buf.append(o);
            }
        }

        public void println(Object ... text) throws IOException {
            for (Object o : text) {
                this.buf.append(o);
            }
            this.println();
        }

        public void println() throws IOException {
            this.buf.append("\r\n");
        }

        public void flush() throws IOException {
        }

        public String getBuffer() {
            return this.buf.toString();
        }
    }

    public static enum ConsoleMode {
        Cypher,
        JavaScript,
        StructrScript,
        AdminShell,
        REST;

    }
}

