/*
 * Decompiled with CFR 0.152.
 */
package org.structr.console.rest;

import com.jayway.restassured.response.Response;
import java.io.IOException;
import org.structr.common.error.FrameworkException;
import org.structr.console.Console;
import org.structr.console.rest.RestCommand;
import org.structr.util.Writable;

public class GetRestCommand
extends RestCommand {
    protected String uri = null;
    protected String body = null;

    @Override
    public void run(Console console, Writable writable) throws FrameworkException, IOException {
        String requestUrl = this.getBaseUrl() + this.getBasePath() + this.uri;
        String trimmed = this.body != null ? this.body.trim() : null;
        Response response = (Response)this.request(console).get(requestUrl, new Object[0]);
        if (trimmed != null && trimmed.startsWith("return ")) {
            Object value = response.jsonPath().get(trimmed.substring(7));
            writable.println(new Object[]{value});
        } else {
            writable.println(new Object[]{"GET ", requestUrl});
            writable.println(new Object[]{response.getStatusLine()});
            writable.print(new Object[]{response.asString()});
        }
    }

    @Override
    public boolean parseNext(String line, Writable writable) throws IOException {
        StringBuilder buf = new StringBuilder();
        boolean singleQuotes = false;
        boolean doubleQuotes = false;
        boolean escaped = false;
        for (char c : line.toCharArray()) {
            if (this.uri == null) {
                switch (c) {
                    case '\\': {
                        escaped = !escaped;
                    }
                    case '\"': {
                        if (escaped) {
                            buf.append(c);
                            break;
                        }
                        doubleQuotes = !doubleQuotes;
                        break;
                    }
                    case '\'': {
                        if (escaped) {
                            buf.append(c);
                            break;
                        }
                        singleQuotes = !singleQuotes;
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case ' ': {
                        if (escaped) {
                            buf.append(c);
                            break;
                        }
                        if (!singleQuotes && !doubleQuotes && this.uri == null) {
                            this.uri = buf.toString();
                            buf.setLength(0);
                            break;
                        }
                        buf.append(c);
                        break;
                    }
                    default: {
                        buf.append(c);
                        break;
                    }
                }
                continue;
            }
            buf.append(c);
        }
        if (singleQuotes || doubleQuotes) {
            writable.println(new Object[]{"Mismatched ", doubleQuotes ? "double" : (singleQuotes ? "single" : ""), " quotes."});
            return false;
        }
        if (this.uri == null) {
            this.uri = buf.toString();
        } else {
            this.body = buf.toString();
        }
        return true;
    }

    @Override
    public void commandHelp(Writable writable) throws IOException {
        writable.println(new Object[]{"Executes a REST GET request and returns the JSON or parts of it."});
    }

    @Override
    public void detailHelp(Writable writable) throws IOException {
        writable.println(new Object[]{"get <URI> [return <jsonPath>] - Executes the given GET request."});
    }

    static {
        RestCommand.registerCommand("get", GetRestCommand.class);
    }
}

